// ConnectionManager.h: interface for the CConnectionManager class.
//
//////////////////////////////////////////////////////////////////////
    
#ifndef __CONNECTIONMANAGER__
#define __CONNECTIONMANAGER__

// Platform specific definitions
#include "../Base/platform.h"

#include "../../Include/Base/Manager.h"

class CConnection;
class CConnectionListener;
class CStringToObjectCollection;
class CLongToObjectCollection;
class CServerSessionDefault;
class CServerSessionDispatcher;
class CConnectionMessage_Close;
class CConnectionMessage_OpenBack;
class CGenericMessage;
class CDispatchMessage;

class CConnectionManager : public CManager  
{
public:
	CConnectionManager();
	virtual ~CConnectionManager();

	CConnection *CreateConnection (void);
	CConnection *CreateConnection (char *name);

	void SetServerBasePort (unsigned short port);
	void SetSessionObjectName (char *name);
	BOOL StartServer (void);

	void AddConnection (CConnection *connection);
	CConnection *GetConnection (char *name);
	CStringToObjectCollection *GetConnectionList (void);
	CConnection *GetConnectionForID (unsigned long id);

	void SetMaxServerConnection (unsigned long number);
	unsigned long GetMaxServerConnection (void);

	unsigned long GetConnectionCount (void);

#ifdef PASS_SSL
	// SSL
	void SetSecuredConnection (BOOL flag);
	void SetCertificateFile (char *file);
	void SetPrivateKeyFile (char *file);
	void SetPrivateKeyPassword (char *pass);
	char *GetPrivateKeyPassword (void);
#endif //PASS_SSL

	// Lock manager
	void Lock (void);
	void Unlock (void);

	void SetConnectionType (char *type);
	char *GetConnectionType (void);

protected:

	PASS_SYNCH lock;

	void Tick (void);

	unsigned long GetNewConnectionID(void);

protected:
    CServerSessionDefault *m_pServerSessionDefault;
    CServerSessionDispatcher *m_pServerSessionDispatcher;
	CStringToObjectCollection *m_ConnectionListByName;
	CLongToObjectCollection *m_ConnectionListByID;
	CConnectionListener *m_Listener;
	char *m_SessionName;
	unsigned short m_ServerPort;
	unsigned short m_ClientReceivePort;
	BOOL m_IsServerStarted;
	unsigned long m_ConnectionCount;
	unsigned long  m_ulMaxServerConnection;
	char m_szConnectionType[20];
	unsigned long m_ulConnectionIDCounter;
    CConnectionMessage_Close *m_pMsgClose;
    CConnectionMessage_OpenBack *m_pMsgOpenBack;
    CGenericMessage *m_pMsgGeneric;
    CDispatchMessage *m_pMsgDispatch;

#ifdef PASS_SSL
	// SSL
	BOOL m_bSecuredConnection;
	char *m_szCertificateFile;
	char *m_szPrivateKeyFile;
	char m_szPrivateKeyPassword[256];
#endif //PASS_SSL
};
    
#endif // __CONNECTIONMANAGER__
