/*
 * Decompiled with CFR 0.152.
 */
package be.belgium.eid;

import be.belgium.eid.BEID_Address;
import be.belgium.eid.BEID_Applet_jButtonRead_actionAdapter;
import be.belgium.eid.BEID_Bytes;
import be.belgium.eid.BEID_Certif_Check;
import be.belgium.eid.BEID_ID_Data;
import be.belgium.eid.BEID_Long;
import be.belgium.eid.BEID_Raw;
import be.belgium.eid.BEID_Status;
import be.belgium.eid.eidlib;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class BEID_Applet
extends JApplet {
    protected BEID_ID_Data m_idData = null;
    protected BEID_Address m_addrData = null;
    protected BEID_Raw m_oRaw = null;
    protected String m_strReader = null;
    protected int m_OCSP = 0;
    protected int m_CRL = 0;
    protected boolean m_bWarning = true;
    JButton jButtonRead = new JButton();
    JLabel lblImage = new JLabel();
    Container cont = this.getContentPane();

    public BEID_Applet() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void init() {
        try {
            String strWarn;
            String strCRL;
            System.loadLibrary("eidlibj");
            this.m_idData = null;
            this.m_addrData = null;
            this.m_oRaw = null;
            this.m_strReader = this.getParameter("Reader");
            String strOCSP = this.getParameter("OCSP");
            if (strOCSP != null) {
                this.m_OCSP = Integer.parseInt(strOCSP);
            }
            if ((strCRL = this.getParameter("CRL")) != null) {
                this.m_CRL = Integer.parseInt(strCRL);
            }
            if ((strWarn = this.getParameter("DisableWarning")) != null && 0 == strWarn.compareToIgnoreCase("true")) {
                this.m_bWarning = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
        this.m_idData = null;
        this.m_addrData = null;
        this.m_oRaw = null;
    }

    public int InitLib(String strReader) {
        this.m_idData = null;
        this.m_addrData = null;
        this.m_oRaw = null;
        this.lblImage.setIcon(null);
        if (strReader != null) {
            this.m_strReader = strReader;
        }
        BEID_Long CardHandle = new BEID_Long();
        BEID_Status oStatus = eidlib.BEID_Init(this.m_strReader, this.m_OCSP, this.m_CRL, CardHandle);
        return oStatus.getGeneral();
    }

    public int ExitLib() {
        this.m_idData = null;
        this.m_addrData = null;
        this.m_oRaw = null;
        BEID_Status oStatus = eidlib.BEID_Exit();
        return oStatus.getGeneral();
    }

    protected boolean CheckIDData() {
        boolean bRet = true;
        try {
            if (this.m_idData == null) {
                this.m_idData = new BEID_ID_Data();
                Locale l = Locale.getDefault();
                String strTemp = this.getResourceString(l, "ReadID");
                if (!this.ShowDialog(strTemp)) {
                    return false;
                }
                BEID_Certif_Check CertCheck = new BEID_Certif_Check();
                BEID_Status oStatus = eidlib.BEID_GetID(this.m_idData, CertCheck);
                if (0 == oStatus.getGeneral()) {
                    return true;
                }
                this.m_idData = null;
                bRet = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            bRet = false;
        }
        return bRet;
    }

    protected boolean CheckAddrData() {
        boolean bRet = true;
        try {
            if (this.m_addrData == null) {
                this.m_addrData = new BEID_Address();
                Locale l = Locale.getDefault();
                String strTemp = this.getResourceString(l, "ReadAddr");
                if (!this.ShowDialog(strTemp)) {
                    return false;
                }
                BEID_Certif_Check CertCheck = new BEID_Certif_Check();
                BEID_Status oStatus = eidlib.BEID_GetAddress(this.m_addrData, CertCheck);
                if (0 == oStatus.getGeneral()) {
                    return true;
                }
                this.m_addrData = null;
                bRet = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            bRet = false;
        }
        return bRet;
    }

    protected boolean CheckRawData() {
        boolean bRet = true;
        try {
            if (this.m_oRaw == null) {
                this.m_oRaw = new BEID_Raw();
                Locale l = Locale.getDefault();
                String strTemp = this.getResourceString(l, "ReadRaw");
                if (!this.ShowDialog(strTemp)) {
                    return false;
                }
                BEID_Status oStatus = eidlib.BEID_GetRawData(this.m_oRaw);
                if (0 == oStatus.getGeneral()) {
                    return true;
                }
                this.m_oRaw = null;
                bRet = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            bRet = false;
        }
        return bRet;
    }

    protected String getResourceString(Locale l, String Key2) {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle("be.belgium.eid.LabelsBundle", l);
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
        }
        if (bundle == null) {
            try {
                bundle = ResourceBundle.getBundle("be.belgium.eid.LabelsBundle", Locale.ENGLISH);
            }
            catch (MissingResourceException e) {
                e.printStackTrace();
            }
            if (bundle == null) {
                return null;
            }
            return (String)bundle.getObject(Key2);
        }
        return (String)bundle.getObject(Key2);
    }

    protected boolean ShowDialog(String strFunction) {
        if (!this.m_bWarning) {
            return true;
        }
        try {
            JPanel messagePanel = new JPanel();
            messagePanel.setLayout(new BoxLayout(messagePanel, 1));
            Locale l = Locale.getDefault();
            String strTemp = this.getResourceString(l, "AppLabel");
            messagePanel.add(new JLabel(strTemp));
            messagePanel.add(new JLabel("   "));
            strTemp = this.getResourceString(l, "Function");
            messagePanel.add(new JLabel(strTemp));
            messagePanel.add(new JLabel(strFunction));
            messagePanel.add(new JLabel("   "));
            strTemp = this.getResourceString(l, "URL");
            messagePanel.add(new JLabel(strTemp));
            messagePanel.add(new JLabel(this.getDocumentBase().getFile()));
            messagePanel.add(new JLabel("  "));
            strTemp = this.getResourceString(l, "Accept");
            messagePanel.add(new JLabel(strTemp));
            messagePanel.add(new JLabel("  "));
            JOptionPane pane = new JOptionPane(messagePanel, 2, 0);
            strTemp = this.getResourceString(l, "Title");
            JDialog dialog = pane.createDialog(this, strTemp);
            dialog.setModal(true);
            pane.setLocale(l);
            this.centerScreen(dialog);
            dialog.show();
            Object selectedValue = pane.getValue();
            if (selectedValue == null) {
                return false;
            }
            if ((Integer)selectedValue == 0) {
                return true;
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return false;
    }

    public void centerScreen(JDialog dialog) {
        Dimension dim = this.getToolkit().getScreenSize();
        dialog.setLocation((dim.width - dialog.getWidth()) / 2, (dim.height - dialog.getHeight()) / 2);
        dialog.requestFocus();
    }

    public String getCardNumber() {
        if (this.CheckIDData()) {
            return this.m_idData.getCardNumber();
        }
        return "";
    }

    public String getChipNumber() {
        if (this.CheckIDData()) {
            return this.m_idData.getChipNumber();
        }
        return "";
    }

    public String getValidityDateBegin() {
        if (this.CheckIDData()) {
            return this.m_idData.getValidityDateBegin();
        }
        return "";
    }

    public String getValidityDateEnd() {
        if (this.CheckIDData()) {
            return this.m_idData.getValidityDateEnd();
        }
        return "";
    }

    public String getIssMunicipality() {
        if (this.CheckIDData()) {
            return this.m_idData.getMunicipality();
        }
        return "";
    }

    public String getNationalNumber() {
        if (this.CheckIDData()) {
            return this.m_idData.getNationalNumber();
        }
        return "";
    }

    public String getName() {
        if (this.CheckIDData()) {
            return this.m_idData.getName();
        }
        return "";
    }

    public String getFirstName1() {
        if (this.CheckIDData()) {
            return this.m_idData.getFirstName1();
        }
        return "";
    }

    public String getFirstName2() {
        if (this.CheckIDData()) {
            return this.m_idData.getFirstName2();
        }
        return "";
    }

    public String getFirstName3() {
        if (this.CheckIDData()) {
            return this.m_idData.getFirstName3();
        }
        return "";
    }

    public String getNationality() {
        if (this.CheckIDData()) {
            return this.m_idData.getNationality();
        }
        return "";
    }

    public String getBirthLocation() {
        if (this.CheckIDData()) {
            return this.m_idData.getBirthLocation();
        }
        return "";
    }

    public String getBirthDate() {
        if (this.CheckIDData()) {
            return this.m_idData.getBirthDate();
        }
        return "";
    }

    public String getSex() {
        if (this.CheckIDData()) {
            return this.m_idData.getSex();
        }
        return "";
    }

    public String getNobleCondition() {
        if (this.CheckIDData()) {
            return this.m_idData.getNobleCondition();
        }
        return "";
    }

    public int getDocumentType() {
        if (this.CheckIDData()) {
            return this.m_idData.getDocumentType();
        }
        return 0;
    }

    public boolean getWhiteCane() {
        if (this.CheckIDData()) {
            return this.m_idData.getWhiteCane();
        }
        return false;
    }

    public boolean getYellowCane() {
        if (this.CheckIDData()) {
            return this.m_idData.getYellowCane();
        }
        return false;
    }

    public boolean getExtendedMinority() {
        if (this.CheckIDData()) {
            return this.m_idData.getExtendedMinority();
        }
        return false;
    }

    public String getStreet() {
        if (this.CheckAddrData()) {
            return this.m_addrData.getStreet();
        }
        return "";
    }

    public String getStreetNumber() {
        if (this.CheckAddrData()) {
            return this.m_addrData.getStreetNumber();
        }
        return "";
    }

    public String getBoxNumber() {
        if (this.CheckAddrData()) {
            return this.m_addrData.getBoxNumber();
        }
        return "";
    }

    public String getZip() {
        if (this.CheckAddrData()) {
            return this.m_addrData.getZip();
        }
        return "";
    }

    public String getMunicipality() {
        if (this.CheckAddrData()) {
            return this.m_addrData.getMunicipality();
        }
        return "";
    }

    public String getCountry() {
        if (this.CheckAddrData()) {
            return this.m_addrData.getCountry();
        }
        return "";
    }

    public byte[] GetPicture() {
        Locale l = Locale.getDefault();
        String strTemp = this.getResourceString(l, "ReadPic");
        if (!this.ShowDialog(strTemp)) {
            return null;
        }
        BEID_Bytes PictureData = new BEID_Bytes();
        BEID_Certif_Check CertCheck = new BEID_Certif_Check();
        BEID_Status oStatus = eidlib.BEID_GetPicture(PictureData, CertCheck);
        if (0 == oStatus.getGeneral()) {
            try {
                Rectangle abounds = this.getBounds();
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Image tempImage = toolkit.createImage(PictureData.getData());
                this.lblImage.setIcon(new ImageIcon(tempImage.getScaledInstance(abounds.width, abounds.height, 4)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return PictureData.getData();
        }
        return null;
    }

    public int SetRawData(byte[] IDData, byte[] SigIDData, byte[] AddrData, byte[] SigAddrData, byte[] PictureData, byte[] RNData, byte[] cardData, byte[] tokenInfoData, byte[] challengeData, byte[] responseData) {
        this.m_oRaw = null;
        this.m_oRaw = new BEID_Raw();
        this.m_oRaw.setAddrData(AddrData);
        this.m_oRaw.setAddrSigData(SigAddrData);
        this.m_oRaw.setCardData(cardData);
        this.m_oRaw.setCertRN(RNData);
        this.m_oRaw.setChallenge(challengeData);
        this.m_oRaw.setIdData(IDData);
        this.m_oRaw.setIdSigData(SigIDData);
        this.m_oRaw.setPictureData(PictureData);
        this.m_oRaw.setResponse(responseData);
        this.m_oRaw.setTokenInfo(tokenInfoData);
        BEID_Status oStatus = eidlib.BEID_SetRawData(this.m_oRaw);
        return oStatus.getGeneral();
    }

    public byte[] GetRawIDData() {
        if (this.CheckRawData()) {
            return this.m_oRaw.getIdData();
        }
        return null;
    }

    public byte[] GetRawSigIDData() {
        if (this.CheckRawData()) {
            return this.m_oRaw.getIdSigData();
        }
        return null;
    }

    public byte[] GetRawAddrData() {
        if (this.CheckRawData()) {
            return this.m_oRaw.getAddrData();
        }
        return null;
    }

    public byte[] GetRawSigAddrData() {
        if (this.CheckRawData()) {
            return this.m_oRaw.getAddrSigData();
        }
        return null;
    }

    public byte[] GetRawPictureData() {
        if (this.CheckRawData()) {
            return this.m_oRaw.getPictureData();
        }
        return null;
    }

    public byte[] GetRawCardData() {
        if (this.CheckRawData()) {
            return this.m_oRaw.getCardData();
        }
        return null;
    }

    public byte[] GetRawTokenInfoData() {
        if (this.CheckRawData()) {
            return this.m_oRaw.getTokenInfo();
        }
        return null;
    }

    public byte[] GetRawRNData() {
        if (this.CheckRawData()) {
            return this.m_oRaw.getCertRN();
        }
        return null;
    }

    public byte[] GetRawChallengeData() {
        if (this.CheckRawData()) {
            return this.m_oRaw.getChallenge();
        }
        return null;
    }

    public byte[] GetRawResponseData() {
        if (this.CheckRawData()) {
            return this.m_oRaw.getResponse();
        }
        return null;
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"Reader", "String", "Card Reader name"}, {"OCSP", "0-2", "OCSP checking"}, {"CRL", "0-2", "CRL checking"}};
        return pinfo;
    }

    public String getAppletInfo() {
        return "Belgian EID Middelware Applet";
    }

    private void jbInit() throws Exception {
        this.jButtonRead.setActionCommand("jButtonRead");
        this.jButtonRead.setText("Read");
        this.jButtonRead.addActionListener(new BEID_Applet_jButtonRead_actionAdapter(this));
        this.cont.add(this.lblImage);
    }

    public void jButtonRead_actionPerformed(ActionEvent e) {
        if (0 == this.InitLib(null)) {
            this.CheckIDData();
            this.CheckAddrData();
            this.GetPicture();
            this.ExitLib();
        }
    }
}

