<?php

/*
Superclass for all static pages.
This class gives static pages the ability to
apply filters.
*/

class PageFilter extends Page {

var $filters = array();
var $filterobjs = array();

function init() {
	parent::init();
	foreach($this->filters as $filter) {
		if (!class_exists($filter))
			require_once("filters/$filter.php");
		$this->filterobjs[$filter] = new $filter();
	}		
}

function &getDisplay() {
	$display = $this->get('content');
	if ($display == '') {
		$display = $this->indexinfo();
	}
	else {
		foreach($this->filterobjs as $filter) {
			$filter->apply($display,$this);
		}
	}
	return $display;
}

function indexinfo() {
	$children = $this->children();
	foreach($children as $child) {
		$ret .= "<dl class=index>\n";
		$ret .= "<dt>" . alink($child->path .'/',$child->get('title')) . "</dt>\n";
		$ret .= "<dd>" . $child->get('description') . "</dd>\n";
		$ret .= "</dl>\n";
	}
	return $ret;
}

} // end class

return;
?>
