<?php

#########################################################
# IndexFactory

class IndexFactory {
	function create($configstr) {
		$directory = dirname(__FILE__) . "/indexstores";
		$args = explode(',',$configstr);
		$class = ucfirst($args[0]) . "IndexStore";
		$file = "$directory/$class.php";
		if (!is_file($file))
			die(_("Could not find user storage backend") . ": " . $args[0]);
		require_once($file);
		return new $class(trim($args[1]));
	}
}

#########################################################
# Index

class IndexStore {

	// return true if initialization was successful
	function init() {}
	
	// mode one of 'r' or 'w' for read or write.
	function open($mode) {}
	function close() {}
	
	// these return a list of paths matching the criteria
	function getByKeyword($keyword) {}
	function getByContent($str) {}
	function getByModTime($timestamp) {}
	
	// sets the index info for a page 
	// destroys previous indexes for the page
	function setContent($path, $content) {} 
	function setKeywords($path, $keywords) {} 
	function setModTime($path, $timestamp) {}
	
	// returns the timestamp when a particular page was indexed.
	// returns 0 if not set.
	function getIndexedTime($patb) {}

	// updates the timestamp when we index a page.
	function setIndexedTime($path,$timestamp) {}
	
	// removes all index entries which refer to $path
	function remove($path) {}
	
	// renames $pathold to $pathnew
	function rename($pathold, $pathnew) {}
	
}


return;
?>
