<?php

class Changes {

function Changes(&$page,&$search) {
	$this->page = &$page;
	$this->search = &$search;
}

function getpaths() {
	$limit = get('limit',15);
	$offset = get('offset',0);
	$ago = get('ago',30); // number of days from today
	$ago = time() - ($ago*60*60*24);
	return $this->search->recentChanges($this->page,$offset,$limit,$ago);
}

function title() {
	$rc = _("Recent Changes");
	if (!$this->page->path and $sitename = $this->page->get('sitename'))
		return "$rc: $sitename";
	elseif ($title = $this->page->get('title'))
		return "$rc: $title";
	else
		return $rc;
}

function results($pages,&$ps) {
	$paths = $this->getpaths();
	$changetitle = $this->title();
	$str .= '<div id="changes">';
	$str .= "<h2>$changetitle</h2>";
	foreach ($paths as $path) {
		$page = $ps->getPage($path);
		$title = $page->get('title');
		$description = $page->get('description');
		$time = $page->get('mtime');
		$date = date("Y-m-d", $time);
		if ($title == '') $title = "Untitled";
		$str .= "<p class=\"item\">\n<div class=\"title\">";
		$str .= alink("$path/",$title);
		$str .= "</div>\n";
		$str .= $description;
		$str .= "<div class=\"date\">$date</div>";
		$str .= "</p>\n";
	}
	$str .= "</div>";
	return $str;
}
	
function resultsRSS($pages,&$ps) {
	global $root;

	$paths = $this->getpaths();
	$title = $this->title();
	$link = http::absoluteUrl(preg_replace("/(\?.*)$/",'',$_SERVER['REQUEST_URI']));

	$xml = '<?xml version="1.0"?>
<rss version="2.0">
<channel>
<language>en</language>
<description></description>
';
	$xml .= "<link>$link</link>\n";
	$xml .= "<title>$title</title>\n";
	
	foreach ($paths as $path) {
		$page = $ps->getPage($path);
		$title = $page->get('title','Untitled');
		$description = $page->get('description');
		$time = $page->get('mtime');
		$date = date("D M j G:i:s T Y",$time);
		$xml .= "<item>\n";
		$xml .= "<title>$title</title>\n";
		$xml .= "<link>" . http::absoluteUrl("$root$path/") . "</link>\n";
		$xml .= "<pubDate>$date</pubDate>\n";
		$xml .= "<description>$description</description>\n";
		$xml .= "</item>\n";
	}
	
	$xml .= "</channel>\n";
	$xml .= "</rss>\n";
	return $xml;
}

} // end class

return;
?>
