<?php 

/*******************************************
 * 
 * PageStore
 * An abstract super class for storing and retrieving pages
 * 
 ******************************************/

require_once('Properties.php');

#########################################################
# PageStoreFactory

class PageStoreFactory {
	function create($configstr,&$prop) {
		$directory = dirname(__FILE__) . "/pagestores";
		$args = explode(',',$configstr);
		$class = ucfirst($args[0]) . "PageStore";
		$file = "$directory/$class.php";
		if (!is_file($file))
			die(_("Could not find page storage backend:") . $args[0]);
		require_once($file);
		return new $class($prop);
	}
}

#########################################################
# PageStore

class PageStore {

var $urlRoot;
var $documentRoot;
var $prop;

function init(&$page) {}

function PageStore(&$prop) {
	$this->prop = &$prop;
	$this->urlRoot = preg_replace('#/$#','',$prop->getGlobal('siteroot')); 
	$this->documentRoot = preg_replace('#/$#','',$_SERVER['DOCUMENT_ROOT']);
}

function getPage($path='') {
	return new Page($this, $path);
}

/*
 * fetch(Page $page)
 * loads contents of $page into memory, stored in $page.
 * we also update any page variables which we discovered
 * in the process of loading the file.
 */
 
function &fetch(&$page) {}

/*
 * loadbasic(Page $page)
 * load contents of basic info for $page into
 * page object. this includes:
 * - title
 * - page name
 * - 
 
function loadbasic(&$page) {}

function loadprops(&$page) {}

/* 
 * saves content and properties which have changed
 * back to permanent storage
 */
 
function commit(&$page) {}

/*
 * creates a new page as child of $parent
 * returns $page.
 */
function &addChild(&$parent, $name, $type) {}

/*
 * removes a page from storage
 */
function deletePage(&$page) {}

/*
 * movePage(Page $from, Page $to)
 */
function &movePage(&$from, &$to) {}

/*
 * duplicatePage(Page $from, Page $to)
 */
function &duplicatePage(&$from, &$to) {}


function getNextPage($page) {}
function getPrevPage($page) {}
function getFirstChild($page) {}
function getChildren($page) {}

} // end class

return;
?>
