/* ------------------------------------------------------------------------
 * $Id: MapperImpl.hh,v 1.2 2001/08/21 02:09:44 steve Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-08-18 by Steve Houston
 *
 * Copyright (c) 2001 Steve Houston <steve@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _MapperImpl_hh_
#define _MapperImpl_hh_

// -- System Includes

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Nobel/Mapper.hh"
#include "Polhem/TransformImpl.hh"

// -- Forward Declarations

// -- Class Declarations

class MapperImpl : public virtual POA_Nobel::Mapper,
		   public virtual PortableServer::RefCountServantBase
{

public:
    
    /**
     * Constructor
     **/
    MapperImpl();

    /**
     * Destructor
     **/
    virtual ~MapperImpl();

    // IDL functions

    virtual Nobel::TexCoord map(const Nobel::Vertex3D &v) = 0;
    virtual void scale(const Nobel::Vertex3D &v);

protected:
    TransformImpl *_transform;

};



class PlanarMapperImpl : public MapperImpl
{

public:

    /**
     * Constructor
     */
    PlanarMapperImpl();

    /**
     * Destructor
     */
    virtual ~PlanarMapperImpl();

    // IDL functions
    virtual Nobel::TexCoord map(const Nobel::Vertex3D &v);
};

#endif /* MapperImpl.hh */
