/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util;

public class Progress implements Comparable
{

    //--- Constant(s) ---

    //--- Data field(s) ---

    public double progress;
    public long rate;

    //--- Constructor(s) ---

    public Progress(double progress, long rate)
    {
	this.progress = (progress > 100) ? 100 : progress;
	this.rate = rate;
    }

    public Progress(long size, long total, long rate)
    {
	this((total <= 0 || size <= 0) ? 0 : ((double)(size * 100) / total), 
	     rate);
    }

    //--- Method(s) ---

    /**
     * Use a higher precission to make a difference between 0 progress and 0.5. 
     */
    public int compareTo(Object o)
    {
	return (int)((progress - ((Progress)o).progress) * 100);
    }

    public String toString()
    {
	if (rate < 0) {
	    return "";
	}
	else if (rate == 0) {
	    return "stalled";
	}
	else {
	    return Formatter.formatSize(rate) + "/s";
	}
    }

}
