/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.plugin.nap.net.msg.server;

import xnap.plugin.nap.net.Server;
import xnap.plugin.nap.net.msg.Message;
import xnap.util.QuotedStringTokenizer;

public class ServerMessage extends Message {

    //--- Data Field(s) ---

    protected Server server;
    protected String data;
    protected boolean consumed = false;

    //--- Constructor(s) ---

    protected ServerMessage(int type, String data, int argc)
	throws InvalidMessageException
    {
	super(type);

	this.data = data;

	QuotedStringTokenizer t = new QuotedStringTokenizer(data);

	if (t.countTokens() < argc) {
	    throw new InvalidMessageException("Wrong number of arguments.");
	}

	try {
	    parse(t);
	}
	catch (Exception e) {
	    throw new InvalidMessageException("Wrong type of argument.");
	}
    }

    //--- Method(s) ---

    /** 
     * Tell message to handle itself.
     */
    public void received()
    {
    }

    /**
     * Message can be consumed: if the right listener gets the message, he
     * consumes it and the other listeners won't get it.
     */
    public void consume()
    {
	consumed = true;
    }

    /**
     * See if message is already consumed.
     */
    public boolean isConsumed()
    {
	return consumed;
    }

    public Server getServer() 
    {
	return server;
    }
    
    public void setServer(Server newValue)
    {
	server = newValue;
    }

    public String toString()
    {
	return data;
    }

    protected void parse(QuotedStringTokenizer t) throws Exception
    {
    }
    
}
