/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.plugin.nap.net.msg.server;

import xnap.plugin.nap.net.Server;

public class MessageFactory {

    //--- Data Field(s) ---

    public static final int LOGIN_ERROR = 0;
    public static final int LOGIN_ACK = 3;
    public static final int NICK_NOT_REGISTERED = 8;
    public static final int NICK_ALREADY_REGISTERED = 9;
    public static final int INVALID_NICK = 10;
    public static final int UNSHARE_ALL_FILES = 110;
    public static final int SEARCH_RESPONSE = 201;
    public static final int END_SEARCH_RESPONSE = 202;
    public static final int DOWNLOAD_ACK = 204;
    public static final int PRIVATE_MESSAGE = 205;
    public static final int GET_ERROR = 206;
    public static final int USER_SIGNON = 209;
    public static final int USER_SIGNOFF = 210;
    public static final int BROWSE_RESPONSE = 212;
    public static final int END_BROWSE_LIST = 213;
    public static final int SERVER_STATS = 214;
    public static final int RESUME_SEARCH_RESPONSE = 216;
    public static final int END_RESUME_SEARCH = 217;
    public static final int HOTLIST_ACK = 301;
    public static final int HOTLIST_ERROR = 302;
    public static final int CLIENT_DISCONNECT = 316;
    public static final int USER_IGNORE_LIST = 320;
    public static final int USER_IGNORE_LIST_ENTRY = 321;
    public static final int ADD_USER_TO_IGNORE_LIST = 322;
    public static final int USER_NOT_IGNORED = 324;
    public static final int USER_ALREADY_IGNORED = 325;
    public static final int CLEAR_IGNORE_LIST = 326;
    public static final int PART_CHANNEL = 401;
    public static final int PUBLIC_MESSAGE = 403;
    public static final int ERROR_MESSAGE = 404;
    public static final int JOIN_ACK = 405;
    public static final int JOIN_MESSAGE = 406;
    public static final int USER_PARTED_CHANNEL = 407;
    public static final int CHANNEL_USER_LIST_ENTRY = 408;
    public static final int END_CHANNEL_USER_LIST = 409;
    public static final int CHANNEL_BAN_LIST = 420;
    public static final int CHANNEL_BAN_LIST_ENTRY = 421;
    public static final int CHANNEL_MOTD = 425;
    public static final int INVITE_USER = 430;
    public static final int ALTERNATE_DOWNLOAD_ACK = 501;
    public static final int SPEED_RESPONSE = 601;
    public static final int WHOIS_RESPONSE = 604;
    public static final int WHOWAS_RESPONSE = 605;
    public static final int UPLOAD_REQUEST = 607;
    public static final int ACCEPT_FAILED = 609;
    public static final int SET_DATA_PORT = 613;
    public static final int BAN_LIST_ENTRY = 616;
    public static final int LIST_CHANNELS = 617;
    public static final int CHANNEL_LIST_ENTRY = 618;
    public static final int QUEUE_LIMIT = 620;
    public static final int MOTD = 621;
    public static final int DATA_PORT_ERROR = 626;
    public static final int OPERATOR_MESSAGE = 627;
    public static final int GLOBAL_MESSAGE = 628;
    public static final int BANNED_USERS = 629;
    public static final int DIRECT_BROWSE_REQUEST = 640;
    public static final int DIRECT_BROWSE_ACCEPT = 641;
    public static final int DIRECT_BROWSE_ERROR = 642;
    public static final int LOGIN_ATTEMPT = 748;
    public static final int SERVER_PING = 750;
    public static final int PING_USER = 751;
    public static final int PONG_RESPONSE = 752;
    public static final int CYCLE_CLIENT = 822;
    public static final int EMOTE = 824;
    public static final int USER_LIST_ENTRY = 825;
    public static final int END_CHANNEL_LIST = 827;
    public static final int CHANNEL_LIST = 828;
    public static final int END_USER_LIST = 830;
    public static final int CONNECTION_TEST = 900;
    public static final int LISTEN_TEST = 901;
    public static final int BLOCKED_FILE = 931;

    //--- Constructor(s) ---

    //--- Method(s) ---

    public static ServerMessage create(Server source, int type, String data) 
	throws InvalidMessageException
    {
	ServerMessage msg;

	switch (type) {
	case LoginErrorMessage.TYPE:
	    msg = new LoginErrorMessage(data);
	    break;
	case LOGIN_ACK:
	    msg = new LoginAckMessage(data);
	    break;
	case NICK_NOT_REGISTERED:
	    msg = new NickNotRegisteredMessage(data);
	    break;
	case NICK_ALREADY_REGISTERED:
	    msg = new NickAlreadyRegisteredMessage(data);
	    break;
  	case INVALID_NICK:
  	    msg = new InvalidNickMessage(data);
  	    break;
	case UNSHARE_ALL_FILES:
	    msg = new UnshareAllFilesMessage(data);
	    break;
	case SEARCH_RESPONSE:
	    msg = new SearchResponseMessage(data);
	    break;
	case END_SEARCH_RESPONSE:
	    msg = new EndSearchMessage(data);
	    break;
	case DOWNLOAD_ACK:
	    msg = new DownloadAckMessage(data);
	    break;
	case PRIVATE_MESSAGE:
	    msg = new PrivateMessage(data);
	    break;
	case GET_ERROR:
	    msg = new GetErrorMessage(data);
	    break;
  	case USER_SIGNON:
  	    msg = new UserSignonMessage(data);
  	    break;
	case USER_SIGNOFF:
	    msg = new UserSignoffMessage(data);
	    break;
	case BROWSE_RESPONSE:
	    msg = new BrowseResponseMessage(data);
	    break;
	case END_BROWSE_LIST:
	    msg = new EndBrowseMessage(data);
	    break;
	case SERVER_STATS:
	    msg = new ServerStatsMessage(data);
	    break;
//  	case RESUME_SEARCH_RESPONSE:
//  	    msg = new ResumeSearchResponseMessage(data);
//  	    break;
//  	case END_RESUME_SEARCH:
//  	    msg = new EndResumeSearchResponseMessage(data);
//  	    break;
	case HotlistAckMessage.TYPE:
	    msg = new HotlistAckMessage(data);
	    break;
	case HotlistErrorMessage.TYPE:
	    msg = new HotlistErrorMessage(data);
	    break;
	case CLIENT_DISCONNECT:
	    msg = new ClientDisconnectMessage(data);
	    break;
//  	case USER_IGNORE_LIST:
//  	    msg = new UserIgnoreListMessage(data);
//  	    break;
//  	case USER_IGNORE_LIST_ENTRY:
//  	    msg = new UserIgnoreListEntryMessage(data);
//  	    break;
//  	case ADD_USER_TO_IGNORE_LIST:
//  	    msg = new AddUserToIgnoreListMessage(data);
//  	    break;
//  	case USER_NOT_IGNORED:
//  	    msg = new UserNotIgnoredMessage(data);
//  	    break;
//  	case USER_ALREADY_IGNORED:
//  	    msg = new UserAlreadyIgnoredMessage(data);
//  	    break;
//  	case CLEAR_IGNORE_LIST:
//  	    msg = new ClearIgnoreListMessage(data);
//  	    break;
  	case PART_CHANNEL:
  	    msg = new PartChannelMessage(data);
  	    break;
  	case PUBLIC_MESSAGE:
  	    msg = new PublicMessage(data);
  	    break;
	case ErrorMessage.TYPE:
	    msg = new ErrorMessage(data);
	    break;
  	case JOIN_ACK:
  	    msg = new JoinAckMessage(data);
  	    break;
  	case JOIN_MESSAGE:
  	    msg = new JoinMessage(data);
  	    break;
    	case USER_PARTED_CHANNEL:
    	    msg = new UserPartedChannelMessage(data);
    	    break;
	case CHANNEL_USER_LIST_ENTRY:
	    msg = new ChannelUserListEntryMessage(data);
	    break;
  	case END_CHANNEL_USER_LIST:
  	    msg = new EndChannelUserListMessage(data);
  	    break;
    	case ChannelTopicMessage.TYPE:
    	    msg = new ChannelTopicMessage(data);
    	    break;
//  	case CHANNEL_BAN_LIST:
//  	    msg = new EndChannelBanListMessage(data);
//  	    break;
//  	case CHANNEL_BAN_LIST_ENTRY:
//  	    msg = new ChannelBanListEntryMessage(data);
//  	    break;
//  	case CHANNEL_MOTD:
//    	    msg = new ChannelMotdMessage(data);
//    	    break;
//    	case INVITE_USER:
//    	    msg = new InviteUserMessage(data);
//    	    break;
  	case ALTERNATE_DOWNLOAD_ACK:
  	    msg = new AltDownloadAckMessage(data);
  	    break;
//  	case SPEED_RESPONSE:
//  	    msg = new LinkSpeedResponseMessage(data);
//  	    break;
  	case WHOIS_RESPONSE:
  	    msg = new WhoisResponseMessage(data);
  	    break;
  	case WHOWAS_RESPONSE:
  	    msg = new WhowasResponseMessage(data);
  	    break;
	case UPLOAD_REQUEST:
	    msg = new UploadRequestMessage(data);
	    break;
  	case ACCEPT_FAILED:
  	    msg = new AcceptFailedMessage(data);
  	    break;
//  	case SET_DATA_PORT:
//  	    msg = new SetDataPortForUserMessage(data);
//  	    break;
//  	case BAN_LIST_ENTRY:
//  	    msg = new BanListEntryMessage(data);
//  	    break;
  	case LIST_CHANNELS:
	    msg = new EndChannelListMessage(data);
	    break;
	case CHANNEL_LIST_ENTRY:
	    msg = new ChannelListEntryMessage(data);
	    break;
  	case QUEUE_LIMIT:
  	    msg = new QueueLimitMessage(data);
  	    break;
	case MOTD:
	    msg = new MotdMessage(data);
	    break;
//  	case DATA_PORT_ERROR:
//  	    msg = new DataPortErrorMessage(data);
//  	    break;
//  	case OPERATOR_MESSAGE:
//  	    msg = new OperatorMessage(data);
//  	    break;
  	case GLOBAL_MESSAGE:
  	    msg = new GlobalMessage(data);
  	    break;
//  	case BANNED_USERS:
//  	    msg = new BannedUsersMessage(data);
//  	    break;
  	case DIRECT_BROWSE_REQUEST:
  	    msg = new DirectBrowseRequestMessage(data);
  	    break;
  	case DIRECT_BROWSE_ACCEPT:
  	    msg = new DirectBrowseAckMessage(data);
  	    break;
  	case DIRECT_BROWSE_ERROR:
  	    msg = new DirectBrowseErrorMessage(data);
  	    break;
	case LOGIN_ATTEMPT:
	    msg = new LoginAttemptMessage(data);
	    break;
	case SERVER_PING:
	    msg = new PingMessage(data);
	    break;
  	case PING_USER:
  	    msg = new PingUserMessage(data);
  	    break;
  	case PONG_RESPONSE:
  	    msg = new PongUserMessage(data);
  	    break;
  	case RedirectClientMessage.TYPE:
  	    msg = new RedirectClientMessage(data);
  	    break;
//  	case CYCLE_CLIENT:
//  	    msg = new CycleClientMessage(data);
//  	    break;
  	case EMOTE:
  	    msg = new EmoteMessage(data);
  	    break;
//  	case USER_LIST_ENTRY:
//  	    msg = new UserListEntryMessage(data);
//  	    break;
	case END_CHANNEL_LIST:
	    msg = new EndAllChannelListMessage(data);
	    break;
  	case CHANNEL_LIST:
  	    msg = new AllChannelListEntryMessage(data);
  	    break;
//  	case END_USER_LIST:
//  	    msg = new EndUserListMessage(data);
//  	    break;
//  	case CONNECTION_TEST:
//  	    msg = new ConnectionTestMessage(data);
//  	    break;
//  	case LISTEN_TEST:
//  	    msg = new ListenTestMessage(data);
//  	    break;
	case BLOCKED_FILE:
	    msg = new BlockedFileMessage(data);
	    break;
	case ServerLinksMessage.TYPE:
	    msg = new ServerLinksMessage(data);
	    break;
	case ServerStatisticsMessage.TYPE:
	    msg = new ServerStatisticsMessage(data);
	    break;
	case ClientStatisticsMessage.TYPE:
	    msg = new ClientStatisticsMessage(data);
	    break;
  	default:
	    throw new InvalidMessageException("Unknown message type: "
					      + type + " " + data);
	}

	msg.setServer(source);

	return msg;
    }
	
}

