/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net.msg.client;

import xnap.plugin.nap.net.ServerVersion;
import xnap.util.SearchFilter;

import java.util.StringTokenizer;

public class SearchRequestMessage extends ClientMessage {

    //--- Constant(s) ---
    
    public static final int TYPE = 200;

    //--- Constructor(s) ---

    public SearchRequestMessage(SearchFilter filter, int maxResults)
    {
	super(TYPE);

	StringBuffer sb = new StringBuffer();
	
	sb.append(getSearchText(filter.getSearchText(), false));
	sb.append(" MAX_RESULTS ");
	sb.append(maxResults);
	
	if (filter.getMediaType() == SearchFilter.MEDIA_ANYTHING
	    || filter.getMediaType() == SearchFilter.MEDIA_AUDIO) {
	    sb.append(compareString("BITRATE", filter.getBitrateCompare(), 
				    filter.getBitrate()));
	}
	
	data = sb.toString().trim();

	sb.append(mediaString(filter.getMediaType()));
	sb.append(getSearchText(filter.getSearchText(), true));
	sb.append(compareString("SIZE", filter.getFilesizeCompare(),
				filter.getFilesize()));
		  
	add(ServerVersion.OPENNAP044, sb.toString().trim());
	add(ServerVersion.SLAVANAP1, sb.toString().trim());

//  	sb.append(" SHOW_QUEUE");
//  	sb.append(" SHOW_SOFTWARE");
	
	add(ServerVersion.SLAVANAP2, sb.toString().trim());
    }

    // --- Method(s) ---

    public static String compareString(String key, int compare, long value)
    {
	StringBuffer sb = new StringBuffer();
	sb.append(" ");
	sb.append(key);
	sb.append(" \"");

	switch(compare) {
	case SearchFilter.COMPARE_AT_LEAST:
	    sb.append("AT LEAST");
	    break;
	case SearchFilter.COMPARE_EQUAL_TO:
	    sb.append("EQUAL TO");
	    break;
	case SearchFilter.COMPARE_AT_BEST:
	    sb.append("AT BEST");
	    break;
	default: 
	    // SearchFilter.COMPARE_NOT_ACTIVE
	    return "";
	}

	sb.append("\" \"");
	sb.append(value);
	sb.append("\"");

	return sb.toString();
    }
	
    public static String mediaString(int mediaType)
    {
	StringBuffer sb = new StringBuffer();
	sb.append(" TYPE ");

	switch (mediaType) {			     
	case SearchFilter.MEDIA_AUDIO:
	    sb.append("audio");
	    break;
	case SearchFilter.MEDIA_VIDEO:
	    sb.append("video");
	    break;
	case SearchFilter.MEDIA_IMAGES:
	    sb.append("image");
	    break;
	case SearchFilter.MEDIA_SOFTWARE:
	    sb.append("application");
	    break;
	case SearchFilter.MEDIA_DOCUMENTS:
	    sb.append("text");
	    break;
	default:
	    return "";
    	}

	return sb.toString();
    }

    public static String getSearchText(String s, boolean exclude)
    {
	StringBuffer sb = new StringBuffer(s.length());
	StringTokenizer t = new StringTokenizer(s);
	while (t.hasMoreTokens()) {
	    String token = t.nextToken();
	    if (token.startsWith("-")) {
		if (exclude) {
		    sb.append(token);
		    sb.append(" ");
		}
	    }
	    else {
		if (!exclude) {
		    sb.append(token);
		    sb.append(" ");
		}	
	    }
	}

	if (sb.length() == 0) {
	    return "";
	}
	else {
	    // trim
	    sb.deleteCharAt(sb.length() - 1);
	    sb.insert(0, (exclude) ? " FILENAME EXCLUDES \"" 
		      : " FILENAME CONTAINS \"");
	    sb.append("\"");
	    return sb.toString();
	}
    }
}
