/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net.msg;

import xnap.plugin.nap.net.Server;
import xnap.plugin.nap.net.msg.client.ClientMessage;

import java.io.IOException;
import org.apache.log4j.Logger;

public class SendWorker implements Runnable
{

    //--- Constant(s) ---

    //--- Data field(s) ---

    protected static Logger logger = Logger.getLogger(SendWorker.class);
    protected MessageSender sendQueue;

    //--- Constructor(s) ---

    public SendWorker(String name, MessageSender sendQueue)
    {
	this.sendQueue = sendQueue;

	start(name);
    }
    
    //--- Method(s) ---

    public void run()
    {
	Thread.currentThread().setPriority(Thread.MIN_PRIORITY);

	while(!sendQueue.hasDied()) {
	    SendMessage m = sendQueue.next();
	    if (m != null) {
		m.server.waitUntilReadyToSend();

		try {
		    m.server.send(m.msg);
		}
		catch (IOException e) {
		    sendQueue.failed(m.server);

		    if (m.msg.listener != null) {
			m.msg.listener.exceptionThrown(e);
		    }
		}
		sendQueue.sent(m);
	    }
	    else {
		synchronized (sendQueue) {
		    try {
			sendQueue.wait();
		    }
		    catch (InterruptedException e) {
		    }
		}
		//logger.debug("got notified");
	    }
	}
    }

    protected void start(String name)
    {
	Thread t = new Thread(this, name);
	t.start();
    }

}
