/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net;

import xnap.net.AbstractUser;
//  import xnap.net.IBrowse;
//  import xnap.net.IChannel;
//import xnap.net.IUser;
import xnap.user.UserData;

public abstract class AbstractNapUser extends AbstractUser {

    //--- Constant(s) ---

    //--- Data field(s) ---

    protected int connectDuration;
    protected int downloadCount = 0;
    protected String ip;
    protected long lastSeen;
    protected String level;
    protected int uploadCount = 0;

    //--- Constructor(s) ---

    public AbstractNapUser(boolean temporary)
    {
	super(temporary);
    }

    /**
     * Needed for User child class.
     */
    public AbstractNapUser()
    {
    }

    //--- Method(s) ---

    public void setConnectDuration(int newValue)
    {
	connectDuration = newValue;
    }

    public int getConnectDuration()
    {
	return connectDuration;
    }

    public int getDownloadCount()
    {
	return downloadCount;
    }

    public void setDownloadCount(int newValue)
    {
	downloadCount = newValue;
    }

    public String getIP()
    {
	return ip;
    }

    public void setIP(String newValue)
    {
	ip = newValue;
    }

    public String getHost()
    {
	return ip;
    }

    public long getLastSeen()
    {
	return lastSeen;
    }

    public void setLastSeen(long newValue)
    {
	lastSeen = newValue;
    }

    public String getLevel()
    {
	return level;
    }

    public void setLevel(String newValue)
    {
	level = newValue;
    }

    // hmm, we should not need this, but jikes complains about our
    // children not being in the same package...
    protected void setStatus(int newValue)
    {
	super.setStatus(newValue);
    }

    public int getUploadCount()
    {
	return uploadCount;
    }

    public void setUploadCount(int newValue)
    {
	uploadCount = newValue;
    }

    public boolean equals(Object obj) 
    {
	if (obj != null) {
	    if (obj instanceof AbstractNapUser) {
		AbstractNapUser user = (AbstractNapUser)obj;
		return getName().equals(user.getName());
	    }
	}

	return false;
    }	

}
