/*
 * 04/02/2001
 *
 * ResultSet.java
 * Copyright (C) 2001 Frederik Zimmer
 * tristian@users.sourceforge.net
 * http://sourceforge.net/projects/ziga/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package xnap.plugin.gnutella.net;

import xnap.plugin.gnutella.io.*;

import java.io.IOException;
import java.io.EOFException;


/**
 *
 * @version 0.1 10/21/2001
 * @author Frederik Zimmer
 */

public class ResultSet 
{
    //--- Data Field(s) ---
    
    protected int index;
    protected long size;
    protected String fileName;
    protected String extraData;
    protected int length;
	
    public ResultSet(int index, int size, String fileName, String extraData) 
    { 
	this.index = index;
	this.size = size;
	this.fileName = fileName;
	this.extraData = extraData;
	length = fileName.length() + 10;
	if (extraData != null) {
	    length += extraData.length();
	}
    }
    
    public ResultSet(int index, int size, String fileName, String extraData, 
		     int length)
    { 
	this.index = index;
	this.size = size;
	this.fileName = fileName;
	this.extraData = extraData;
	this.length = length+1;
    }
		
    public void write(DataOutputStream out) 
	throws IOException 
    {
	out.writeInt(index);
	out.writeInt((int) size);
	out.write(fileName.getBytes());
	out.write(0);
	if (extraData != null) {
	    out.write(extraData.getBytes());
	}
	out.write(0);
    }
	
    public static ResultSet read(byte[] data, int offset, int length) 
	throws IOException 
    {
	int i = offset;
	String extraData = null;
	
	if (length < 9) {
	    throw new EOFException("ResultSet to short");
	}
	int index = ((data[i++] & 0xff) | ((data[i++] & 0xff) << 8) 
		     | ((data[i++] & 0xff) << 16) 
		     | ((data[i++] & 0xff) << 24));
	int size = ((data[i++] & 0xff) | ((data[i++] & 0xff) << 8) 
		    | ((data[i++] & 0xff) << 16) | ((data[i++] & 0xff) << 24));
	while (i-offset < length && data[i] != 0) {
	    i++;
	}
	if (i-offset >= length) {
	    throw new EOFException("ResultSet to short");
	}
	String filename = new String(data, offset+8, i-offset-8);

	i++;
	if (i-offset < length) {
	    extraData = new String(data, i, length - (i-offset));
	}
	return new ResultSet(index, size, filename, extraData, length);
    }
    
    public int getIndex()
    {
	return index;
    }
    
    public long getSize()
    {
	return size;
    }
	
    public String getFilename()
    {
	return fileName;
    }

    public int getLength()
    {
	return length;
    }

}
