/*
 * 03/28/2001
 *
 * HttpRequest.java
 * Copyright (C) 2001 Frederik Zimmer
 * tristian@users.sourceforge.net
 * http://sourceforge.net/projects/ziga/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package xnap.plugin.gnutella.net;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;

//  import ziga.Hash;
//  import ziga.gnutella.util.Util;

/**
 *
 * @version 0.1 12/16/2001
 * @author Frederik Zimmer
 */

public class HttpRequest
{

    public static final int OPTIONS          = 0;
    public static final int GET              = 1;
    public static final int HEAD             = 2;
    public static final int POST             = 3;
    public static final int PUT              = 4;
    public static final int DELETE           = 5;
    public static final int TRACE            = 6;
    public static final int CHAT             = 7;
    public static final int EXTENSION_METHOD = 8;

    public static final String CONNECTION = "Connection";
    public static final String CLOSE = "Close";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String X_GNUTELLA_CONTENT_URN = "X-Gnutella-Content-URN";
    public static final String X_GNUTELLA_ALTERNATE_LOCATION = "X-Gnutella-Alternate-Location";
    public static final String USER_AGENT = "XNap";
    
    protected int method;
    protected String requestURI;
    protected int majorVersion;
    protected int minorVersion;
    protected HashMap header;
    protected ReadLineReader in;
    protected HashMap formData;
    //  protected RangeHeader rangeHeader;
	
    public HttpRequest(InputStream in) 
    {
	header = new HashMap();
	formData = new HashMap();
	this.in = new ReadLineReader(in);
    }
	
    public static void request(OutputStream os, URL url, long offset)
	throws IOException 
    {
	LineWriter out = new LineWriter(os);
	String requestURI = url.getFile();
	//String requestURI = URLEncoder.encode(url.getFile());
	StringBuffer requestLine = new StringBuffer();
	requestLine.append("GET ");
	requestLine.append(requestURI);
	requestLine.append(" HTTP/1.0\r\n");
	requestLine.append("Connection: Keep-Alive\r\n");
	requestLine.append("Range: bytes=" + offset + "-\r");
	
	out.println(requestLine.toString());
	out.println("User-Agent: " + USER_AGENT);
	out.println();
	
	out.println();
	os.flush();
    }
    
    public void parse() 
	throws IOException, RequestException 
    {
	String requestLine = in.readLine();
	parse(requestLine);
    }
	
    public void parse(String firstLine) 
	throws IOException, RequestException 
    {
	parseRequestLine(firstLine);
	parseMessageHeaders();
    }
	
    public void parseRequestLine(String requestLine) 
	throws IOException, RequestException 
    {
	if (requestLine == null) {
	    throw new RequestException("400");
	}
	int i = requestLine.indexOf(' ');
	if (i == -1) {
	    throw new RequestException("400");
	}
	setMethod(requestLine.substring(0, i++));
	int j = requestLine.lastIndexOf(' ');
	if (j == -1) {
	    throw new RequestException("400");
	}
	decodeURI(requestLine.substring(i, j++));
	setVersion(requestLine.substring(j));
    }
	
    public void parseMessageHeaders() 
	throws IOException, RequestException 
    {
	String line;
	String lowerCaseFieldName = null;
		
	while ((line = in.readLine()) != null) {
	    String fieldValue;
			
	    if (line.charAt(0) == ' ' || line.charAt(0) == 9) {
		fieldValue = line.trim();
		if (fieldValue.charAt(0) == 9) {
		    int index = fieldValue.lastIndexOf((char) 9);
		    if (index != -1 && index < fieldValue.length() - 1) {
			fieldValue = fieldValue.substring(index);
		    }
		    else {
			fieldValue = null;
		    }
		}
	    }
	    else {
		int i = line.indexOf(':');
		if (i == -1) {
		    continue;
		}
		String fieldName = line.substring(0, i++);
		if (line.charAt(i) == ' ') {
		    i++;
		}
		
		lowerCaseFieldName = fieldName.toLowerCase();
		fieldValue = line.substring(i);
	    }
	    
	    if (lowerCaseFieldName != null && fieldValue != null) {
		ArrayList values = (ArrayList) header.get(lowerCaseFieldName);
		if (values == null) {
		    values = new ArrayList();
		}
		values.add(fieldValue);
		header.put(lowerCaseFieldName, values);
				
		if (lowerCaseFieldName.equals("range")) {
		    //  rangeHeader = new RangeHeader(fieldValue);
		    lowerCaseFieldName = null;
		}
	    }
	}
    }
	
    public void setVersion(String version) 
	throws RequestException 
    {
	try {
	    int i = version.indexOf('/');
	    int j = version.indexOf('.', ++i);
	    majorVersion = Integer.parseInt(version.substring(i, j));
	    minorVersion = Integer.parseInt(version.substring(j+1));
	}
	catch(Exception e) {
	    throw new RequestException("400");
	}
    }
    
    public int getMajorVersion() {
	return majorVersion;
    }
    
    public int getMinorVersion() {
	return minorVersion;
    }
	
    public void setMethod(String s) {
	if (s.equalsIgnoreCase("get")) {
	    method = GET;
	}
	else if (s.equalsIgnoreCase("chat")) {
	    method = CHAT;
	}
	else if (s.equalsIgnoreCase("post")) {
	    method = POST;	
	}
	else if (s.equalsIgnoreCase("head")) {
	    method = HEAD;
	}
	else if (s.equalsIgnoreCase("options")) {
	    method = OPTIONS;
	}
	else if (s.equalsIgnoreCase("put")) {
	    method = PUT;
	}
	else if (s.equalsIgnoreCase("delete")) {
	    method = DELETE;
	}
	else if (s.equalsIgnoreCase("trace")) {
	    method = TRACE;
	}
	else {
	    method = EXTENSION_METHOD;
	}
    }
	
    public int getMethod() {
	return method;
    }
	
    public String getURI() {
	return requestURI;
    }
	
    public HashMap getFormData() {
	return formData;
    }
	
    public String getFieldValue(String fieldName) 
    {
	ArrayList values = (ArrayList) header.get(fieldName.toLowerCase());
	if (values != null) {
	    return (String) values.get(0);
	}
	else {
	    return null;
	}
    }
	
    public ArrayList getFieldValues(String fieldName) {
	return (ArrayList) header.get(fieldName.toLowerCase());
    }
	
    //  public RangeHeader getRangeHeader() {
//  	return rangeHeader;
//      }
	
    private void decodeForm(String formString) 
	throws RequestException 
    {
	String name;
	String value;
	String token;
		
	StringTokenizer st = new StringTokenizer(formString, "&");
		
	while (st.hasMoreTokens()) {
	    String s;
	    try {
		s = st.nextToken();
		token = URLDecoder.decode(s);
	    }
	    catch(Exception e) {
		throw new RequestException("400");
	    }
	    int i = token.indexOf('=');
			
	    if (i == -1 || i == token.length() - 1) {
		name = token;
		value = "";
	    }
	    else {
		name = token.substring(0, i++);
		value = token.substring(i);
	    }
	    formData.put(name, value);
	}
    }
	
    private void decodeURI(String uri) 
	throws RequestException 
    {
	int i;
	int queryIndex;
		
	requestURI = uri;
	if (requestURI.startsWith("/")) {
	    requestURI = requestURI.substring(1);
	}
	else if (requestURI.indexOf(':') != -1 && (i = requestURI.indexOf('/')) != -1) {
	    requestURI = requestURI.substring(i + 1);
	    if (requestURI.startsWith("/")) {
		requestURI = requestURI.substring(1);
	    }
	    else {
		throw new RequestException("400");
	    }
	}
	else {
	    throw new RequestException("400");
	}
	if (requestURI.startsWith("/")) {
	    throw new RequestException("400");
	}
	if ((queryIndex = requestURI.indexOf('?')) != -1) {	
	    decodeForm(requestURI.substring(queryIndex + 1));
	    requestURI = requestURI.substring(0, queryIndex);
	}
	//  try {
	    requestURI = URLDecoder.decode(requestURI);
//  	} catch(Exception e) {
//  	    e.printStackTrace();
//  	    throw new RequestException("400");
//  	}
    }

}
