/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift.gui;

import java.awt.GridBagLayout;

import javax.swing.JLabel;
import javax.swing.JTextField;

import xnap.gui.AbstractPreferencesPanel;
import xnap.gui.GridBagHelper;
import xnap.gui.ValidatedTextField;
import xnap.plugin.gift.util.GiftPreferences;

public class GiftPreferencesPanel extends AbstractPreferencesPanel
{

    //--- Data Field(s) ----

    private GiftPreferences prefs = GiftPreferences.getInstance();

    private JTextField jteGiftDaemon;
    private JTextField jteGiftHost;
    private ValidatedTextField jteGiftPort;
    
    //--- Constructor(s) ---

    public GiftPreferencesPanel()
    {
	setLayout(new GridBagLayout());

        GridBagHelper.addLabel(this, "");
        GridBagHelper.add(this, new JLabel
	    ("Leave empty if not installed"));

        GridBagHelper.addLabel(this, 
			       "Daemon Command");
        jteGiftDaemon = new JTextField(prefs.getGiftDaemon(), 30);
	GridBagHelper.add(this, jteGiftDaemon);

        GridBagHelper.addLabel(this, "Host");
        jteGiftHost = new JTextField(prefs.getGiftHost(), 30);
        GridBagHelper.add(this, jteGiftHost);	

        GridBagHelper.addLabel(this, "Port");
        jteGiftPort 
	    = new ValidatedTextField(prefs.getGiftPort() + "",
				     ValidatedTextField.NUMBERS_INT);
        GridBagHelper.add(this, jteGiftPort);

	GridBagHelper.addVerticalSpacer(this);
    }

    //--- Method(s) ---

    public void apply()
    {
	prefs.setGiftDaemon(jteGiftDaemon.getText());
	prefs.setGiftHost(jteGiftHost.getText());
	prefs.setGiftPort(jteGiftPort.getIntValue());
    }

    public String getTitle()
    {
	return "GiFT";
    }

}

