/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift;

import java.awt.event.KeyEvent;

import javax.swing.*;

import xnap.gui.AbstractPreferencesPanel;
import xnap.gui.StatusPanel;
import xnap.gui.XNapFrame;
import xnap.plugin.IGUIPlugin;
import xnap.plugin.gift.gui.DaemonPanel;
import xnap.plugin.gift.gui.GiftPreferencesPanel;
import xnap.plugin.gift.gui.StatsPanel;
import xnap.plugin.gift.net.event.OfflineEvent;
import xnap.plugin.gift.net.event.OnlineEvent;
import xnap.plugin.gift.net.event.StatsEvent;
import xnap.util.event.StatusListener;

public class GUIPlugin extends Plugin implements IGUIPlugin
{

    //--- Data Field(s) ---

    private DaemonPanel daemonPanel;
    private JMenu menu = null;
    private JTabbedPane giftPane;
    private StatsPanel statsPanel;
	private StatusPanel statusPanel;
    //--- Constructor(s) ---

    public GUIPlugin()
    {
    }

    //--- Method(s) ---

    public Icon getIcon()
    {
	return XNapFrame.getBigIcon("gift.png");
    }

    public JMenu getMenu()
    {
		if (menu == null) {
			menu = new JMenu("giFT");
		}
		return menu;
    }

    public JComponent getPanel()
    {
	return giftPane;
    }

 
    public AbstractPreferencesPanel getWizardPanel()
    {
	return null;
    }

    public JComponent getStatusPanel()
    {
	return statusPanel;
    }

    public void start()
    {
	// panel
	giftPane = new JTabbedPane();

	daemonPanel = new DaemonPanel();
	giftPane.addTab("Daemon", daemonPanel);

	statsPanel = new StatsPanel();
	giftPane.add("Statistics", statsPanel);
	
	// menu
	menu = new JMenu("giFT");
	menu.setMnemonic(KeyEvent.VK_G);

        JMenuItem jmiDaemon 
	    = new JMenuItem ("Start daemon", KeyEvent.VK_S);
        menu.add(jmiDaemon);

        JMenuItem jmiUpdateStats 
	    = new JMenuItem ("Update statistics", KeyEvent.VK_U);
        menu.add(jmiUpdateStats);

   	// stats updates
   	statusPanel = new StatusPanel(this);
   	

	super.start();
    }

    public void stop()
    {
	// fix me
	/*
	if (daemonPanel.isRunning()) {
	    int ret = JOptionPane.showConfirmDialog
		(this, "The giFT daemon is still running. Do you want "
		 + "to stop it?", "giFT daemon", JOptionPane.YES_NO_OPTION);
	    if (ret == JOptionPane.YES_OPTION)
		daemonPanel.stop();
	}
	*/

	super.stop();
    }

	/**
	 * @see xnap.plugin.IGUIPlugin#getPreferencesIcon()
	 */
	public Icon getPreferencesIcon() {
		return XNapFrame.getBigIcon("gift.png");
	}

	/**
	 * @see xnap.plugin.IGUIPlugin#getPrefsPanels()
	 */
	public AbstractPreferencesPanel[] getPrefsPanels() {
		return new AbstractPreferencesPanel[]
			{ new GiftPreferencesPanel() };

	}

	/**
	 * @see xnap.plugin.IGUIPlugin#setStatusListener(xnap.util.event.StatusListener)
	 */
	public void setStatusListener(StatusListener listener) {
		daemonPanel.setStatusListener(listener);
		statsPanel.setStatusListener(listener);
	}

	/**
	 * @see xnap.plugin.gift.net.event.listener.NetworkEventListener#attached(xnap.plugin.gift.net.event.OnlineEvent)
	 */
	public void attached(OnlineEvent evt) {
		super.attached(evt);
		statusPanel.update();
	}

	/**
	 * @see xnap.plugin.gift.net.event.listener.NetworkEventListener#detached(xnap.plugin.gift.net.event.OfflineEvent)
	 */
	public void detached(OfflineEvent evt) {
		super.detached(evt);
		statusPanel.update();
	}

	/**
	 * @see xnap.plugin.gift.net.event.listener.NetworkEventListener#statsUpdate(xnap.plugin.gift.net.event.StatsEvent)
	 */
	public void statsUpdate(StatsEvent evt) {
		super.statsUpdate(evt);
		statusPanel.update();
	}

}
