/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.net;

import xnap.plugin.PluginInfo;

import java.io.*;
import java.util.*;

public class PluginInfoReader
{

    //--- Constant(s) ---

    //--- Data field(s) ---

    //--- Constructor(s) ---

    //--- Method(s) ---

    public static PluginInfo[] read(String location) throws IOException
    {
	LinkedList infos = new LinkedList();

	HttpConnection c = new HttpConnection();
	c.connect(location);

	Properties props = new Properties();
	props.load(c.getInputStream());

	String plugins = props.getProperty("plugins");
	if (plugins != null) {
	    StringTokenizer t = new StringTokenizer(plugins, ";");
	    while (t.hasMoreTokens()) {
		PluginInfo info = new PluginInfo(t.nextToken(), props);
		//if (info.isValid()) {
		    infos.add(info);
		    //}
	    }
	}

	PluginInfo[] array = new PluginInfo[infos.size()];
	System.arraycopy(infos.toArray(), 0, array, 0, array.length);
	return array;
    }
    
}
