/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.net;

import xnap.io.Repository;
import xnap.user.UserData2;
import xnap.util.LinkSpeed;

public abstract class AbstractUser extends AbstractCommunication
    implements IUser {

    //--- Data field(s) ---
    
    private String clientInfo;
    private int fileCount = -1;
    private int linkSpeed = LinkSpeed.UNKNOWN;
    private boolean temporary;

    protected boolean fakeLocalFileCount = false;

    //--- Constructor(s) ---

    public AbstractUser(boolean temporary)
    {
	this.temporary = temporary;
    }

    public AbstractUser()
    {
	this(true);
    }

    //--- Method(s) ---

    public abstract IBrowse getBrowse();

    public String getCategory()
    {
	return getData().category;
    }

    public String getClientInfo()
    {
	return clientInfo;
    }

    public String getComment()
    {
	return getData().comment;
    }

    public void setClientInfo(String newValue)
    {
	clientInfo = newValue;
    }

    public abstract UserData2 getData();

    public int getFileCount()
    {
	// FIX: we should use a global user repository for this
	if (fakeLocalFileCount) {
	    setFileCount(Repository.getInstance().getNonNullSize());
	}

	return fileCount;
    }

    public void setFileCount(int newValue)
    {
	fileCount = newValue;
    }

    public int getLinkSpeed()
    {
	return linkSpeed;
    }

    public void setLinkSpeed(int newValue)
    {
	linkSpeed = newValue;
    }


    public synchronized int getLocalDownloadCount()
    {
	return getData().localDownloads;
    }

    public synchronized void modifyLocalDownloadCount(int relative)
    {
	setLocalDownloadCount(getLocalDownloadCount() + relative);
	notifyListeners();
    }

    public synchronized void setLocalDownloadCount(int newValue)
    {
	getData().localDownloads = newValue;
    }

    public synchronized int getLocalUploadCount()
    {
	return getData().localUploads;
    }

    public synchronized void modifyLocalUploadCount(int relative)
    {
	setLocalUploadCount(getLocalUploadCount() + relative);
	notifyListeners();
    }

    public synchronized void setLocalUploadCount(int newValue)
    {
	getData().localUploads = newValue;
    }

    public int getMaxDownloads()
    {
	return getData().maxDownloads;
    }

    public int getMaxUploads()
    {
	return getData().maxUploads;
    }
    
    public String getName()
    {
	return getData().name;
    }

    public abstract IChannel getPrivateChannel();

    public String getStatusMsg(int index)
    {
	return STATUS_MSGS[index];
    }

    public boolean isActionSupported(Class actionClass)
    {
	return false;
    }

    public boolean isChatIgnored()
    {
	return getData().ignoreChat;
    }

    public boolean isTemporary()
    {
	return temporary;
    }

    public void setChatIgnored(boolean newValue)
    {
	getData().ignoreChat = newValue;
    }

    public void setCategory(String newValue)
    {
	getData().category = newValue;
    }

    public void setComment(String newValue)
    {
	getData().comment = newValue;
    }

    public void setMaxDownloads(int newValue)
    {
	getData().maxDownloads = newValue;
    }

    public void setMaxUploads(int newValue)
    {
	getData().maxUploads = newValue;
    }

    public void setTemporary(boolean newValue)
    {
	if (newValue != temporary) {
	    temporary = newValue;
	    notifyListeners();
	}
    }

    // FIX: this is an ugly code saver
    public void notifyListeners()
    {
	// fire dummy event
	setStatus(getStatus());
    }

}
