/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.net;

import xnap.util.SearchFilter;

import java.io.IOException;
import java.util.LinkedList;

public abstract class AbstractSearch implements ISearch {

    //--- Constant(s) ---

    //--- Data field(s) ---

    protected LinkedList buffer = new LinkedList();
    protected SearchFilter filter;
    protected boolean finished = false;
    protected int maxResults;
    protected int priority;

    //--- Constructor(s) ---

    public AbstractSearch(SearchFilter filter, int priority, int maxResults)
    {
        this.filter = filter;
        this.priority = priority;
        this.maxResults = maxResults;
    }

    // Method(s)
    
    public synchronized void add(ISearchResult sr)
    {
	buffer.add(sr);
    }

    public synchronized int available() throws IOException
    {
	return (buffer.size() == 0 && finished) ? -1 : buffer.size();
    }

    /**
     * Returns the priority of this search.
     */
    public int getPriority()
    {
	return priority;
    }

    public synchronized ISearchResult next() throws IOException
    {
	return (ISearchResult)buffer.removeFirst();
    }

}
