/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.io;

import xnap.util.*;

import java.io.*;
//import java.lang.reflect.*;
//import java.security.MessageDigest;
import java.util.*;

/**
 * MP3 header format documented at:
 * http://mp3tech.free.fr/programmers/frame_header.html
 */
public class MP3File extends RepositoryFile {
    
    // --- Constant(s) ---

    // --- Data Field(s) ---

    private int bitrate = -1;
    private int frequency = -1;
    private long length = -1;
    
    // --- Constructor(s) ---

    public MP3File(File f)
    {
	super(f);
    }

    public MP3File(String filename, int bitrate, int frequency, long length)
    {
	super(filename);
	
	this.bitrate = bitrate;
	this.frequency = frequency;
	this.length = length;
    }
    
    // --- Method(s) ---
    
    public boolean parse()
    {
	Debug.log("MP3File: parsing " + getName());

//  	try {
//   	    Class c = Class.forName("de.vdheide.mp3.MP3File");
//  	    Constructor ct = c.getConstructor(new Class[] {String.class});
//  	    Object f = ct.newInstance(new Object[] {this.getAbsolutePath()});

//  	    Method m = c.getMethod("getBitrate", null);
//  	    this.bitrate = ((Integer)m.invoke(f, null)).intValue();

//  	    m = c.getMethod("getSamplerate", null);
//  	    this.frequency = ((Integer)m.invoke(f, null)).intValue();

//  	    m = c.getMethod("getLength", null);
//  	    this.length = ((Long)m.invoke(f, null)).intValue();

//  	}
//  	catch (Exception e) {
//  	    return false;
//  	}

	try {
	    helliker.id3.MP3File m = new helliker.id3.MP3File(this);

	    this.bitrate = m.getBitRate();
	    this.frequency = m.getSampleRate();
	    this.length = m.getPlayingTime();
	}
	catch (Exception e) {
	    return false;
	}
	
	return true;
    }

    public int getBitrate() 
    { 
	return bitrate; 
    }

    public int getFrequency() 
    { 
	return frequency; 
    }

    /**
     * Returns the length of the file in seconds.
     */
    public long getPlayingTime() 
    { 
	return length; 
    }

    public String getInfo()
    {
	return getBitrate() + " bit, " + Formatter.formatLength(getPlayingTime());
    }

}
