/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.wizard;

import xnap.*;
import xnap.gui.*;

import java.awt.*;
import java.awt.event.*;
import java.io.File;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

public class FilesWizardPanel extends AbstractPreferencesPanel {
    
    //--- Data field(s) ---

    private DirectoryPanel jteDownloadDir;
    private DirectoryList dlUploadDirs;
    private JCheckBox jcUseOpenFileAction;

    //--- Constructor(s) ---

    public FilesWizardPanel()
    {
	setLayout(new GridBagLayout());

	// download directory
	JPanel jpDl = new JPanel(new BorderLayout());
	jpDl.setBorder(new TitledBorder(XNap.tr("Download Directory", 1)));
        jteDownloadDir = new DirectoryPanel(prefs.getDownloadDir(), 20);
	jpDl.add(jteDownloadDir, BorderLayout.CENTER);
        GridBagHelper.add(this, jpDl);

	// upload directory list
	JPanel jpUl = new JPanel(new BorderLayout());
	jpUl.setBorder(new TitledBorder(XNap.tr("Upload Directories", 1)));
	dlUploadDirs = new DirectoryList(prefs.getUploadDirsArray(), 20, 3);
	jpUl.add(dlUploadDirs, BorderLayout.CENTER);
        GridBagHelper.add(this, jpUl);

	GridBagHelper.addVerticalSpacer(this);
    }

    public void apply() 
    {
	prefs.setDownloadDir(jteDownloadDir.getDirectory());
	prefs.setIncompleteDir(prefs.getDownloadDir() + "incomplete");
	prefs.setUploadDirs(dlUploadDirs.getDirs());
    }

    public String getDescription()
    {
	return XNap.tr("Setup your file locations.The downlad directory will be created if not already existent.");
    }

    public Icon getIcon()
    {
	return XNapFrame.getSmallIcon("folder.png");
    }

    public String getTitle()
    {
	return XNap.tr("File Settings");
    }

}
