/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.gui.table;

import java.util.Enumeration;
import javax.swing.table.*;

public class Column extends TableColumn {

    //--- Constant(s) ---

    //--- Data Field(s) ---

    protected Class dataType;
    protected String name;
    protected TableColumnModel tcm;
    protected boolean visible = false;

    //--- Constructor(s) ---

    public Column(String name, Class dataType, TableCellRenderer r)
    {
	super(0, 50, r, null);

	this.name = name;
	this.dataType = dataType;
    }

    public Column(String name, Class dataType)
    {
	this(name, dataType, null);
    }

    //--- Method(s) ---

    public Class getDataType()
    {
	return dataType;
    }

    public Object getHeaderValue() 
    {
	return name;
    }

    public void move()
    {
//  	if (tcm != null) {
//  	    if (newValue) {
//  		int i = 0;
//  		if (move) {
//  		    for (Enumeration e = tcm.getColumns(); e.hasMoreElements(); 
//  			 i++) {
//  			if (((TableColumn)e.nextElement()).getModelIndex() 
//  			    > getModelIndex()) {
//  			    break;
//  			}
//  		    }
//  		}
//  		else {
//  		    i = tcm.getColumnCount();
//  		}
//  		tcm.addColumn(this);
//  		tcm.moveColumn(tcm.getColumnCount() - 1, i);
//  		return i;
//  	    }
//  	    else {
//  		tcm.removeColumn(this);
//  	    }
//  	}
    }

    public void setModel(TableColumnModel newValue)
    {
	tcm = newValue;
    }

    public String getName()
    {
	return name;
    }

    public boolean isVisible()
    {
	return visible;
    }

    /**
     * Returns the index where the column was inserted, -1 if removed or 
     * table model not set.
     */
    public int setVisible(boolean newValue) 
    {
	if (visible == newValue) {
	    return -1;
	}
	this.visible = newValue;

	if (tcm != null) {
	    if (newValue) {
		tcm.addColumn(this);
		return tcm.getColumnCount() - 1;
	    }
	    else {
		tcm.removeColumn(this);
	    }
	}
	 
	return -1;
    }

    public String toString()
    {
	return name;
    }

}
