/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.gui.prefs;

import xnap.XNap;
import xnap.gui.*;
import xnap.util.SearchFilter;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;

public class ProxyPrefsPanel extends AbstractPreferencesPanel {
    
    //--- Data field(s) ---
    private JCheckBox jcUseHttpProxy;
    private JTextField jteHttpProxyHost;
    private ValidatedTextField jteHttpProxyPort;
    private JCheckBox jcUseSocksProxy;
    private JTextField jteSocksProxyHost;
    private ValidatedTextField jteSocksProxyPort;

    //--- Constructor(s) ---

    public ProxyPrefsPanel()
    {
	setLayout(new GridBagLayout());

	// http proxy
	JPanel jpHttpProxy = new JPanel(new GridBagLayout());
	jpHttpProxy.setBorder
	    (new TitledBorder(XNap.tr("Http Proxy", 1)));
	jcUseHttpProxy = new JCheckBox
	    (XNap.tr("Use Proxy"), prefs.getUseHttpProxy());
        GridBagHelper.add(jpHttpProxy, jcUseHttpProxy);

        GridBagHelper.addLabel(jpHttpProxy, XNap.tr("Host"));
        jteHttpProxyHost = new JTextField(prefs.getHttpProxyHost(), 30);
	GridBagHelper.add(jpHttpProxy, jteHttpProxyHost);
	
        GridBagHelper.addLabel(jpHttpProxy, XNap.tr("Port"));
        jteHttpProxyPort = new ValidatedTextField
	    (prefs.getHttpProxyPort() + "", 5, ValidatedTextField.NUMBERS_INT);
        GridBagHelper.add(jpHttpProxy, jteHttpProxyPort, false);

	EnableAction acHttpProxy = new EnableAction
	    (new Component[] { jteHttpProxyHost, jteHttpProxyPort }, 
	     jcUseHttpProxy);

	GridBagHelper.add(this, jpHttpProxy);

	// socks proxy
	JPanel jpSocksProxy = new JPanel(new GridBagLayout());
	jpSocksProxy.setBorder
	    (new TitledBorder(XNap.tr("Socks 4 Proxy", 1)));

	jcUseSocksProxy = new JCheckBox
	    (XNap.tr("Use Proxy"), prefs.getUseSocksProxy());
        GridBagHelper.add(jpSocksProxy, jcUseSocksProxy);


        GridBagHelper.addLabel(jpSocksProxy, XNap.tr("Host"));
        jteSocksProxyHost = new JTextField(prefs.getSocksProxyHost(), 30);
	GridBagHelper.add(jpSocksProxy, jteSocksProxyHost);
	
        GridBagHelper.addLabel(jpSocksProxy, XNap.tr("Port"));
        jteSocksProxyPort = new ValidatedTextField
	    (prefs.getSocksProxyPort() + "", 5, ValidatedTextField.NUMBERS_INT);
        GridBagHelper.add(jpSocksProxy, jteSocksProxyPort, false);

	EnableAction acSocksProxy = new EnableAction
	    (new Component[] { jteSocksProxyHost, jteSocksProxyPort }, 
	     jcUseSocksProxy);
	
	GridBagHelper.add(this, jpSocksProxy);

	GridBagHelper.addVerticalSpacer(this);
    }

    public void apply() 
    {
	prefs.setUseHttpProxy(jcUseHttpProxy.isSelected());
	prefs.setHttpProxyHost(jteHttpProxyHost.getText().trim());
	prefs.setHttpProxyPort(jteHttpProxyPort.getIntValue());

	prefs.setUseSocksProxy(jcUseSocksProxy.isSelected());
	prefs.setSocksProxyHost(jteSocksProxyHost.getText().trim());
	prefs.setSocksProxyPort(jteSocksProxyPort.getIntValue());
    }

    public Icon getIcon()
    {
	return XNapFrame.getSmallIcon("network.png");
    }

    public String getTitle()
    {
	return XNap.tr("Proxies");
    }

}
