/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.prefs;

import xnap.XNap;
import xnap.gui.AbstractPreferencesPanel;
import xnap.gui.DefaultDialog;
import xnap.gui.DirectoryList;
import xnap.gui.DirectoryPanel;
import xnap.gui.GridBagHelper;
import xnap.gui.XNapFrame;

import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;

public class FilesPrefsPanel extends AbstractPreferencesPanel 
{

    //--- Data field(s) ---

    private DirectoryList dlUploadDirs;
    private DirectoryPanel jteDownloadDir;
    private DirectoryPanel jteIncompleteDir;    
    private JCheckBox jcShareFullPath;

    //--- Constructor(s) ---

    public FilesPrefsPanel()
    {
	setLayout(new GridBagLayout());

	// download directory
	JPanel jpDl = new JPanel(new GridBagLayout());
	jpDl.setBorder(new TitledBorder(XNap.tr("Download Directory", 1)));
        GridBagHelper.add(this, jpDl);
        jteDownloadDir = new DirectoryPanel(prefs.getDownloadDir(), 20);
	GridBagHelper.add(jpDl, jteDownloadDir);
	// advanced button
	GridBagHelper.add(jpDl, new JButton(new AdvancedAction()), 
			  GridBagHelper.COMPONENT_INSETS, false, 
			  GridBagConstraints.NORTHEAST);

	// incomplete directory
	JPanel jpIncomplete = new JPanel(new GridBagLayout());
	jpIncomplete.setBorder
	    (new TitledBorder(XNap.tr("Incomplete Directory", 1)));
	GridBagHelper.add(this, jpIncomplete);
        jteIncompleteDir = new DirectoryPanel(prefs.getIncompleteDir(), 20);
	GridBagHelper.add(jpIncomplete, jteIncompleteDir);

	// upload directory list
	JPanel jpUl = new JPanel(new GridBagLayout());
	// share full path
	jpUl.setBorder(new TitledBorder(XNap.tr("Upload Directories", 1)));
        GridBagHelper.add(this, jpUl);
	dlUploadDirs = new DirectoryList(prefs.getUploadDirsArray(), 20, 3);
	GridBagHelper.add(jpUl, dlUploadDirs);

	jcShareFullPath  = new JCheckBox(XNap.tr("Share Full Path"), 
					 prefs.getShareFullPath());
	GridBagHelper.add(this, jcShareFullPath);
	
	GridBagHelper.addVerticalSpacer(this);
    }

    public void apply() 
    {
	prefs.setIncompleteDir(jteIncompleteDir.getDirectory());
	prefs.setDownloadDir(jteDownloadDir.getDirectory());
	prefs.setUploadDirs(dlUploadDirs.getDirs());
	prefs.setShareFullPath(jcShareFullPath.isSelected());
    }

    public Icon getIcon()
    {
	return XNapFrame.getSmallIcon("folder.png");
    }

    public String getTitle()
    {
	return XNap.tr("Files");
    }

    /**
     * 
     */
    private class AdvancedAction extends AbstractAction 
    {
        public AdvancedAction()
	{
            putValue(Action.NAME, XNap.tr("Advanced") + "...");
            putValue(Action.SHORT_DESCRIPTION,
		     XNap.tr("Shows media download dir dialog."));
            putValue(Action.MNEMONIC_KEY, new Integer(KeyEvent.VK_A));
        }

        public void actionPerformed(ActionEvent event) 
	{
	    MediaDownloadDirDialog dialog = new MediaDownloadDirDialog();
	    dialog.show(FilesPrefsPanel.this);
        }
    }

    private class MediaDownloadDirDialog extends DefaultDialog
    {
	MediaDownloadDirPanel jpDirs;

	public MediaDownloadDirDialog()
	{
	    super(BUTTON_OKAY | BUTTON_CANCEL, false);

	    setTitle(XNap.tr("Mediatype Download Directories"));
	    setModal(true);

	    jpDirs = new MediaDownloadDirPanel();
	    
	    getMainPanel().setLayout(new BorderLayout());
	    getMainPanel().add(jpDirs, BorderLayout.CENTER);

	    pack();

	    jpDirs.adjustWidth();
	}

	public void apply()
	{
	    jpDirs.apply();
	}
    }
}
