/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.event;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.*;
import javax.swing.*;

public class PopupListener extends MouseAdapter {

    //--- Data field(s) ---

    private JPopupMenu popup;

    //--- Constructor(s) ---

    public PopupListener(JMenu menu)
    {
	this(menu.getPopupMenu());
    }

    public PopupListener(JPopupMenu popup)
    {
	this.popup = popup;
        popup.setBorderPainted(true);
    }
	

    //--- Method(s) ---

    public void mousePressed(MouseEvent e) 
    {	
	showPopup(e);
    }

    public void mouseReleased(MouseEvent e) 
    {
	showPopup(e);
    }

    /**
     * Child classes can overwrite this.
     */
    protected void showPopup(Component source, int x, int y)
    {
	popup.show(source, x, y);
    }

    private void showPopup(MouseEvent e) 
    {
	if (e.isPopupTrigger()) {
	    if (!makeSelection(e.getComponent(), e.getPoint(), 
			       e.isControlDown())) {
		return;
	    }

	    e.getComponent().requestFocus();
	    showPopup(e.getComponent(), e.getX(), e.getY());
	}
    }

    private boolean makeSelection(Object parent, Point point, boolean multiple)
    {
	if (parent instanceof JTable) {
	    JTable table = (JTable)parent;
	    int row = table.rowAtPoint(point);

	    if(row == -1)
		return false;

	    // determine if clicked row is already selected
	    int[] rows = table.getSelectedRows();
	    boolean selectRow = true;
	    for (int i = 0; i < rows.length; i++) {
		if (rows[i] == row)
		    selectRow = false;
	    }
	    
	    if (selectRow)
		table.getSelectionModel().setSelectionInterval(row, row);
	}
	else if (parent instanceof JTree) {
	    JTree tree = (JTree)parent;
	    int row = tree.getClosestRowForLocation(point.x, point.y);
	    
	    if (row == -1)
		return false;
	    
	    if (multiple)
		tree.addSelectionRow(row);
	    else
		tree.setSelectionRow(row);
	}
 
	return true;
    }
}
