/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui.action;

import xnap.XNap;
import xnap.cmdl.Console;
import xnap.util.*;
import xnap.util.launcher.LauncherSupport;
import xnap.gui.*;
import xnap.gui.event.FileCollector;
import xnap.gui.table.*;

import java.awt.event.*;
import java.util.*;
import java.io.*;
import java.awt.Component;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.beans.*;
import org.apache.log4j.Logger;

public class OpenFileWithMenu extends JMenu
    implements PropertyChangeListener
{
    
    //--- Constant(s) ---

    //--- Data field(s) ---
    
    protected static Logger logger 
	= Logger.getLogger(OpenFileWithMenu.class);

    protected FileCollector fc;
    
    protected Preferences prefs = Preferences.getInstance();

    //--- Constructor(s) ---

    public OpenFileWithMenu(FileCollector fc) 
    {
	super(XNap.tr("Open With"));

	this.fc = fc;

//  	putValue(Action.SHORT_DESCRIPTION, XNap.tr("Open selected files with program"));

	setIcon(XNapFrame.getIcon("folder_new.png"));

	setupMenu();
	prefs.addPropertyChangeListener("openWithCommands", this);
    }

    //--- Method(s) ---

    public void openFiles(String command)
    {
	File[] files = fc.getFiles();
	
	if (files == null || command == null) {
	    return;
	}
	
	try {
	    LauncherSupport.exec(command, files);
	} 
	catch (IOException e) { 
	    logger.warn("could not execute", e);
	}
    }
    
    private void setupMenu()
    {
	removeAll();
	add(new OthersAction());
	addSeparator();
	
	String[] commands = prefs.getOpenWithCommandsArray();
	for (int i = 0; i < commands.length; i++) {
	    add(new ItemAction(commands[i]));
	}
    }

    public void propertyChange(PropertyChangeEvent e)
    {
	setupMenu();
    }

    protected void insertCommand(String command)
    {
	LinkedList commands = prefs.getOpenWithCommandsList();
	for (Iterator i = commands.iterator(); i.hasNext();) {
	    if (command.equals((String) i.next())) {
		i.remove();
		break;
	    }
	}
	commands.addFirst(command);

	while (commands.size() > prefs.getMaxOpenWithCommands()) {
	    commands.removeLast();
	}
	prefs.setOpenWithCommands(commands);
    }

    protected class ItemAction extends AbstractAction
    {
	String command;
	
	public ItemAction(String command)
	{
	    this.command = command;
	    this.putValue(Action.NAME, command);
	}
	
	public void actionPerformed(ActionEvent event)
	{
	    openFiles(command);
	    insertCommand(command);
	}
    }
    
    protected class OthersAction extends AbstractAction
    {
	public OthersAction()
	{
	    this.putValue(Action.NAME, XNap.tr("Other") + "...");
	}
	
	public void actionPerformed(ActionEvent event)
	{
	    String command;
	    
	    if (fc instanceof Component) {
		command = (String)
		    JOptionPane.showInputDialog((Component)fc, XNap.tr("Enter command"),
						XNap.tr("Open With") + "...", 
						JOptionPane.QUESTION_MESSAGE);
	    }
	    else {
		command = (String)
		    JOptionPane.showInputDialog(null, XNap.tr("Enter command"),
						XNap.tr("Open With") + "...", 
						JOptionPane.QUESTION_MESSAGE);
	    }
	    
	    openFiles(command);
	    
	    if (command != null) {
		insertCommand(command);
	    }
	}
    }
}
