/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import xnap.plugin.INetworkPlugin;
import xnap.util.event.StatusListener;

import java.awt.Color;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

public class StatusPanel extends JLabel 
    implements ActionListener, StatusListener
{
    //--- Constant(s) ---
    
    public static final int TIMEOUT = 10000;

    private static final ImageIcon[] icons = {
	null, XNapFrame.getSmallIcon("ok.png"), 
	XNapFrame.getSmallIcon("flag.png")
    };

    //--- Data field(s) ---

    private int defaultTimeout;
    private INetworkPlugin plugin = null;
    private Timer timer;

    //--- Constructor(s) ---

    /**
     * Sets up a <code>JPanel</code> containing a <code>JLabel</code>.
     * This label is then used to display status messages produced by the
     * application. After initialization the message "*please* use the
     * feedbackform to send feedback: Help --> Send Feedback" is displayed.
     */
    public StatusPanel(int defaultTimeout)
    {
	this.defaultTimeout = defaultTimeout;

	setBorder(new EmptyBorder(2, 5, 2, 5));
	setForeground(Color.black);
	timer = new Timer(-1, this);
    }

    public StatusPanel(ImageIcon icon)
    {
	this(-1);
	setIcon(icon);
    }

    public StatusPanel(INetworkPlugin plugin)
    {
	this(-1);

	this.plugin = plugin;
    }

    public StatusPanel()
    {
	this(-1);
    }


    //--- Method(s) ---

    public void actionPerformed(ActionEvent e)
    {
	if (e.getSource() == timer) {
	    timer.stop();
	    super.setText(" ");
	    super.setToolTipText(null);
	}
    } 

    public void update()
    {
	if (plugin != null) {
	    int s = plugin.getStatus();
	    if (s > 0 && s < icons.length) {
		setIcon(icons[s]);
	    }
	    else {
		setIcon(null);
	    }
	    StringBuffer sb = new StringBuffer(plugin.getStatusMessage());
	    setText(sb.toString());
	    sb.append("(");
	    sb.append(plugin.getName());
	    sb.append(")");
	    super.setToolTipText(sb.toString());
	}
    }

    public void setText(String status, int timeout) 
    {
        super.setText(status);
	super.setToolTipText(status);

	if (timeout > 0) {
	    timer.setInitialDelay(timeout);
	    timer.restart();
	}
    }

    /**
     * Used to change the message in the status field.
     *
     * @param status   the message to be displayed.
     */
    public void setText(String status) 
    {
	setText(status, defaultTimeout);
    }

    public void setStatus(String message)
    {
	setText(message);
    }

}

