/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.gui;

import xnap.gui.wizard.*;
import xnap.plugin.*;
import xnap.*;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.*;

public class StartupWizardDialog extends WizardDialog
{

    //--- Constant(s) ---

    //--- Data field(s) ---

    boolean startup = false;

    //--- Constructor(s) ---

    public StartupWizardDialog()
    {
	setTitle(XNap.tr("XNap Setup Wizard"));
	setModal(true);

	addPanel(new IntroWizardPanel());
	addPanel(new GeneralWizardPanel());
	addPanel(new FilesWizardPanel());
	addPanel(new NetworkWizardPanel());
	
	IPlugin[] plugins = PluginManager.getInstance().getPlugins();
	for (int i = 0; i < plugins.length; i++) {
	    if (plugins[i] instanceof IGUIPlugin) {
		AbstractPreferencesPanel p 
		    = ((IGUIPlugin)plugins[i]).getWizardPanel();
		if (p != null) {
		    addPanel(p);
		}
	    }
	}

	pack();
    }

    //--- Method(s) ---

    public boolean canCancel()
    {
	if (startup) {
	    return JOptionPane.showConfirmDialog
		(null, XNap.tr("This will close XNap. Are you sure?"), 
		 XNap.tr("Cancel"),
		 JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE)
		== JOptionPane.YES_OPTION;
	}

	return true;
    }

    public void cancel()
    {
	if (startup) {
	    System.exit(0);
	}
	else {
	    super.cancel();
	}
    }

    public static void showDialog(Component c, boolean startup)
    {
	StartupWizardDialog me = new StartupWizardDialog();
	if (c != null) {
	    me.setLocationRelativeTo(c);
	}
	me.startup = startup;
	me.show();
    }

}
