/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.gui;

import xnap.util.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * 
 */
public class EnableAction extends AbstractAction {
    
    // --- Data Field(s) ---

    private Component[] components;
    private JCheckBox jcb = null;
    private boolean selected;

    // --- Method(s) ---

    public EnableAction(String name, Component[] components, boolean selected)
    {
	this.components = components;

	putValue(Action.NAME, name);

	setSelected(selected);
    }

    public EnableAction(Component[] components, JCheckBox jcb)
    {
	this.components = components;

	setCheckBox(jcb);
    }
    
    public void actionPerformed(ActionEvent event) 
    {
	if (event.getSource() instanceof JCheckBox) {
	    JCheckBox jcb = (JCheckBox)event.getSource();
	    setSelected(jcb.isSelected());
	}
    }

    public boolean isSelected()
    {
	return selected;
    }

    public JCheckBox getCheckBox()
    {
	if (jcb == null) {
	    jcb = new JCheckBox(this);
	    jcb.setSelected(selected);
	}
	return jcb;
    }

    public void setCheckBox(JCheckBox newValue)
    {
	jcb = newValue;
	putValue(Action.NAME, jcb.getText());
	jcb.setAction(this);
	setSelected(jcb.isSelected());
    }

    public void setSelected(boolean newValue)
    {
	selected = newValue;

	if (jcb != null) {
	    jcb.setSelected(selected);
	}

	if (components != null) {
	    for (int i = 0; i < components.length; i++) {
		traverseComponent(components[i]);
	    }
	}
    }

    private void traverseComponent(Component c)
    {
	c.setEnabled(selected);
	if (c instanceof Container) {
	    Component[] children = ((Container)c).getComponents();
	    for (int i = 0; i < children.length; i++) {
		traverseComponent(children[i]);
	    }
	}
    }
}

