/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.gui;

import xnap.gui.util.GUIHelper;
import xnap.util.*;

import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.text.*;

public class ChatPane extends JScrollPane implements PropertyChangeListener {

    //--- Constant(s) ---

    //--- Data field(s) ---

    protected static Preferences prefs = Preferences.getInstance();
    protected static StyleContext styles = new StyleContext();
    static {
	updateStyles();
	
	PropertyChangeListener l = new PropertyChangeListener() 
	    {
		public void propertyChange(PropertyChangeEvent e)
		{
		    updateStyles();
		}
	    };


	prefs.addFontListener("chat", l);
	prefs.addColorListener("chatMessage", l);
	prefs.addColorListener("chatUser", l);
	prefs.addColorListener("chatInfo", l);
	prefs.addColorListener("chatError", l);
    }

    private JTextPane jtp;

    //--- Constructor(s) ---

    public ChatPane()
    {
	jtp = new JTextPane();
        jtp.setBackground(GUIHelper.getColor("chatBackground"));
        jtp.setEditable(false); 
	jtp.setBorder(new EmptyBorder(5, 5, 5, 5));

	setVerticalScrollBarPolicy
	    (JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
	setHorizontalScrollBarPolicy
	    (JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);

	setViewportView(jtp);

	prefs.addColorListener("chatBackground", this);
    }
    
    //--- Method(s) ---

    public static Style getStyle(String key)
    {
	return styles.getStyle(key);
    }

    public static void setStyle(String key, Color color, Font font)
    {
	Style def = styles.getStyle(StyleContext.DEFAULT_STYLE);
	Style s = styles.addStyle(key, def);
	StyleConstants.setForeground(s, color);
	StyleConstants.setFontFamily(s, font.getName());
	StyleConstants.setFontSize(s, font.getSize());
	StyleConstants.setItalic(s, font.isItalic());
	StyleConstants.setBold(s, font.isBold());
    }

    public static void updateStyles()
    {
	Font font = GUIHelper.getFont("chat");

	setStyle("chatMessage", GUIHelper.getColor("chatMessage"), font);
	setStyle("chatUser", GUIHelper.getColor("chatUser"), font);
	setStyle("chatInfo", GUIHelper.getColor("chatInfo"), font);
	setStyle("chatError", GUIHelper.getColor("chatError"), font);
    }

    public void appendLater(final String text, final String style)
    {
	Runnable r = new Runnable()
	    {
		public void run() 
		{
		    append(text, style);
		}
	    };

	SwingUtilities.invokeLater(r);
    }

    public void appendLater(final String text)
    {
	appendLater(text, StyleContext.DEFAULT_STYLE);
    }

    public void append(String text, String style) 
    {
	Document doc = jtp.getDocument();
	try {
	    doc.insertString(doc.getLength(), text, getStyle(style));
	}
	catch (BadLocationException e) {
	}

	JScrollBar sb = getVerticalScrollBar();
	int max = sb.getMaximum();
	int ext = sb.getModel().getExtent();

	sb.setValue(max - ext);
    }

    public void propertyChange(PropertyChangeEvent e)
    {
        jtp.setBackground(GUIHelper.getColor("chatBackground"));
    }

    public void setText(String newValue)
    {
	jtp.setText(newValue);
    }

}
