/*
Copyright (C) 2007 Bastian Suter ("Sable")

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/************************************************************************/
/* BattlEye Client code                                                 */
/************************************************************************/

#include "../qcommon/qcommon.h"
#include "../qcommon/sys_library.h"
#include "client.h"


#ifdef BATTLEYE

#if defined(_M_IX86) || defined(__i386__)
#undef ARCH
#define ARCH "x86"
#elif defined(_M_AMD64) || defined(__x86_64__)
#undef ARCH
#define ARCH "x64"
#endif

int FS_AbsoluteFileExists( const char *filename );


static void CL_BE_SendPacket(void *packet, size_t len)
{
	MSG_WriteByte(&cls.be.outMsg, clc_battleye);
	MSG_WriteShort(&cls.be.outMsg, len);
	MSG_CopyData(&cls.be.outMsg, packet, len);
}

static void CL_BE_PrintMessage(char *message)
{
	Com_Printf(S_COLOR_RED "BattlEye Client" S_COLOR_WHITE ": %s\n", message);
}


void CL_BE_Load(void)
{
	if (clbe.module)
		return;

	if (FS_AbsoluteFileExists(va("%s/BattlEye/BEClient_" ARCH LIB_SUFFIX, FS_WriteDirectory())) == -1)
		FS_CopyBaseFile("BattlEye/BEClient_" ARCH LIB_SUFFIX, "BattlEye/BEClient_" ARCH LIB_SUFFIX);

	if ((clbe.module = Sys_Library_Open(va("%s/BattlEye/BEClient_" ARCH LIB_SUFFIX, FS_WriteDirectory()))))
	{
		// the BE "Init" export
		qbyte (*Init)(void (*)(char *), void (*)(void *, size_t), qbyte (**)(void), void (**)(char *), void (**)(void *, size_t));
		if ((Init = Sys_Library_ProcAddress(clbe.module, "Init")))
		{
			if (!Init(&CL_BE_PrintMessage, &CL_BE_SendPacket, &clbe.Run, &clbe.Command, &clbe.NewPacket))
			{
				CL_BE_Unload();
				Com_Error(ERR_DROP, "Failed to initialize BattlEye Client");
			}
		}
		else
		{
			CL_BE_Unload();
			Com_Error(ERR_DROP, "Failed to get BattlEye Client procedure. %s", Sys_Library_ErrorString());
		}
	}
	else
		Com_Error(ERR_DROP, "Failed to load BattlEye Client. %s", Sys_Library_ErrorString());
}

void CL_BE_Unload(void)
{
	if (!clbe.module)
		return;

	if (Sys_Library_Close(clbe.module))
		clbe.module = NULL;
	else
		Com_Error(ERR_DROP, "Failed to unload BattlEye Client. %s", Sys_Library_ErrorString());
}

void CL_BEClientCmd_f(void)
{
	if (clbe.module && Cmd_Argc() > 1)
		clbe.Command(Cmd_Args());
}

#endif // BATTLEYE
