#include <stdio.h>
#include <sys/types.h>
#include <pwd.h>
#include "vpopmail.h"
#include "vauth.h"
#include "global.h"

extern char allowpassword;

int add_user(char *user, char *domain, char *password, char *fname)
{
  int ret = 0;
  char cwd[255];
  struct passwd *pw = NULL;

  memset((char *)cwd, 0, 255);
  getcwd(cwd, 255);
 
  pw = (struct passwd *)vauth_getpw(user, domain);
  if (pw) {
     chdir(cwd);

     global_warning("That username is already in use");
  
     if (allowpassword)
        t_open(T_REGISTER_WITH_PASSWORD);
     else
        t_open(T_REGISTER);
  }

  ret = vadduser(user, domain, password, fname, USE_POP);

  chdir(cwd);

  return ret;
}

int del_user(char *user, char *dom)
{
  int ret = 0;
  char cwd[255];

  memset((char *)cwd, 0, 255);
  getcwd(cwd, 255);
 
  ret = vdeluser(user, dom);

  chdir(cwd);

  return ret;  
}
