#include <pwd.h>

#define VQREGISTER_VERSION "2.5"

/*
   Variable maximum lengths
*/
#define MAX_CONTENT_LENGTH 10000
#define MAX_GLOBAL_LENGTH 500
#define MAX_TEMPLATE_LINE_LENGTH 500
#define MAX_PASSWORD_LENGTH 28
#define MAX_USERNAME_LENGTH 28
#define MAX_EMAIL_LENGTH (64 + 1 + MAX_USERNAME_LENGTH + 1)

/*
   Template definitions
*/
#define T_INIT_ERROR "html/init_error.html"
#define T_ERROR "html/error.html"
#define T_REGISTER "html/register.html"
#define T_REGISTER_WITH_PASSWORD "html/register.with.password.html"
#define T_SUCCESS "html/success.html"
#define T_SUCCESS_WITH_PASSWORD "html/success.with.password.html"
#define T_FAILURE "html/failure.html"

#define ET_EMAIL "vqregister.email"

/* main.c */

/* cgi.c */
void cgi_nav(void);
void cgi_var(void);
void cgi_parse_hex(void);
void cgi_env(void);
void cgi_init(void);
char *cgi_is_env(char *);
char *cgi_is_var(char *);
char matoh(char);
unsigned char hex2asc(char, char);

/* template.c */
void t_code(char);
void g_code(char *, int);
void t_printf(char *, int);
void t_open(char *);
void et_open(int, char *);
void a_code(char *, char *);
void p_code(char *, char *);

/* global.c */
void global_init(void);
void global_error(char *, char, char);
void global_warning(char *);
void global_par(char *, char *);
char *f_global_par(char *);
void global_f_warning(void);

/* misc.c */
char *mstrdup(char *);
void tfatal(void);

/* config.c */
int config_open(char *);
void read_config(void);
void parse_config(char *);
void conf_lookup(char *, char *);
void init_domains(void);
void add_domain(char *);
int is_domain(char *);
void show_html_domains(void);
void allowpassword_set(char *);
void verify_set(char *);
void redirect_set(char *);
void password_set(char *);
void password_len_set(char *);
void adminemail_set(char *);
void registeruser_set(char *);
void subject_set(char *);
void use_db_set(char *);
void db_user_set(char *);
void db_password_set(char *);
void db_fields_set(char *);
void init_fields(void);
void add_fields(char *, char **);
void db_host_set(char *);
void advertise_set(char *);
void badhosts_set(char *);

/* register.c */
void go_register(void);
int send_email(void);
char *setup_var(char *, char *);

/* password.c */
char *gen_pass(char);

/* vpopmail.c */
int add_user(char *, char *, char *, char *);
int del_user(char *, char *);

/* db.c */
int db_open(void);
void db_close(void);
int db_insert_data(char *, char **, char **);

/* field.c */
void field_trigger(void);
int fields_okay(void);
int test_fields(char **, char *);
void inc_nb(char *);
void proc_field(char *, char **);
