#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "global.h"
#include "field.h"
#include "db_misc.h"

extern char allowpassword;
extern struct field_t *fields;

void field_trigger(void)
{
  struct field_t *f = NULL;

  if (fields == NULL)
     return;

  if (fields->next == NULL)
     return;

  for (f = fields; f->next; f = f->next)
      proc_field(f->next->tname, f->next->fields);  
}

int fields_okay(void)
{
  int ret = 0, eret = 0;
  struct field_t *f = NULL;
  char nb[3] = { 0, 0, 0 };

  if (fields == NULL)
     return 1;

  if (fields->next == NULL)
     return 1;

  *nb = '0';
  *(nb + 1) = '0';

  for (eret = 1, f = fields; f->next; f = f->next) {
      ret = test_fields(f->next->fields, nb);
      if (ret == 0)
         eret = 0;
  }

  return eret;
}

int test_fields(char **nfields, char *nb)
{
  int i = 0, eret = 0;
  char *p = NULL, *g = NULL;

  for (eret = 1, i = 0; nfields[i]; i++, inc_nb(nb)) {
      p = cgi_is_var(nfields[i]);
      if (p == NULL) {
         /*
            Special case variable which may not yet be defined.
         */
         if (!(strcasecmp(nfields[i], "pass"))) {
            g = f_global_par("RP");
            if ((g == NULL) || (!(*g)))
               eret = 0;       

            else
               global_par(nb, g);
         }

         else
            eret = 0;
      }

      else
         global_par(nb, p);
  }

  return eret;
}

/*
   Silly, but fun to write. :)
*/
void inc_nb(char *nb)
{
  if (*(nb + 1) < '9') {
     (*(nb + 1))++;
     return;
  }

  if (*(nb + 1) == '9') {
     if (*nb == '9')
        return;

     *(nb + 1) = '0';
     nb[0]++;
     return;
  }
}

void proc_field(char *tname, char **nfields)
{
  char **fields = NULL, *p = NULL;
  int ret = 0, i = 0, n = 0, k = 0;

  for (n = 0; nfields[n]; n++);

  fields = (char **)malloc(sizeof(char *) * (n + 1));

  if (fields == NULL)
     global_error("Out of memory during field processing", 0, 0);
  
  for (i = 0; nfields[i]; i++) {
      fields[i] = cgi_is_var(nfields[i]);

      if ((fields[i] == NULL) || (!(*fields[i]))) {
         if (!(strcasecmp(nfields[i], "pass"))) {
            p = f_global_par("RP");
            if ((p == NULL) || (!(*p)))
	       global_error("Internal field check error.", 0, 0);
            else
               fields[i] = p;
         }         
         else
	    global_error("Internal field check error.", 0, 0);
      }
  }

  fields[i] = NULL;

  ret = db_open();

  if (ret == DB_E_CREDENTIALS)
     global_error("Unable to authenticate with database.", 0, 0);

  else if (ret == DB_E_CONNECT)
     global_error("Unable to connect to database.", 0, 0);

  else if (ret == DB_E_DATABASE)
     global_error("Unable to switch to database.", 0, 0);

  /*
     Using db_null.c
  */  
  else if (ret == DB_E_NONE)
     return;

  db_insert_data(tname, nfields, fields);

  db_close();
}
