/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMRGINFO;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.NMTVCUSTOMDRAW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.TVHITTESTINFO;
import org.eclipse.swt.internal.win32.TVINSERTSTRUCT;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tree
extends Composite {
    int hAnchor;
    TreeItem[] items;
    ImageList imageList;
    boolean dragStarted;
    boolean gestureCompleted;
    boolean ignoreSelect;
    boolean ignoreExpand;
    boolean ignoreDeselect;
    boolean customDraw;
    static final int TreeProc;
    static final TCHAR TreeClass;

    static {
        TreeClass = new TCHAR(0, "SysTreeView32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, TreeClass, wNDCLASS);
        TreeProc = wNDCLASS.lpfnWndProc;
    }

    public Tree(Composite composite, int n) {
        super(composite, Tree.checkStyle(n));
    }

    static int checkStyle(int n) {
        return Widget.checkBits(n |= 0x300, 4, 2, 0, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(treeListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int callWindowProc(int n, int n2, int n3) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(TreeProc, this.handle, n, n2, n3);
    }

    boolean checkScroll(int n) {
        if (this.drawCount == 0) {
            return false;
        }
        int n2 = OS.SendMessage(this.handle, 4362, 0, 0);
        int n3 = OS.SendMessage(this.handle, 4362, 3, n);
        while (n3 != n2 && n3 != 0) {
            n3 = OS.SendMessage(this.handle, 4362, 3, n3);
        }
        return n3 == 0;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        RECT rECT = new RECT();
        int n5 = OS.SendMessage(this.handle, 4362, 0, 0);
        while (n5 != 0) {
            rECT.left = n5;
            if (OS.SendMessage(this.handle, 4356, 1, rECT) != 0) {
                n3 = Math.max(n3, rECT.right);
                n4 += rECT.bottom - rECT.top;
            }
            n5 = OS.SendMessage(this.handle, 4362, 1, n5);
        }
        if (n3 == 0) {
            n3 = 64;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        int n6 = this.getBorderWidth();
        n3 += n6 * 2;
        n4 += n6 * 2;
        if ((this.style & 0x200) != 0) {
            n3 += OS.GetSystemMetrics(2);
        }
        if ((this.style & 0x100) != 0) {
            n4 += OS.GetSystemMetrics(3);
        }
        return new Point(n3, n4);
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFFFD;
        if (OS.COMCTL32_MAJOR < 6) {
            OS.SendMessage(this.handle, 8199, 5, 0);
        }
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageList();
        }
        int n = OS.GetStockObject(13);
        OS.SendMessage(this.handle, 48, n, 0);
    }

    void createItem(TreeItem treeItem, int n, int n2) {
        int n3;
        TreeItem[] treeItemArray;
        treeItem.font = -1;
        treeItem.background = -1;
        treeItem.foreground = -1;
        int n4 = 0;
        while (n4 < this.items.length && this.items[n4] != null) {
            ++n4;
        }
        if (n4 == this.items.length) {
            treeItemArray = new TreeItem[this.items.length + 4];
            System.arraycopy(this.items, 0, treeItemArray, 0, this.items.length);
            this.items = treeItemArray;
        }
        treeItemArray = new TVINSERTSTRUCT();
        treeItemArray.hParent = n;
        treeItemArray.hInsertAfter = n2;
        treeItemArray.lParam = n4;
        treeItemArray.iSelectedImage = treeItemArray.iImage = -2;
        treeItemArray.mask = 54;
        if ((this.style & 0x20) != 0) {
            treeItemArray.mask |= 8;
            treeItemArray.state = 4096;
            treeItemArray.stateMask = 61440;
        }
        if ((n3 = OS.SendMessage(this.handle, OS.TVM_INSERTITEM, 0, (TVINSERTSTRUCT)treeItemArray)) == 0) {
            this.error(14);
        }
        treeItem.handle = n3;
        this.items[n4] = treeItem;
        if (!OS.IsWindowVisible(this.handle) || this.drawCount > 0) {
            return;
        }
        int n5 = OS.SendMessage(this.handle, 4362, 4, n);
        if (n5 != 0 && OS.SendMessage(this.handle, 4362, 1, n5) == 0) {
            RECT rECT = new RECT();
            rECT.left = n;
            if (OS.SendMessage(this.handle, 4356, 0, rECT) != 0) {
                OS.InvalidateRect(this.handle, rECT, true);
            }
        }
    }

    void createWidget() {
        super.createWidget();
        this.items = new TreeItem[4];
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    public void deselectAll() {
        this.checkWidget();
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 8;
        tVITEM.stateMask = 2;
        if ((this.style & 4) != 0) {
            int n = OS.SendMessage(this.handle, 4362, 9, 0);
            if (n != 0) {
                tVITEM.hItem = n;
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
            }
            return;
        }
        int n = OS.GetWindowLong(this.handle, -4);
        OS.SetWindowLong(this.handle, -4, TreeProc);
        int n2 = 0;
        while (n2 < this.items.length) {
            TreeItem treeItem = this.items[n2];
            if (treeItem != null) {
                tVITEM.hItem = treeItem.handle;
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
            }
            ++n2;
        }
        OS.SetWindowLong(this.handle, -4, n);
    }

    void destroyItem(TreeItem treeItem) {
        int n;
        Object object;
        int n2 = treeItem.handle;
        int n3 = 0;
        boolean bl = false;
        if (this.drawCount == 0 && OS.IsWindowVisible(this.handle)) {
            object = new RECT();
            ((RECT)object).left = n2;
            boolean bl2 = bl = OS.SendMessage(this.handle, 4356, 0, (RECT)object) == 0;
        }
        if (bl) {
            n3 = OS.SendMessage(this.handle, 4362, 3, n2);
            OS.UpdateWindow(this.handle);
            OS.SendMessage(this.handle, 11, 0, 0);
        }
        object = new TVITEM();
        ((TVITEM)object).mask = 20;
        this.releaseItems(treeItem.getItems(), (TVITEM)object);
        this.releaseItem(treeItem, (TVITEM)object);
        OS.SendMessage(this.handle, 4353, 0, n2);
        if (bl) {
            OS.SendMessage(this.handle, 11, 1, 0);
            OS.ValidateRect(this.handle, null);
            if (OS.SendMessage(this.handle, 4362, 4, n3) == 0) {
                RECT rECT = new RECT();
                rECT.left = n3;
                if (OS.SendMessage(this.handle, 4356, 0, rECT) != 0) {
                    OS.InvalidateRect(this.handle, rECT, true);
                }
            }
        }
        if ((n = OS.SendMessage(this.handle, 4357, 0, 0)) == 0) {
            if (this.imageList != null) {
                OS.SendMessage(this.handle, 4361, 0, 0);
                this.display.releaseImageList(this.imageList);
            }
            this.imageList = null;
            this.customDraw = false;
            this.items = new TreeItem[4];
        }
    }

    int getBackgroundPixel() {
        if (OS.IsWinCE) {
            return OS.GetSysColor(OS.COLOR_WINDOW);
        }
        int n = OS.SendMessage(this.handle, 4383, 0, 0);
        if (n == -1) {
            return OS.GetSysColor(OS.COLOR_WINDOW);
        }
        return n;
    }

    int getForegroundPixel() {
        if (OS.IsWinCE) {
            return OS.GetSysColor(OS.COLOR_WINDOWTEXT);
        }
        int n = OS.SendMessage(this.handle, 4384, 0, 0);
        if (n == -1) {
            return OS.GetSysColor(OS.COLOR_WINDOWTEXT);
        }
        return n;
    }

    public TreeItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        TVHITTESTINFO tVHITTESTINFO = new TVHITTESTINFO();
        tVHITTESTINFO.x = point.x;
        tVHITTESTINFO.y = point.y;
        OS.SendMessage(this.handle, 4369, 0, tVHITTESTINFO);
        if (tVHITTESTINFO.hItem != 0 && (tVHITTESTINFO.flags & 0x46) != 0) {
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 20;
            tVITEM.hItem = tVHITTESTINFO.hItem;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
            return this.items[tVITEM.lParam];
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 4362, 0, 0);
        if (n == 0) {
            return 0;
        }
        return this.getItemCount(n);
    }

    int getItemCount(int n) {
        int n2 = 0;
        while (n != 0) {
            n = OS.SendMessage(this.handle, 4362, 1, n);
            ++n2;
        }
        return n2;
    }

    public int getItemHeight() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4380, 0, 0);
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 4362, 0, 0);
        if (n == 0) {
            return new TreeItem[0];
        }
        return this.getItems(n);
    }

    TreeItem[] getItems(int n) {
        Object object;
        int n2 = 0;
        int n3 = n;
        while (n3 != 0) {
            n3 = OS.SendMessage(this.handle, 4362, 1, n3);
            ++n2;
        }
        int n4 = 0;
        TreeItem[] treeItemArray = new TreeItem[n2];
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 20;
        tVITEM.hItem = n;
        while (tVITEM.hItem != 0) {
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
            object = this.items[tVITEM.lParam];
            if (object != null) {
                treeItemArray[n4++] = object;
            }
            tVITEM.hItem = OS.SendMessage(this.handle, 4362, 1, tVITEM.hItem);
        }
        if (n4 != n2) {
            object = new TreeItem[n4];
            System.arraycopy(treeItemArray, 0, object, 0, n4);
            treeItemArray = object;
        }
        return treeItemArray;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int n = OS.SendMessage(this.handle, 4362, 9, 0);
            if (n == 0) {
                return new TreeItem[0];
            }
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 12;
            tVITEM.hItem = n;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
            if ((tVITEM.state & 2) == 0) {
                return new TreeItem[0];
            }
            return new TreeItem[]{this.items[tVITEM.lParam]};
        }
        int n = 0;
        TreeItem[] treeItemArray = new TreeItem[8];
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 12;
        int n2 = OS.GetWindowLong(this.handle, -4);
        OS.SetWindowLong(this.handle, -4, TreeProc);
        int n3 = 0;
        while (n3 < this.items.length) {
            TreeItem treeItem = this.items[n3];
            if (treeItem != null) {
                tVITEM.hItem = treeItem.handle;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
                if ((tVITEM.state & 2) != 0) {
                    if (n < treeItemArray.length) {
                        treeItemArray[n] = treeItem;
                    }
                    ++n;
                }
            }
            ++n3;
        }
        OS.SetWindowLong(this.handle, -4, n2);
        if (n == 0) {
            return new TreeItem[0];
        }
        if (n == treeItemArray.length) {
            return treeItemArray;
        }
        TreeItem[] treeItemArray2 = new TreeItem[n];
        if (n < treeItemArray.length) {
            System.arraycopy(treeItemArray, 0, treeItemArray2, 0, n);
            return treeItemArray2;
        }
        OS.SetWindowLong(this.handle, -4, TreeProc);
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.items.length) {
            TreeItem treeItem = this.items[n5];
            if (treeItem != null) {
                tVITEM.hItem = treeItem.handle;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
                if ((tVITEM.state & 2) != 0) {
                    treeItemArray2[n4++] = treeItem;
                }
            }
            ++n5;
        }
        OS.SetWindowLong(this.handle, -4, n2);
        return treeItemArray2;
    }

    public int getSelectionCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int n = OS.SendMessage(this.handle, 4362, 9, 0);
            if (n == 0) {
                return 0;
            }
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 8;
            tVITEM.hItem = n;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
            if ((tVITEM.state & 2) == 0) {
                return 0;
            }
            return 1;
        }
        int n = 0;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 8;
        int n2 = OS.GetWindowLong(this.handle, -4);
        OS.SetWindowLong(this.handle, -4, TreeProc);
        int n3 = 0;
        while (n3 < this.items.length) {
            TreeItem treeItem = this.items[n3];
            if (treeItem != null) {
                tVITEM.hItem = treeItem.handle;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
                if ((tVITEM.state & 2) != 0) {
                    ++n;
                }
            }
            ++n3;
        }
        OS.SetWindowLong(this.handle, -4, n2);
        return n;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 4362, 5, 0);
        if (n == 0) {
            return null;
        }
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 4;
        tVITEM.hItem = n;
        if (OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM) == 0) {
            return null;
        }
        return this.items[tVITEM.lParam];
    }

    int imageIndex(Image image) {
        if (image == null) {
            return -2;
        }
        if (this.imageList == null) {
            int n = OS.SendMessage(this.handle, 4360, 0, 0);
            if (n != 0) {
                OS.ImageList_Destroy(n);
            }
            Rectangle rectangle = image.getBounds();
            this.imageList = this.display.getImageList(new Point(rectangle.width, rectangle.height));
            int n2 = this.imageList.indexOf(image);
            if (n2 == -1) {
                n2 = this.imageList.add(image);
            }
            int n3 = this.imageList.getHandle();
            OS.SendMessage(this.handle, 4361, 0, n3);
            return n2;
        }
        int n = this.imageList.indexOf(image);
        if (n != -1) {
            return n;
        }
        return this.imageList.add(image);
    }

    boolean releaseItem(TreeItem treeItem, TVITEM tVITEM) {
        int n = treeItem.handle;
        if (n == this.hAnchor) {
            this.hAnchor = 0;
        }
        if (treeItem.isDisposed()) {
            return false;
        }
        tVITEM.hItem = n;
        OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
        this.items[tVITEM.lParam] = null;
        return true;
    }

    void releaseItems(TreeItem[] treeItemArray, TVITEM tVITEM) {
        int n = 0;
        while (n < treeItemArray.length) {
            TreeItem treeItem = treeItemArray[n];
            TreeItem[] treeItemArray2 = treeItem.getItems();
            if (treeItemArray2.length != 0) {
                this.releaseItems(treeItemArray2, tVITEM);
            }
            if (this.releaseItem(treeItem, tVITEM)) {
                treeItem.releaseResources();
            }
            ++n;
        }
    }

    void releaseWidget() {
        int n = 0;
        while (n < this.items.length) {
            TreeItem treeItem = this.items[n];
            if (treeItem != null && !treeItem.isDisposed()) {
                treeItem.releaseResources();
            }
            ++n;
        }
        this.customDraw = false;
        this.items = null;
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4361, 0, 0);
            this.display.releaseImageList(this.imageList);
        } else {
            n = OS.SendMessage(this.handle, 4360, 0, 0);
            OS.SendMessage(this.handle, 4361, 0, 0);
            if (n != 0) {
                OS.ImageList_Destroy(n);
            }
        }
        this.imageList = null;
        n = OS.SendMessage(this.handle, 4360, 2, 0);
        OS.SendMessage(this.handle, 4361, 2, 0);
        if (n != 0) {
            OS.ImageList_Destroy(n);
        }
        super.releaseWidget();
    }

    public void removeAll() {
        boolean bl;
        this.checkWidget();
        this.ignoreSelect = true;
        this.ignoreDeselect = true;
        boolean bl2 = bl = this.drawCount == 0 && OS.IsWindowVisible(this.handle);
        if (bl) {
            OS.DefWindowProc(this.handle, 11, 0, 0);
        }
        int n = OS.SendMessage(this.handle, 4353, 0, -65536);
        if (bl) {
            OS.DefWindowProc(this.handle, 11, 1, 0);
            OS.InvalidateRect(this.handle, null, true);
        }
        this.ignoreSelect = false;
        this.ignoreDeselect = false;
        if (n == 0) {
            this.error(15);
        }
        int n2 = 0;
        while (n2 < this.items.length) {
            TreeItem treeItem = this.items[n2];
            if (treeItem != null && !treeItem.isDisposed()) {
                treeItem.releaseResources();
            }
            ++n2;
        }
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4361, 0, 0);
            this.display.releaseImageList(this.imageList);
        }
        this.imageList = null;
        this.customDraw = false;
        this.items = new TreeItem[4];
        this.hAnchor = 0;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, treeListener);
        this.eventTable.unhook(18, treeListener);
    }

    public void setInsertMark(TreeItem treeItem, boolean bl) {
        this.checkWidget();
        int n = 0;
        if (treeItem != null) {
            if (treeItem.isDisposed()) {
                this.error(5);
            }
            n = treeItem.handle;
        }
        OS.SendMessage(this.handle, 4378, bl ? 0 : 1, n);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 8;
        tVITEM.state = 2;
        tVITEM.stateMask = 2;
        int n = OS.GetWindowLong(this.handle, -4);
        OS.SetWindowLong(this.handle, -4, TreeProc);
        int n2 = 0;
        while (n2 < this.items.length) {
            TreeItem treeItem = this.items[n2];
            if (treeItem != null) {
                tVITEM.hItem = treeItem.handle;
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
            }
            ++n2;
        }
        OS.SetWindowLong(this.handle, -4, n);
    }

    void setBackgroundPixel(int n) {
        if (this.background == n) {
            return;
        }
        this.background = n;
        int n2 = OS.SendMessage(this.handle, 4383, 0, 0);
        if (n2 != -1) {
            OS.SendMessage(this.handle, 4381, 0, -1);
        }
        OS.SendMessage(this.handle, 4381, 0, n);
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageList();
        }
    }

    void setBounds(int n, int n2, int n3, int n4, int n5) {
        int n6;
        boolean bl = false;
        if ((n5 & 1) == 0 && (n3 != 0 || n4 != 0) && OS.SendMessage(this.handle, 4368, 0, 0) == 0) {
            bl = true;
        }
        super.setBounds(n, n2, n3, n4, n5);
        if (bl && (n6 = OS.SendMessage(this.handle, 4362, 9, 0)) != 0) {
            this.showItem(n6);
        }
    }

    void setCursor() {
        Cursor cursor = this.findCursor();
        int n = cursor == null ? OS.LoadCursor(0, 32512) : cursor.handle;
        OS.SetCursor(n);
    }

    void setCheckboxImageList() {
        int n;
        if ((this.style & 0x20) == 0) {
            return;
        }
        int n2 = 5;
        int n3 = n = OS.SendMessage(this.handle, 4380, 0, 0);
        int n4 = OS.ImageList_Create(n3, n, 0, n2, n2);
        int n5 = OS.GetDC(this.handle);
        if (!OS.IsWinCE && (OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) >= 262154) {
            OS.SetLayout(n5, 0);
        }
        int n6 = OS.CreateCompatibleDC(n5);
        int n7 = OS.CreateCompatibleBitmap(n5, n3 * n2, n);
        int n8 = OS.SelectObject(n6, n7);
        RECT rECT = new RECT();
        OS.SetRect(rECT, 0, 0, n3 * n2, n);
        int n9 = OS.CreateSolidBrush(this.getBackgroundPixel());
        OS.FillRect(n6, rECT, n9);
        OS.DeleteObject(n9);
        int n10 = OS.SelectObject(n5, this.defaultFont());
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(n5, tEXTMETRIC);
        OS.SelectObject(n5, n10);
        int n11 = Math.min(tEXTMETRIC.tmHeight, n3);
        int n12 = Math.min(tEXTMETRIC.tmHeight, n);
        int n13 = (n3 - n11) / 2;
        int n14 = (n - n12) / 2 + 1;
        OS.SetRect(rECT, n13 + n3, n14, n13 + n3 + n11, n14 + n12);
        OS.DrawFrameControl(n6, rECT, 4, 16384);
        rECT.left += n3;
        rECT.right += n3;
        OS.DrawFrameControl(n6, rECT, 4, 17408);
        rECT.left += n3;
        rECT.right += n3;
        OS.DrawFrameControl(n6, rECT, 4, 16640);
        rECT.left += n3;
        rECT.right += n3;
        OS.DrawFrameControl(n6, rECT, 4, 17664);
        OS.SelectObject(n6, n8);
        OS.DeleteDC(n6);
        OS.ReleaseDC(this.handle, n5);
        OS.ImageList_AddMasked(n4, n7, 0);
        OS.DeleteObject(n7);
        int n15 = OS.SendMessage(this.handle, 4360, 2, 0);
        OS.SendMessage(this.handle, 4361, 2, n4);
        if (n15 != 0) {
            OS.ImageList_Destroy(n15);
        }
    }

    void setForegroundPixel(int n) {
        if (this.foreground == n) {
            return;
        }
        this.foreground = n;
        OS.SendMessage(this.handle, 4382, 0, n);
    }

    public void setRedraw(boolean bl) {
        int n;
        this.checkWidget();
        int n2 = 0;
        if (bl && this.drawCount == 1 && (n = OS.SendMessage(this.handle, 4357, 0, 0)) == 0) {
            TVINSERTSTRUCT tVINSERTSTRUCT = new TVINSERTSTRUCT();
            tVINSERTSTRUCT.hInsertAfter = -65535;
            n2 = OS.SendMessage(this.handle, OS.TVM_INSERTITEM, 0, tVINSERTSTRUCT);
        }
        super.setRedraw(bl);
        if (n2 != 0) {
            OS.SendMessage(this.handle, 4353, 0, n2);
        }
    }

    public void setSelection(TreeItem[] treeItemArray) {
        int n;
        int n2;
        int n3;
        this.checkWidget();
        if (treeItemArray == null) {
            this.error(4);
        }
        if ((n3 = treeItemArray.length) == 0 || (this.style & 4) != 0 && n3 > 1) {
            this.deselectAll();
            return;
        }
        TreeItem treeItem = treeItemArray[0];
        if (treeItem != null) {
            if (treeItem.isDisposed()) {
                this.error(5);
            }
            int n4 = OS.SendMessage(this.handle, 4362, 9, 0);
            this.hAnchor = treeItem.handle;
            n2 = this.hAnchor;
            n = this.checkScroll(n2);
            if (n != 0) {
                OS.SendMessage(this.handle, 11, 1, 0);
                OS.DefWindowProc(this.handle, 11, 0, 0);
            }
            this.ignoreSelect = true;
            OS.SendMessage(this.handle, 4363, 9, n2);
            this.ignoreSelect = false;
            if (OS.SendMessage(this.handle, 4368, 0, 0) == 0) {
                OS.SendMessage(this.handle, 4363, 5, n2);
            }
            if (n != 0) {
                OS.DefWindowProc(this.handle, 11, 1, 0);
                OS.SendMessage(this.handle, 11, 0, 0);
            }
            if (n4 == n2) {
                TVITEM tVITEM = new TVITEM();
                tVITEM.mask = 8;
                tVITEM.state = 2;
                tVITEM.stateMask = 2;
                tVITEM.hItem = n2;
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
                this.showItem(n2);
            }
        }
        if ((this.style & 4) != 0) {
            return;
        }
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 8;
        tVITEM.stateMask = 2;
        n2 = OS.GetWindowLong(this.handle, -4);
        OS.SetWindowLong(this.handle, -4, TreeProc);
        n = 0;
        while (n < this.items.length) {
            treeItem = this.items[n];
            if (treeItem != null) {
                int n5 = 0;
                while (n5 < n3) {
                    if (treeItemArray[n5] == treeItem) break;
                    ++n5;
                }
                tVITEM.hItem = treeItem.handle;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
                if ((tVITEM.state & 2) != 0) {
                    if (n5 == n3) {
                        tVITEM.state = 0;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
                    }
                } else if (n5 != n3) {
                    tVITEM.state = 2;
                    OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
                }
            }
            ++n;
        }
        OS.SetWindowLong(this.handle, -4, n2);
    }

    public void setTopItem(TreeItem treeItem) {
        int n;
        boolean bl;
        this.checkWidget();
        if (treeItem == null) {
            SWT.error(4);
        }
        if (treeItem.isDisposed()) {
            SWT.error(5);
        }
        if (bl = this.checkScroll(n = treeItem.handle)) {
            OS.SendMessage(this.handle, 11, 1, 0);
            OS.DefWindowProc(this.handle, 11, 0, 0);
        }
        OS.SendMessage(this.handle, 4363, 5, n);
        if (bl) {
            OS.DefWindowProc(this.handle, 11, 1, 0);
            OS.SendMessage(this.handle, 11, 0, 0);
        }
    }

    void showItem(int n) {
        if (OS.SendMessage(this.handle, 4368, 0, 0) == 0) {
            boolean bl = this.checkScroll(n);
            if (bl) {
                OS.SendMessage(this.handle, 11, 1, 0);
                OS.DefWindowProc(this.handle, 11, 0, 0);
            }
            OS.SendMessage(this.handle, 4363, 5, n);
            OS.SendMessage(this.handle, 276, 6, 0);
            if (bl) {
                OS.DefWindowProc(this.handle, 11, 1, 0);
                OS.SendMessage(this.handle, 11, 0, 0);
            }
        } else {
            boolean bl = true;
            RECT rECT = new RECT();
            rECT.left = n;
            if (OS.SendMessage(this.handle, 4356, 1, rECT) != 0) {
                this.forceResize();
                RECT rECT2 = new RECT();
                OS.GetClientRect(this.handle, rECT2);
                POINT pOINT = new POINT();
                pOINT.x = rECT.left;
                pOINT.y = rECT.top;
                if (OS.PtInRect(rECT2, pOINT)) {
                    pOINT.y = rECT.bottom;
                    if (OS.PtInRect(rECT2, pOINT)) {
                        bl = false;
                    }
                }
            }
            if (bl) {
                boolean bl2 = this.checkScroll(n);
                if (bl2) {
                    OS.SendMessage(this.handle, 11, 1, 0);
                    OS.DefWindowProc(this.handle, 11, 0, 0);
                }
                OS.SendMessage(this.handle, 4372, 0, n);
                if (bl2) {
                    OS.DefWindowProc(this.handle, 11, 1, 0);
                    OS.SendMessage(this.handle, 11, 0, 0);
                }
            }
        }
    }

    public void showItem(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        this.showItem(treeItem.handle);
    }

    public void showSelection() {
        this.checkWidget();
        int n = 0;
        if ((this.style & 4) != 0) {
            n = OS.SendMessage(this.handle, 4362, 9, 0);
            if (n == 0) {
                return;
            }
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 8;
            tVITEM.hItem = n;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
            if ((tVITEM.state & 2) == 0) {
                return;
            }
        } else {
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 8;
            int n2 = OS.GetWindowLong(this.handle, -4);
            OS.SetWindowLong(this.handle, -4, TreeProc);
            int n3 = 0;
            while (n3 < this.items.length) {
                TreeItem treeItem = this.items[n3];
                if (treeItem != null) {
                    tVITEM.hItem = treeItem.handle;
                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
                    if ((tVITEM.state & 2) != 0) {
                        n = tVITEM.hItem;
                        break;
                    }
                }
                ++n3;
            }
            OS.SetWindowLong(this.handle, -4, n2);
        }
        if (n != 0) {
            this.showItem(n);
        }
    }

    String toolTipText(NMTTDISPINFO nMTTDISPINFO) {
        int n = OS.SendMessage(this.handle, 4377, 0, 0);
        if (n == nMTTDISPINFO.hwndFrom && this.toolTipText != null) {
            return "";
        }
        return super.toolTipText(nMTTDISPINFO);
    }

    int widgetStyle() {
        int n = super.widgetStyle() | 0x20;
        return n |= 7;
    }

    TCHAR windowClass() {
        return TreeClass;
    }

    int windowProc() {
        return TreeProc;
    }

    LRESULT WM_CHAR(int n, int n2) {
        LRESULT lRESULT = super.WM_CHAR(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n) {
            case 13: {
                Event event = new Event();
                int n3 = OS.SendMessage(this.handle, 4362, 9, 0);
                if (n3 != 0) {
                    TVITEM tVITEM = new TVITEM();
                    tVITEM.hItem = n3;
                    tVITEM.mask = 4;
                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
                    event.item = this.items[tVITEM.lParam];
                }
                this.postEvent(14, event);
            }
            case 27: 
            case 32: {
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT WM_GETOBJECT(int n, int n2) {
        if ((this.style & 0x20) != 0 && this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return super.WM_GETOBJECT(n, n2);
    }

    LRESULT WM_KEYDOWN(int n, int n2) {
        LRESULT lRESULT = super.WM_KEYDOWN(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n) {
            case 32: {
                int n3 = OS.SendMessage(this.handle, 4362, 9, 0);
                if (n3 == 0) break;
                this.hAnchor = n3;
                OS.SendMessage(this.handle, 4372, 0, n3);
                TVITEM tVITEM = new TVITEM();
                tVITEM.mask = 12;
                tVITEM.hItem = n3;
                if ((this.style & 0x20) != 0) {
                    tVITEM.stateMask = 61440;
                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
                    int n4 = tVITEM.state >> 12;
                    n4 = (n4 & 1) != 0 ? ++n4 : --n4;
                    tVITEM.state = n4 << 12;
                    OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
                    if (!OS.IsWinCE) {
                        int n5 = n3;
                        if (OS.COMCTL32_MAJOR >= 6) {
                            n5 = OS.SendMessage(this.handle, 4395, n3, 0);
                        }
                        OS.NotifyWinEvent(32773, this.handle, -4, n5);
                    }
                }
                tVITEM.stateMask = 2;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
                tVITEM.state = (this.style & 2) != 0 && OS.GetKeyState(17) < 0 ? ((tVITEM.state & 2) != 0 ? (tVITEM.state &= 0xFFFFFFFD) : (tVITEM.state |= 2)) : (tVITEM.state |= 2);
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
                Event event = new Event();
                event.item = this.items[tVITEM.lParam];
                this.postEvent(13, event);
                if ((this.style & 0x20) != 0) {
                    event = new Event();
                    event.item = this.items[tVITEM.lParam];
                    event.detail = 32;
                    this.postEvent(13, event);
                }
                return LRESULT.ZERO;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 40: {
                int n6;
                if ((this.style & 4) != 0) break;
                if (OS.GetKeyState(16) < 0 && (n6 = OS.SendMessage(this.handle, 4362, 9, 0)) != 0) {
                    if (this.hAnchor == 0) {
                        this.hAnchor = n6;
                    }
                    this.ignoreDeselect = true;
                    this.ignoreSelect = true;
                    int n7 = this.callWindowProc(256, n, n2);
                    this.ignoreDeselect = false;
                    this.ignoreSelect = false;
                    int n8 = OS.SendMessage(this.handle, 4362, 9, 0);
                    TVITEM tVITEM = new TVITEM();
                    tVITEM.mask = 8;
                    tVITEM.stateMask = 2;
                    int n9 = n6;
                    RECT rECT = new RECT();
                    rECT.left = this.hAnchor;
                    OS.SendMessage(this.handle, 4356, 1, rECT);
                    RECT rECT2 = new RECT();
                    rECT2.left = n9;
                    OS.SendMessage(this.handle, 4356, 1, rECT2);
                    int n10 = rECT.top < rECT2.top ? 7 : 6;
                    while (n9 != this.hAnchor) {
                        tVITEM.hItem = n9;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
                        n9 = OS.SendMessage(this.handle, 4362, n10, n9);
                    }
                    int n11 = this.hAnchor;
                    rECT.left = n8;
                    OS.SendMessage(this.handle, 4356, 1, rECT);
                    rECT2.left = n11;
                    OS.SendMessage(this.handle, 4356, 1, rECT2);
                    tVITEM.state = 2;
                    n10 = rECT.top < rECT2.top ? 7 : 6;
                    while (n11 != n8) {
                        tVITEM.hItem = n11;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
                        n11 = OS.SendMessage(this.handle, 4362, n10, n11);
                    }
                    tVITEM.hItem = n8;
                    OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
                    tVITEM.mask = 4;
                    tVITEM.hItem = n8;
                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
                    Event event = new Event();
                    event.item = this.items[tVITEM.lParam];
                    this.postEvent(13, event);
                    return new LRESULT(n7);
                }
                if (OS.GetKeyState(17) < 0 && (n6 = OS.SendMessage(this.handle, 4362, 9, 0)) != 0) {
                    RECT rECT;
                    TVITEM tVITEM = new TVITEM();
                    tVITEM.mask = 8;
                    tVITEM.stateMask = 2;
                    tVITEM.hItem = n6;
                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
                    boolean bl = (tVITEM.state & 2) != 0;
                    int n12 = 0;
                    block4 : switch (n) {
                        case 38: {
                            n12 = OS.SendMessage(this.handle, 4362, 7, n6);
                            break;
                        }
                        case 40: {
                            n12 = OS.SendMessage(this.handle, 4362, 6, n6);
                            break;
                        }
                        case 36: {
                            n12 = OS.SendMessage(this.handle, 4362, 0, 0);
                            break;
                        }
                        case 33: {
                            n12 = OS.SendMessage(this.handle, 4362, 5, 0);
                            if (n12 != n6) break;
                            OS.SendMessage(this.handle, 277, 2, 0);
                            n12 = OS.SendMessage(this.handle, 4362, 5, 0);
                            break;
                        }
                        case 34: {
                            int n13;
                            RECT rECT3 = new RECT();
                            rECT = new RECT();
                            OS.GetClientRect(this.handle, rECT);
                            n12 = OS.SendMessage(this.handle, 4362, 5, 0);
                            while ((n13 = OS.SendMessage(this.handle, 4362, 6, n12)) != 0) {
                                rECT3.left = n13;
                                OS.SendMessage(this.handle, 4356, 1, rECT3);
                                if (rECT3.bottom > rECT.bottom) break block4;
                                n12 = n13;
                                if (n12 == n6) {
                                    OS.SendMessage(this.handle, 277, 3, 0);
                                }
                                if (n12 != 0) continue;
                                break block4;
                            }
                            break;
                        }
                        case 35: {
                            n12 = OS.SendMessage(this.handle, 4362, 10, 0);
                        }
                    }
                    if (n12 != 0) {
                        boolean bl2;
                        OS.SendMessage(this.handle, 4372, 0, n12);
                        tVITEM.hItem = n12;
                        OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
                        boolean bl3 = bl2 = (tVITEM.state & 2) != 0;
                        if (!bl2 && this.drawCount == 0) {
                            OS.UpdateWindow(this.handle);
                            OS.DefWindowProc(this.handle, 11, 0, 0);
                        }
                        this.ignoreSelect = true;
                        OS.SendMessage(this.handle, 4363, 9, n12);
                        this.ignoreSelect = false;
                        if (bl) {
                            tVITEM.state = 2;
                            tVITEM.hItem = n6;
                            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
                        }
                        if (!bl2) {
                            tVITEM.state = 0;
                            tVITEM.hItem = n12;
                            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
                        }
                        if (!bl2 && this.drawCount == 0) {
                            rECT = new RECT();
                            RECT rECT4 = new RECT();
                            rECT.left = n6;
                            rECT4.left = n12;
                            OS.SendMessage(this.handle, 4356, 1, rECT);
                            OS.SendMessage(this.handle, 4356, 1, rECT4);
                            OS.DefWindowProc(this.handle, 11, 1, 0);
                            if (OS.IsWinCE) {
                                OS.InvalidateRect(this.handle, rECT, false);
                                OS.InvalidateRect(this.handle, rECT4, false);
                                OS.UpdateWindow(this.handle);
                            } else {
                                int n14 = 257;
                                OS.RedrawWindow(this.handle, rECT, 0, n14);
                                OS.RedrawWindow(this.handle, rECT4, 0, n14);
                            }
                        }
                        return LRESULT.ZERO;
                    }
                }
                n6 = this.callWindowProc(256, n, n2);
                this.hAnchor = OS.SendMessage(this.handle, 4362, 9, 0);
                return new LRESULT(n6);
            }
        }
        return lRESULT;
    }

    LRESULT WM_KILLFOCUS(int n, int n2) {
        LRESULT lRESULT = super.WM_KILLFOCUS(n, n2);
        if ((this.style & 4) != 0) {
            return lRESULT;
        }
        OS.InvalidateRect(this.handle, null, false);
        return lRESULT;
    }

    LRESULT WM_LBUTTONDOWN(int n, int n2) {
        Object object;
        TVHITTESTINFO tVHITTESTINFO = new TVHITTESTINFO();
        tVHITTESTINFO.x = (short)(n2 & 0xFFFF);
        tVHITTESTINFO.y = (short)(n2 >> 16);
        OS.SendMessage(this.handle, 4369, 0, tVHITTESTINFO);
        if (tVHITTESTINFO.hItem == 0 || (tVHITTESTINFO.flags & 0x46) == 0) {
            this.sendMouseEvent(3, 1, 513, n, n2);
            int n3 = this.callWindowProc(513, n, n2);
            if (OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return new LRESULT(n3);
        }
        if ((this.style & 0x20) != 0 && (tVHITTESTINFO.flags & 0x40) != 0) {
            TVITEM tVITEM = new TVITEM();
            tVITEM.hItem = tVHITTESTINFO.hItem;
            tVITEM.mask = 12;
            tVITEM.stateMask = 61440;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
            int n4 = tVITEM.state >> 12;
            n4 = (n4 & 1) != 0 ? ++n4 : --n4;
            tVITEM.state = n4 << 12;
            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
            if (!OS.IsWinCE) {
                int n5 = tVITEM.hItem;
                if (OS.COMCTL32_MAJOR >= 6) {
                    n5 = OS.SendMessage(this.handle, 4395, tVITEM.hItem, 0);
                }
                OS.NotifyWinEvent(32773, this.handle, -4, n5);
            }
            Event event = new Event();
            event.item = this.items[tVITEM.lParam];
            event.detail = 32;
            this.postEvent(13, event);
            this.sendMouseEvent(3, 1, 513, n, n2);
            if (OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return LRESULT.ZERO;
        }
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 8;
        tVITEM.stateMask = 2;
        boolean bl = false;
        if ((this.style & 2) != 0) {
            tVITEM.hItem = tVHITTESTINFO.hItem;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
            bl = (tVITEM.state & 2) != 0;
        }
        int n6 = OS.SendMessage(this.handle, 4362, 9, 0);
        if ((this.style & 2) != 0) {
            tVITEM.hItem = n6;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
            if (bl || (n & 8) != 0) {
                if (this.drawCount == 0) {
                    OS.UpdateWindow(this.handle);
                    OS.DefWindowProc(this.handle, 11, 0, 0);
                }
            } else {
                this.deselectAll();
            }
        }
        this.sendMouseEvent(3, 1, 513, n, n2);
        this.gestureCompleted = false;
        this.dragStarted = false;
        this.ignoreSelect = true;
        this.ignoreDeselect = true;
        int n7 = this.callWindowProc(513, n, n2);
        this.ignoreSelect = false;
        this.ignoreDeselect = false;
        if (this.dragStarted && OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        int n8 = OS.SendMessage(this.handle, 4362, 9, 0);
        if ((this.style & 4) != 0 && n6 == n8) {
            tVITEM.mask = 8;
            tVITEM.state = 2;
            tVITEM.stateMask = 2;
            tVITEM.hItem = n8;
            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
        }
        if ((this.style & 2) != 0) {
            if (bl || (n & 8) != 0) {
                if (n6 == n8 && n6 == tVHITTESTINFO.hItem) {
                    if ((n & 8) != 0) {
                        tVITEM.state ^= 2;
                        if (this.dragStarted) {
                            tVITEM.state = 2;
                        }
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
                    }
                } else {
                    if ((tVITEM.state & 2) != 0) {
                        tVITEM.state = 2;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
                    }
                    if ((n & 8) != 0 && !this.dragStarted && bl) {
                        tVITEM.state = 0;
                        tVITEM.hItem = tVHITTESTINFO.hItem;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
                    }
                }
                if (this.drawCount == 0) {
                    object = new RECT();
                    RECT rECT = new RECT();
                    ((RECT)object).left = n6;
                    rECT.left = n8;
                    OS.SendMessage(this.handle, 4356, 1, (RECT)object);
                    OS.SendMessage(this.handle, 4356, 1, rECT);
                    OS.DefWindowProc(this.handle, 11, 1, 0);
                    if (OS.IsWinCE) {
                        OS.InvalidateRect(this.handle, (RECT)object, false);
                        OS.InvalidateRect(this.handle, rECT, false);
                        OS.UpdateWindow(this.handle);
                    } else {
                        int n9 = 257;
                        OS.RedrawWindow(this.handle, (RECT)object, 0, n9);
                        OS.RedrawWindow(this.handle, rECT, 0, n9);
                    }
                }
            }
            if (!((n & 8) != 0 || bl && this.dragStarted)) {
                tVITEM.state = 0;
                int n10 = OS.GetWindowLong(this.handle, -4);
                OS.SetWindowLong(this.handle, -4, TreeProc);
                int n11 = 0;
                while (n11 < this.items.length) {
                    TreeItem treeItem = this.items[n11];
                    if (treeItem != null && treeItem.handle != n8) {
                        tVITEM.hItem = treeItem.handle;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
                    }
                    ++n11;
                }
                tVITEM.hItem = n8;
                tVITEM.state = 2;
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
                OS.SetWindowLong(this.handle, -4, n10);
                if ((n & 4) != 0) {
                    RECT rECT = new RECT();
                    if (this.hAnchor == 0) {
                        this.hAnchor = n8;
                    }
                    rECT.left = this.hAnchor;
                    if (OS.SendMessage(this.handle, 4356, 1, rECT) != 0) {
                        RECT rECT2 = new RECT();
                        rECT2.left = n8;
                        OS.SendMessage(this.handle, 4356, 1, rECT2);
                        int n12 = rECT.top < rECT2.top ? 6 : 7;
                        tVITEM.state = 2;
                        int n13 = tVITEM.hItem = this.hAnchor;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
                        while (n13 != n8) {
                            tVITEM.hItem = n13;
                            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tVITEM);
                            n13 = OS.SendMessage(this.handle, 4362, n12, n13);
                        }
                    }
                }
            }
        }
        if ((n & 4) == 0) {
            this.hAnchor = n8;
        }
        if (!this.gestureCompleted) {
            tVITEM.hItem = n8;
            tVITEM.mask = 4;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
            object = new Event();
            ((Event)object).item = this.items[tVITEM.lParam];
            this.postEvent(13, (Event)object);
        }
        this.gestureCompleted = false;
        if (this.dragStarted) {
            object = new Event();
            ((Event)object).x = (short)(n2 & 0xFFFF);
            ((Event)object).y = (short)(n2 >> 16);
            this.postEvent(29, (Event)object);
        } else {
            this.sendMouseEvent(4, 1, 514, n, n2);
        }
        this.dragStarted = false;
        return new LRESULT(n7);
    }

    LRESULT WM_RBUTTONDOWN(int n, int n2) {
        this.sendMouseEvent(3, 3, 516, n, n2);
        this.setFocus();
        TVHITTESTINFO tVHITTESTINFO = new TVHITTESTINFO();
        tVHITTESTINFO.x = (short)(n2 & 0xFFFF);
        tVHITTESTINFO.y = (short)(n2 >> 16);
        OS.SendMessage(this.handle, 4369, 0, tVHITTESTINFO);
        if (tVHITTESTINFO.hItem != 0 && (tVHITTESTINFO.flags & 6) != 0 && (n & 0xC) == 0) {
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 8;
            tVITEM.stateMask = 2;
            tVITEM.hItem = tVHITTESTINFO.hItem;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
            if ((tVITEM.state & 2) == 0) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4363, 9, 0);
                this.ignoreSelect = false;
                OS.SendMessage(this.handle, 4363, 9, tVHITTESTINFO.hItem);
            }
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_SETFOCUS(int n, int n2) {
        LRESULT lRESULT = super.WM_SETFOCUS(n, n2);
        if ((this.style & 4) != 0) {
            return lRESULT;
        }
        OS.InvalidateRect(this.handle, null, false);
        return lRESULT;
    }

    LRESULT WM_SYSCOLORCHANGE(int n, int n2) {
        LRESULT lRESULT = super.WM_SYSCOLORCHANGE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageList();
        }
        return lRESULT;
    }

    LRESULT wmNotifyChild(int n, int n2) {
        NMHDR nMHDR = new NMHDR();
        OS.MoveMemory(nMHDR, n2, 12);
        int n3 = nMHDR.code;
        switch (n3) {
            case -12: {
                if (!this.customDraw) break;
                NMTVCUSTOMDRAW nMTVCUSTOMDRAW = new NMTVCUSTOMDRAW();
                OS.MoveMemory(nMTVCUSTOMDRAW, n2, NMTVCUSTOMDRAW.sizeof);
                switch (nMTVCUSTOMDRAW.dwDrawStage) {
                    case 1: {
                        return new LRESULT(32);
                    }
                    case 65537: {
                        TreeItem treeItem = this.items[nMTVCUSTOMDRAW.lItemlParam];
                        if (treeItem == null) break;
                        TVITEM tVITEM = new TVITEM();
                        tVITEM.mask = 8;
                        tVITEM.hItem = treeItem.handle;
                        OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
                        int n4 = treeItem.font;
                        int n5 = treeItem.foreground;
                        int n6 = treeItem.background;
                        if (n4 == -1 && n5 == -1 && n6 == -1) break;
                        if (n4 != -1) {
                            OS.SelectObject(nMTVCUSTOMDRAW.hdc, n4);
                        }
                        if ((tVITEM.state & 2) == 0) {
                            nMTVCUSTOMDRAW.clrText = n5 == -1 ? this.getForegroundPixel() : n5;
                            nMTVCUSTOMDRAW.clrTextBk = n6 == -1 ? this.getBackgroundPixel() : n6;
                        }
                        OS.MoveMemory(n2, nMTVCUSTOMDRAW, NMTVCUSTOMDRAW.sizeof);
                        return new LRESULT(2);
                    }
                }
                break;
            }
            case -3: {
                int n7 = OS.GetMessagePos();
                POINT pOINT = new POINT();
                pOINT.x = (short)(n7 & 0xFFFF);
                pOINT.y = (short)(n7 >> 16);
                OS.ScreenToClient(this.handle, pOINT);
                TVHITTESTINFO tVHITTESTINFO = new TVHITTESTINFO();
                tVHITTESTINFO.x = pOINT.x;
                tVHITTESTINFO.y = pOINT.y;
                OS.SendMessage(this.handle, 4369, 0, tVHITTESTINFO);
                if ((tVHITTESTINFO.flags & 0x46) == 0) break;
            }
            case -451: 
            case -402: {
                if (!this.ignoreSelect) {
                    int n8;
                    TVITEM tVITEM = null;
                    if (n3 == OS.TVN_SELCHANGED) {
                        tVITEM = new TVITEM();
                        n8 = 56;
                        OS.MoveMemory(tVITEM, n2 + n8, 40);
                        this.hAnchor = tVITEM.hItem;
                    } else {
                        n8 = OS.SendMessage(this.handle, 4362, 9, 0);
                        if (n8 != 0) {
                            tVITEM = new TVITEM();
                            tVITEM.hItem = n8;
                            tVITEM.mask = 4;
                            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tVITEM);
                        }
                    }
                    Event event = new Event();
                    if (tVITEM != null) {
                        event.item = this.items[tVITEM.lParam];
                    }
                    if (n3 == OS.TVN_SELCHANGED) {
                        this.postEvent(13, event);
                    } else {
                        this.postEvent(14, event);
                    }
                }
                if (n3 != -3 || !this.hooks(14)) break;
                return LRESULT.ONE;
            }
            case -450: 
            case -401: {
                if (this.ignoreSelect || this.ignoreDeselect) break;
                this.hAnchor = 0;
                if ((this.style & 2) == 0) break;
                this.deselectAll();
                break;
            }
            case -454: 
            case -405: {
                if (this.ignoreExpand) break;
                TVITEM tVITEM = new TVITEM();
                int n9 = 56;
                OS.MoveMemory(tVITEM, n2 + n9, 40);
                int[] nArray = new int[1];
                OS.MoveMemory(nArray, n2 + 12, 4);
                TreeItem treeItem = this.items[tVITEM.lParam];
                if (treeItem == null) break;
                Event event = new Event();
                event.item = treeItem;
                if (nArray[0] == 2) {
                    this.sendEvent(17, event);
                    if (this.isDisposed()) {
                        return LRESULT.ZERO;
                    }
                }
                if (nArray[0] != 1) break;
                this.sendEvent(18, event);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
            case -457: 
            case -456: 
            case -408: 
            case -407: {
                TVITEM tVITEM = new TVITEM();
                int n10 = 56;
                OS.MoveMemory(tVITEM, n2 + n10, 40);
                if (tVITEM.hItem != 0 && (tVITEM.state & 2) == 0) {
                    this.ignoreDeselect = true;
                    this.ignoreSelect = true;
                    OS.SendMessage(this.handle, 4363, 9, tVITEM.hItem);
                    this.ignoreDeselect = false;
                    this.ignoreSelect = false;
                }
                this.dragStarted = true;
                break;
            }
            case -16: {
                boolean bl;
                if (!OS.IsPPC) break;
                boolean bl2 = bl = this.menu != null && !this.menu.isDisposed();
                if (bl || this.hooks(35)) break;
                return LRESULT.ONE;
            }
            case 1000: {
                boolean bl;
                if (!OS.IsPPC) break;
                boolean bl3 = bl = this.menu != null && !this.menu.isDisposed();
                if (!bl && !this.hooks(35)) break;
                NMRGINFO nMRGINFO = new NMRGINFO();
                OS.MoveMemory(nMRGINFO, n2, NMRGINFO.sizeof);
                this.showMenu(nMRGINFO.x, nMRGINFO.y);
                this.gestureCompleted = true;
                return LRESULT.ONE;
            }
        }
        return super.wmNotifyChild(n, n2);
    }
}

