/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.GRADIENT_RECT;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.LOGPEN;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.TRIVERTEX;

public final class GC {
    public int handle;
    Drawable drawable;
    GCData data;

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int n) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData gCData = new GCData();
        gCData.style = GC.checkStyle(n);
        int n2 = drawable.internal_new_GC(gCData);
        Device device = gCData.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        gCData.device = device;
        this.init(drawable, gCData, n2);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    static int checkStyle(int n) {
        if ((n & 0x2000000) != 0) {
            n &= 0xFBFFFFFF;
        }
        return n & 0x6000000;
    }

    public void copyArea(Image image, int n, int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        Device device = this.data.device;
        int n3 = device.internal_new_GC(null);
        Rectangle rectangle = image.getBounds();
        int n4 = OS.CreateCompatibleDC(n3);
        int n5 = OS.SelectObject(n4, image.handle);
        OS.BitBlt(n4, 0, 0, rectangle.width, rectangle.height, this.handle, n, n2, 0xCC0020);
        OS.SelectObject(n4, n5);
        OS.DeleteDC(n4);
        device.internal_dispose_GC(n3, null);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((n7 = this.data.hwnd) == 0) {
            OS.BitBlt(this.handle, n5, n6, n3, n4, this.handle, n, n2, 0xCC0020);
        } else {
            RECT rECT = null;
            int n8 = OS.CreateRectRgn(0, 0, 0, 0);
            if (OS.GetClipRgn(this.handle, n8) == 1) {
                rECT = new RECT();
                OS.GetRgnBox(n8, rECT);
            }
            OS.DeleteObject(n8);
            RECT rECT2 = new RECT();
            OS.SetRect(rECT2, n, n2, n + n3, n2 + n4);
            int n9 = OS.ScrollWindowEx(n7, n5 - n, n6 - n2, rECT2, rECT, 0, null, 6);
            if (n9 == 0 && OS.IsWinCE) {
                boolean bl;
                OS.BitBlt(this.handle, n5, n6, n3, n4, this.handle, n, n2, 0xCC0020);
                int n10 = n5 - n;
                int n11 = n6 - n2;
                boolean bl2 = bl = n5 + n3 < n || n + n3 < n5 || n6 + n4 < n2 || n2 + n4 < n6;
                if (bl) {
                    OS.InvalidateRect(n7, rECT2, true);
                } else {
                    int n12;
                    if (n10 != 0) {
                        n12 = n5 - n10;
                        if (n10 < 0) {
                            n12 = n5 + n3;
                        }
                        OS.SetRect(rECT2, n12, n2, n12 + Math.abs(n10), n2 + n4);
                        OS.InvalidateRect(n7, rECT2, true);
                    }
                    if (n11 != 0) {
                        n12 = n6 - n11;
                        if (n11 < 0) {
                            n12 = n6 + n4;
                        }
                        OS.SetRect(rECT2, n, n12, n + n3, n12 + Math.abs(n11));
                        OS.InvalidateRect(n7, rECT2, true);
                    }
                }
            }
        }
    }

    int createDIB(int n, int n2) {
        int[] nArray;
        int n3;
        int n4 = 32;
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = 40;
        bITMAPINFOHEADER.biWidth = n;
        bITMAPINFOHEADER.biHeight = -n2;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)n4;
        bITMAPINFOHEADER.biCompression = OS.IsWinCE ? 3 : 0;
        byte[] byArray = new byte[40 + (OS.IsWinCE ? 12 : 0)];
        OS.MoveMemory(byArray, bITMAPINFOHEADER, 40);
        if (OS.IsWinCE) {
            int n5 = 65280;
            n3 = 0xFF0000;
            int n6 = -16777216;
            int n7 = 40;
            byArray[n7] = (byte)((n5 & 0xFF000000) >> 24);
            byArray[n7 + 1] = (byte)((n5 & 0xFF0000) >> 16);
            byArray[n7 + 2] = (byte)((n5 & 0xFF00) >> 8);
            byArray[n7 + 3] = (byte)((n5 & 0xFF) >> 0);
            byArray[n7 + 4] = (byte)((n3 & 0xFF000000) >> 24);
            byArray[n7 + 5] = (byte)((n3 & 0xFF0000) >> 16);
            byArray[n7 + 6] = (byte)((n3 & 0xFF00) >> 8);
            byArray[n7 + 7] = (byte)((n3 & 0xFF) >> 0);
            byArray[n7 + 8] = (byte)((n6 & 0xFF000000) >> 24);
            byArray[n7 + 9] = (byte)((n6 & 0xFF0000) >> 16);
            byArray[n7 + 10] = (byte)((n6 & 0xFF00) >> 8);
            byArray[n7 + 11] = (byte)((n6 & 0xFF) >> 0);
        }
        if ((n3 = OS.CreateDIBSection(0, byArray, 0, nArray = new int[1], 0, 0)) == 0) {
            SWT.error(2);
        }
        return n3;
    }

    public void dispose() {
        Image image;
        int n;
        if (this.handle == 0) {
            return;
        }
        if (this.data.device.isDisposed()) {
            return;
        }
        if (this.data.hPen != 0) {
            n = OS.GetStockObject(8);
            OS.SelectObject(this.handle, n);
            OS.DeleteObject(this.data.hPen);
            this.data.hPen = 0;
        }
        if (this.data.hBrush != 0) {
            n = OS.GetStockObject(5);
            OS.SelectObject(this.handle, n);
            OS.DeleteObject(this.data.hBrush);
            this.data.hBrush = 0;
        }
        if ((n = this.data.hNullBitmap) != 0) {
            OS.SelectObject(this.handle, n);
            this.data.hNullBitmap = 0;
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
        }
        Device device = this.data.device;
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle, this.data);
        }
        this.drawable = null;
        this.handle = 0;
        this.data.image = null;
        this.data.ps = null;
        if (device.tracking) {
            device.dispose_Object(this);
        }
        this.data.device = null;
        this.data = null;
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n3 == 0 || n4 == 0 || n6 == 0) {
            return;
        }
        if (OS.IsWinCE) {
            if (n6 < 0) {
                n5 += n6;
                n6 = -n6;
            }
            if (n6 > 360) {
                n6 = 360;
            }
            int[] nArray = new int[(n6 + 1) * 2];
            int n7 = 2 * n + n3;
            int n8 = 2 * n2 + n4;
            int n9 = 0;
            int n10 = 0;
            while (n10 <= n6) {
                nArray[n9++] = Compatibility.cos(n5 + n10, n3) + n7 >> 1;
                nArray[n9++] = n8 - Compatibility.sin(n5 + n10, n4) >> 1;
                ++n10;
            }
            OS.Polyline(this.handle, nArray, nArray.length / 2);
        } else {
            int n11;
            int n12;
            int n13;
            int n14;
            if (n6 >= 360 || n6 <= -360) {
                n13 = n14 = n + n3;
                n11 = n12 = n2 + n4 / 2;
            } else {
                boolean bl = n6 < 0;
                n6 += n5;
                if (bl) {
                    int n15 = n5;
                    n5 = n6;
                    n6 = n15;
                }
                n13 = Compatibility.cos(n5, n3) + n + n3 / 2;
                n11 = -1 * Compatibility.sin(n5, n4) + n2 + n4 / 2;
                n14 = Compatibility.cos(n6, n3) + n + n3 / 2;
                n12 = -1 * Compatibility.sin(n6, n4) + n2 + n4 / 2;
            }
            int n16 = OS.GetStockObject(5);
            int n17 = OS.SelectObject(this.handle, n16);
            OS.Arc(this.handle, n, n2, n + n3 + 1, n2 + n4 + 1, n13, n11, n14, n12);
            OS.SelectObject(this.handle, n17);
        }
    }

    public void drawFocus(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, n, n2, n + n3, n2 + n4);
        OS.DrawFocusRect(this.handle, rECT);
    }

    public void drawImage(Image image, int n, int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, n, n2, -1, -1, true);
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 == 0 || n4 == 0 || n7 == 0 || n8 == 0) {
            return;
        }
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n7 < 0 || n8 < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, false);
    }

    void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        switch (image.type) {
            case 0: {
                this.drawBitmap(image, n, n2, n3, n4, n5, n6, n7, n8, bl);
                break;
            }
            case 1: {
                this.drawIcon(image, n, n2, n3, n4, n5, n6, n7, n8, bl);
                break;
            }
            default: {
                SWT.error(42);
            }
        }
    }

    void drawIcon(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        boolean bl2;
        int n9 = OS.GetDeviceCaps(this.handle, 2);
        if (bl && n9 != 2) {
            OS.DrawIconEx(this.handle, n5, n6, image.handle, 0, 0, 0, 0, 3);
            return;
        }
        ICONINFO iCONINFO = new ICONINFO();
        if (OS.IsWinCE) {
            Image.GetIconInfo(image, iCONINFO);
        } else {
            OS.GetIconInfo(image.handle, iCONINFO);
        }
        int n10 = iCONINFO.hbmColor;
        if (n10 == 0) {
            n10 = iCONINFO.hbmMask;
        }
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(n10, 24, bITMAP);
        int n11 = bITMAP.bmWidth;
        int n12 = bITMAP.bmHeight;
        if (n10 == iCONINFO.hbmMask) {
            n12 /= 2;
        }
        if (bl) {
            n3 = n7 = n11;
            n4 = n8 = n12;
        }
        boolean bl3 = bl2 = n + n3 > n11 || n2 + n4 > n12;
        if (!bl2) {
            boolean bl4 = bl = n == 0 && n2 == 0 && n3 == n7 && n4 == n8 && n3 == n11 && n4 == n12;
            if (bl && n9 != 2) {
                OS.DrawIconEx(this.handle, n5, n6, image.handle, 0, 0, 0, 0, 3);
            } else {
                boolean bl5;
                Device device = this.data.device;
                int n13 = device.internal_new_GC(null);
                ICONINFO iCONINFO2 = new ICONINFO();
                iCONINFO2.fIcon = true;
                int n14 = OS.CreateCompatibleDC(n13);
                int n15 = OS.CreateCompatibleDC(n13);
                int n16 = n2;
                int n17 = iCONINFO.hbmColor;
                if (n17 == 0) {
                    n17 = iCONINFO.hbmMask;
                    n16 += n12;
                }
                int n18 = OS.SelectObject(n14, n17);
                iCONINFO2.hbmColor = OS.CreateCompatibleBitmap(n14, n7, n8);
                if (iCONINFO2.hbmColor == 0) {
                    SWT.error(2);
                }
                int n19 = OS.SelectObject(n15, iCONINFO2.hbmColor);
                boolean bl6 = bl5 = !bl && (n3 != n7 || n4 != n8);
                if (bl5) {
                    if (!OS.IsWinCE) {
                        OS.SetStretchBltMode(n15, 3);
                    }
                    OS.StretchBlt(n15, 0, 0, n7, n8, n14, n, n16, n3, n4, 0xCC0020);
                } else {
                    OS.BitBlt(n15, 0, 0, n7, n8, n14, n, n16, 0xCC0020);
                }
                OS.SelectObject(n14, iCONINFO.hbmMask);
                iCONINFO2.hbmMask = OS.CreateBitmap(n7, n8, 1, 1, null);
                if (iCONINFO2.hbmMask == 0) {
                    SWT.error(2);
                }
                OS.SelectObject(n15, iCONINFO2.hbmMask);
                if (bl5) {
                    OS.StretchBlt(n15, 0, 0, n7, n8, n14, n, n2, n3, n4, 0xCC0020);
                } else {
                    OS.BitBlt(n15, 0, 0, n7, n8, n14, n, n2, 0xCC0020);
                }
                if (n9 == 2) {
                    OS.SelectObject(n14, iCONINFO2.hbmColor);
                    OS.SelectObject(n15, iCONINFO.hbmMask);
                    this.drawBitmapTransparentByClipping(n14, n15, 0, 0, n7, n8, n5, n6, n7, n8, true, n7, n8);
                    OS.SelectObject(n14, n18);
                    OS.SelectObject(n15, n19);
                } else {
                    OS.SelectObject(n14, n18);
                    OS.SelectObject(n15, n19);
                    int n20 = OS.CreateIconIndirect(iCONINFO2);
                    if (n20 == 0) {
                        SWT.error(2);
                    }
                    OS.DrawIconEx(this.handle, n5, n6, n20, n7, n8, 0, 0, 3);
                    OS.DestroyIcon(n20);
                }
                OS.DeleteObject(iCONINFO2.hbmMask);
                OS.DeleteObject(iCONINFO2.hbmColor);
                OS.DeleteDC(n15);
                OS.DeleteDC(n14);
                device.internal_dispose_GC(n13, null);
            }
        }
        OS.DeleteObject(iCONINFO.hbmMask);
        if (iCONINFO.hbmColor != 0) {
            OS.DeleteObject(iCONINFO.hbmColor);
        }
        if (bl2) {
            SWT.error(5);
        }
    }

    void drawBitmap(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(image.handle, 24, bITMAP);
        int n9 = bITMAP.bmWidth;
        int n10 = bITMAP.bmHeight;
        if (bl) {
            n3 = n7 = n9;
            n4 = n8 = n10;
        } else {
            if (n + n3 > n9 || n2 + n4 > n10) {
                SWT.error(5);
            }
            bl = n == 0 && n2 == 0 && n3 == n7 && n7 == n9 && n4 == n8 && n8 == n10;
        }
        boolean bl2 = false;
        GC gC = image.memGC;
        if (gC != null && !gC.isDisposed()) {
            bl2 = true;
            GCData gCData = gC.data;
            if (gCData.hNullBitmap != 0) {
                OS.SelectObject(gC.handle, gCData.hNullBitmap);
                gCData.hNullBitmap = 0;
            }
        }
        if (image.alpha != -1 || image.alphaData != null) {
            this.drawBitmapAlpha(image, n, n2, n3, n4, n5, n6, n7, n8, bl, bITMAP, n9, n10);
        } else if (image.transparentPixel != -1) {
            this.drawBitmapTransparent(image, n, n2, n3, n4, n5, n6, n7, n8, bl, bITMAP, n9, n10);
        } else {
            this.drawBitmap(image, n, n2, n3, n4, n5, n6, n7, n8, bl, bITMAP, n9, n10);
        }
        if (bl2) {
            int n11;
            gC.data.hNullBitmap = n11 = OS.SelectObject(gC.handle, image.handle);
        }
    }

    void drawBitmapAlpha(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, BITMAP bITMAP, int n9, int n10) {
        int n11;
        int n12;
        int n13;
        int n14;
        boolean bl2;
        if (image.alpha == 0) {
            return;
        }
        if (image.alpha == 255) {
            this.drawBitmap(image, n, n2, n3, n4, n5, n6, n7, n8, bl, bITMAP, n9, n10);
            return;
        }
        Rectangle rectangle = this.getClipping();
        if ((rectangle = rectangle.intersection(new Rectangle(n5, n6, n7, n8))).isEmpty()) {
            return;
        }
        int n15 = n + (rectangle.x - n5) * n3 / n7;
        int n16 = n + (rectangle.x + rectangle.width - n5) * n3 / n7;
        int n17 = n2 + (rectangle.y - n6) * n4 / n8;
        int n18 = n2 + (rectangle.y + rectangle.height - n6) * n4 / n8;
        n5 = rectangle.x;
        n6 = rectangle.y;
        n7 = rectangle.width;
        n8 = rectangle.height;
        n = n15;
        n2 = n17;
        n3 = Math.max(1, n16 - n15);
        n4 = Math.max(1, n18 - n17);
        int n19 = OS.CreateCompatibleDC(this.handle);
        int n20 = OS.SelectObject(n19, image.handle);
        int n21 = OS.CreateCompatibleDC(this.handle);
        int n22 = this.createDIB(Math.max(n3, n7), Math.max(n4, n8));
        int n23 = OS.SelectObject(n21, n22);
        BITMAP bITMAP2 = new BITMAP();
        OS.GetObject(n22, 24, bITMAP2);
        int n24 = bITMAP2.bmWidthBytes * bITMAP2.bmHeight;
        OS.BitBlt(n21, 0, 0, n7, n8, this.handle, n5, n6, 0xCC0020);
        byte[] byArray = new byte[n24];
        OS.MoveMemory(byArray, bITMAP2.bmBits, n24);
        OS.BitBlt(n21, 0, 0, n3, n4, n19, n, n2, 0xCC0020);
        byte[] byArray2 = new byte[n24];
        OS.MoveMemory(byArray2, bITMAP2.bmBits, n24);
        int n25 = image.alpha;
        boolean bl3 = bl2 = image.alpha == -1;
        if (bl2) {
            n14 = n9 - n3;
            n13 = bITMAP2.bmWidthBytes - n3 * 4;
            n12 = n2 * n9 + n;
            n11 = 3;
            byte[] byArray3 = image.alphaData;
            int n26 = 0;
            while (n26 < n4) {
                int n27 = 0;
                while (n27 < n3) {
                    byArray2[n11] = byArray3[n12++];
                    n11 += 4;
                    ++n27;
                }
                n12 += n14;
                n11 += n13;
                ++n26;
            }
        }
        OS.MoveMemory(bITMAP2.bmBits, byArray2, n24);
        if (OS.IsWinCE && (n7 > n3 || n8 > n4) || !OS.IsWinNT && !OS.IsWinCE) {
            n14 = OS.CreateCompatibleDC(this.handle);
            n13 = this.createDIB(n7, n8);
            n12 = OS.SelectObject(n14, n13);
            if (!(bl || n3 == n7 && n4 == n8)) {
                if (!OS.IsWinCE) {
                    OS.SetStretchBltMode(n21, 3);
                }
                OS.StretchBlt(n14, 0, 0, n7, n8, n21, 0, 0, n3, n4, 0xCC0020);
            } else {
                OS.BitBlt(n14, 0, 0, n7, n8, n21, 0, 0, 0xCC0020);
            }
            OS.BitBlt(n21, 0, 0, n7, n8, n14, 0, 0, 0xCC0020);
            OS.SelectObject(n14, n12);
            OS.DeleteObject(n13);
            OS.DeleteDC(n14);
        } else if (!(bl || n3 == n7 && n4 == n8)) {
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(n21, 3);
            }
            OS.StretchBlt(n21, 0, 0, n7, n8, n21, 0, 0, n3, n4, 0xCC0020);
        } else {
            OS.BitBlt(n21, 0, 0, n7, n8, n21, 0, 0, 0xCC0020);
        }
        OS.MoveMemory(byArray2, bITMAP2.bmBits, n24);
        n14 = bITMAP2.bmWidthBytes - n7 * 4;
        n13 = 0;
        n12 = 0;
        while (n12 < n8) {
            n11 = 0;
            while (n11 < n7) {
                if (bl2) {
                    n25 = byArray2[n13 + 3] & 0xFF;
                }
                int n28 = n13;
                byArray[n28] = (byte)(byArray[n28] + ((byArray2[n13] & 0xFF) - (byArray[n13] & 0xFF)) * n25 / 255);
                int n29 = n13 + 1;
                byArray[n29] = (byte)(byArray[n29] + ((byArray2[n13 + 1] & 0xFF) - (byArray[n13 + 1] & 0xFF)) * n25 / 255);
                int n30 = n13 + 2;
                byArray[n30] = (byte)(byArray[n30] + ((byArray2[n13 + 2] & 0xFF) - (byArray[n13 + 2] & 0xFF)) * n25 / 255);
                n13 += 4;
                ++n11;
            }
            n13 += n14;
            ++n12;
        }
        OS.MoveMemory(bITMAP2.bmBits, byArray, n24);
        OS.BitBlt(this.handle, n5, n6, n7, n8, n21, 0, 0, 0xCC0020);
        OS.SelectObject(n21, n23);
        OS.DeleteDC(n21);
        OS.DeleteObject(n22);
        OS.SelectObject(n19, n20);
        OS.DeleteDC(n19);
    }

    void drawBitmapTransparentByClipping(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl, int n11, int n12) {
        int n13;
        int n14;
        int n15;
        int n16 = OS.CreateRectRgn(0, 0, 0, 0);
        int n17 = 0;
        while (n17 < n12) {
            n15 = 0;
            while (n15 < n11) {
                if (OS.GetPixel(n2, n15, n17) == 0) {
                    n14 = OS.CreateRectRgn(n15, n17, n15 + 1, n17 + 1);
                    OS.CombineRgn(n16, n16, n14, 2);
                    OS.DeleteObject(n14);
                }
                ++n15;
            }
            ++n17;
        }
        OS.OffsetRgn(n16, n7, n8);
        n17 = OS.CreateRectRgn(0, 0, 0, 0);
        n15 = OS.GetClipRgn(this.handle, n17);
        if (n15 == 1) {
            OS.CombineRgn(n16, n16, n17, 1);
        }
        OS.SelectClipRgn(this.handle, n16);
        n14 = 0;
        if (!OS.IsWinCE) {
            n14 = OS.GetROP2(this.handle);
        } else {
            n14 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, n14);
        }
        int n18 = n13 = n14 == 7 ? 0x660046 : 0xCC0020;
        if (!(bl || n5 == n9 && n6 == n10)) {
            int n19 = 0;
            if (!OS.IsWinCE) {
                n19 = OS.SetStretchBltMode(this.handle, 3);
            }
            OS.StretchBlt(this.handle, n7, n8, n9, n10, n, n3, n4, n5, n6, n13);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(this.handle, n19);
            }
        } else {
            OS.BitBlt(this.handle, n7, n8, n9, n10, n, n3, n4, n13);
        }
        OS.SelectClipRgn(this.handle, n15 == 1 ? n17 : 0);
        OS.DeleteObject(n17);
        OS.DeleteObject(n16);
    }

    void drawBitmapTransparent(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, BITMAP bITMAP, int n9, int n10) {
        int n11;
        int n12;
        Device device = this.data.device;
        int n13 = device.internal_new_GC(null);
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        boolean bl2 = bITMAP.bmBits != 0;
        int n17 = image.handle;
        int n18 = OS.CreateCompatibleDC(this.handle);
        int n19 = OS.SelectObject(n18, n17);
        byte[] byArray = null;
        if (bITMAP.bmBitsPixel <= 8) {
            if (bl2) {
                if (OS.IsWinCE) {
                    byte[] byArray2 = new byte[1];
                    OS.MoveMemory(byArray2, bITMAP.bmBits, 1);
                    n12 = byArray2[0];
                    int n20 = 255 << 8 - bITMAP.bmBitsPixel & 0xFF;
                    byArray2[0] = (byte)(image.transparentPixel << 8 - bITMAP.bmBitsPixel | byArray2[0] & ~n20);
                    OS.MoveMemory(bITMAP.bmBits, byArray2, 1);
                    n11 = OS.GetPixel(n18, 0, 0);
                    byArray2[0] = n12;
                    OS.MoveMemory(bITMAP.bmBits, byArray2, 1);
                    n14 = (n11 & 0xFF0000) >> 16;
                    n15 = (n11 & 0xFF00) >> 8;
                    n16 = n11 & 0xFF;
                } else {
                    int n21 = 1 << bITMAP.bmBitsPixel;
                    byte[] byArray3 = new byte[n21 * 4];
                    OS.GetDIBColorTable(n18, 0, n21, byArray3);
                    int n22 = image.transparentPixel * 4;
                    byte[] byArray4 = new byte[byArray3.length];
                    n14 = 255;
                    n15 = 255;
                    n16 = 255;
                    byArray4[n22] = (byte)n14;
                    byArray4[n22 + 1] = (byte)n15;
                    byArray4[n22 + 2] = (byte)n16;
                    OS.SetDIBColorTable(n18, 0, n21, byArray4);
                    byArray = byArray3;
                }
            } else {
                int n23 = 1 << bITMAP.bmBitsPixel;
                BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
                bITMAPINFOHEADER.biSize = 40;
                bITMAPINFOHEADER.biPlanes = bITMAP.bmPlanes;
                bITMAPINFOHEADER.biBitCount = bITMAP.bmBitsPixel;
                byte[] byArray5 = new byte[40 + n23 * 4];
                OS.MoveMemory(byArray5, bITMAPINFOHEADER, 40);
                if (OS.IsWinCE) {
                    SWT.error(20);
                }
                OS.GetDIBits(n18, image.handle, 0, 0, 0, byArray5, 0);
                n11 = 40 + 4 * image.transparentPixel;
                n16 = byArray5[n11 + 2] & 0xFF;
                n15 = byArray5[n11 + 1] & 0xFF;
                n14 = byArray5[n11] & 0xFF;
            }
        } else {
            int n24 = image.transparentPixel;
            switch (bITMAP.bmBitsPixel) {
                case 16: {
                    n14 = (n24 & 0x1F) << 3;
                    n15 = (n24 & 0x3E0) >> 2;
                    n16 = (n24 & 0x7C00) >> 7;
                    break;
                }
                case 24: {
                    n14 = (n24 & 0xFF0000) >> 16;
                    n15 = (n24 & 0xFF00) >> 8;
                    n16 = n24 & 0xFF;
                    break;
                }
                case 32: {
                    n14 = (n24 & 0xFF000000) >>> 24;
                    n15 = (n24 & 0xFF0000) >> 16;
                    n16 = (n24 & 0xFF00) >> 8;
                }
            }
        }
        if (OS.IsWinCE) {
            int n25 = n14 << 16 | n15 << 8 | n16;
            OS.TransparentImage(this.handle, n5, n6, n7, n8, n18, n, n2, n3, n4, n25);
        } else {
            int n26 = OS.CreateCompatibleDC(n13);
            n12 = OS.CreateBitmap(n9, n10, 1, 1, null);
            int n27 = OS.SelectObject(n26, n12);
            OS.SetBkColor(n18, n14 << 16 | n15 << 8 | n16);
            OS.BitBlt(n26, 0, 0, n9, n10, n18, 0, 0, 0xCC0020);
            if (byArray != null) {
                OS.SetDIBColorTable(n18, 0, 1 << bITMAP.bmBitsPixel, byArray);
            }
            if (OS.GetDeviceCaps(this.handle, 2) == 2) {
                this.drawBitmapTransparentByClipping(n18, n26, n, n2, n3, n4, n5, n6, n7, n8, bl, n9, n10);
            } else {
                n11 = OS.CreateCompatibleDC(n13);
                int n28 = OS.CreateCompatibleBitmap(n13, n7, n8);
                int n29 = OS.SelectObject(n11, n28);
                OS.BitBlt(n11, 0, 0, n7, n8, this.handle, n5, n6, 0xCC0020);
                if (!(bl || n3 == n7 && n4 == n8)) {
                    if (!OS.IsWinCE) {
                        OS.SetStretchBltMode(n11, 3);
                    }
                    OS.StretchBlt(n11, 0, 0, n7, n8, n18, n, n2, n3, n4, 0x660046);
                    OS.StretchBlt(n11, 0, 0, n7, n8, n26, n, n2, n3, n4, 8913094);
                    OS.StretchBlt(n11, 0, 0, n7, n8, n18, n, n2, n3, n4, 0x660046);
                } else {
                    OS.BitBlt(n11, 0, 0, n7, n8, n18, n, n2, 0x660046);
                    OS.BitBlt(n11, 0, 0, n7, n8, n26, n, n2, 8913094);
                    OS.BitBlt(n11, 0, 0, n7, n8, n18, n, n2, 0x660046);
                }
                OS.BitBlt(this.handle, n5, n6, n7, n8, n11, 0, 0, 0xCC0020);
                OS.SelectObject(n11, n29);
                OS.DeleteDC(n11);
                OS.DeleteObject(n28);
            }
            OS.SelectObject(n26, n27);
            OS.DeleteDC(n26);
            OS.DeleteObject(n12);
        }
        OS.SelectObject(n18, n19);
        if (n17 != image.handle) {
            OS.DeleteObject(n17);
        }
        OS.DeleteDC(n18);
        device.internal_dispose_GC(n13, null);
    }

    void drawBitmap(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, BITMAP bITMAP, int n9, int n10) {
        int n11;
        int n12 = OS.CreateCompatibleDC(this.handle);
        int n13 = OS.SelectObject(n12, image.handle);
        int n14 = 0;
        if (!OS.IsWinCE) {
            n14 = OS.GetROP2(this.handle);
        } else {
            n14 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, n14);
        }
        int n15 = n11 = n14 == 7 ? 0x660046 : 0xCC0020;
        if (!(bl || n3 == n7 && n4 == n8)) {
            int n16 = 0;
            if (!OS.IsWinCE) {
                n16 = OS.SetStretchBltMode(this.handle, 3);
            }
            OS.StretchBlt(this.handle, n5, n6, n7, n8, n12, n, n2, n3, n4, n11);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(this.handle, n16);
            }
        } else {
            OS.BitBlt(this.handle, n5, n6, n7, n8, n12, n, n2, n11);
        }
        OS.SelectObject(n12, n13);
        OS.DeleteDC(n12);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (OS.IsWinCE) {
            int[] nArray = new int[]{n, n2, n3, n4};
            OS.Polyline(this.handle, nArray, nArray.length / 2);
        } else {
            OS.MoveToEx(this.handle, n, n2, 0);
            OS.LineTo(this.handle, n3, n4);
        }
        OS.SetPixel(this.handle, n3, n4, OS.GetTextColor(this.handle));
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n5 = OS.GetStockObject(5);
        int n6 = OS.SelectObject(this.handle, n5);
        OS.Ellipse(this.handle, n, n2, n + n3 + 1, n2 + n4 + 1);
        OS.SelectObject(this.handle, n6);
    }

    public void drawPoint(int n, int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        OS.SetPixel(this.handle, n, n2, OS.GetTextColor(this.handle));
    }

    public void drawPolygon(int[] nArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        int n = OS.GetStockObject(5);
        int n2 = OS.SelectObject(this.handle, n);
        OS.Polygon(this.handle, nArray, nArray.length / 2);
        OS.SelectObject(this.handle, n2);
    }

    public void drawPolyline(int[] nArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        OS.Polyline(this.handle, nArray, nArray.length / 2);
        int n = nArray.length;
        if (n >= 2) {
            OS.SetPixel(this.handle, nArray[n - 2], nArray[n - 1], OS.GetTextColor(this.handle));
        }
    }

    public void drawRectangle(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n5 = OS.SelectObject(this.handle, OS.GetStockObject(5));
        OS.Rectangle(this.handle, n, n2, n + n3 + 1, n2 + n4 + 1);
        OS.SelectObject(this.handle, n5);
    }

    public void drawRectangle(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        this.drawRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawRoundRectangle(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (OS.IsWinCE) {
            if (n3 == 0 || n4 == 0) {
                return;
            }
            if (n5 == 0 || n6 == 0) {
                this.drawRectangle(n, n2, n3, n4);
                return;
            }
            if (n3 < 0) {
                n += n3;
                n3 = -n3;
            }
            if (n4 < 0) {
                n2 += n4;
                n4 = -n4;
            }
            if (n5 < 0) {
                n5 = -n5;
            }
            if (n6 < 0) {
                n6 = -n6;
            }
            if (n5 > n3) {
                n5 = n3;
            }
            if (n6 > n4) {
                n6 = n4;
            }
            if (n5 < n3) {
                this.drawLine(n + n5 / 2, n2, n + n3 - n5 / 2, n2);
                this.drawLine(n + n5 / 2, n2 + n4, n + n3 - n5 / 2, n2 + n4);
            }
            if (n6 < n4) {
                this.drawLine(n, n2 + n6 / 2, n, n2 + n4 - n6 / 2);
                this.drawLine(n + n3, n2 + n6 / 2, n + n3, n2 + n4 - n6 / 2);
            }
            if (n5 != 0 && n6 != 0) {
                this.drawArc(n, n2, n5, n6, 90, 90);
                this.drawArc(n + n3 - n5, n2, n5, n6, 0, 90);
                this.drawArc(n + n3 - n5, n2 + n4 - n6, n5, n6, 0, -90);
                this.drawArc(n, n2 + n4 - n6, n5, n6, 180, 90);
            }
        } else {
            int n7 = OS.GetStockObject(5);
            int n8 = OS.SelectObject(this.handle, n7);
            OS.RoundRect(this.handle, n, n2, n + n3 + 1, n2 + n4 + 1, n5, n6);
            OS.SelectObject(this.handle, n8);
        }
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, n, n2, false);
    }

    public void drawString(String string, int n, int n2, boolean bl) {
        int n3;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if ((n3 = string.length()) == 0) {
            return;
        }
        char[] cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        int n4 = 0;
        if (OS.IsWinCE) {
            n4 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, n4);
        } else {
            n4 = OS.GetROP2(this.handle);
        }
        int n5 = OS.SetBkMode(this.handle, bl ? 1 : 2);
        if (n4 != 7) {
            OS.ExtTextOutW(this.handle, n, n2, 0, null, cArray, n3, null);
        } else {
            int n6 = OS.GetTextColor(this.handle);
            if (bl) {
                SIZE sIZE = new SIZE();
                OS.GetTextExtentPoint32W(this.handle, cArray, n3, sIZE);
                int n7 = sIZE.cx;
                int n8 = sIZE.cy;
                int n9 = OS.CreateCompatibleBitmap(this.handle, n7, n8);
                if (n9 == 0) {
                    SWT.error(2);
                }
                int n10 = OS.CreateCompatibleDC(this.handle);
                int n11 = OS.SelectObject(n10, n9);
                OS.PatBlt(n10, 0, 0, n7, n8, 66);
                OS.SetBkMode(n10, 1);
                OS.SetTextColor(n10, n6);
                OS.SelectObject(n10, OS.GetCurrentObject(this.handle, 6));
                OS.ExtTextOutW(n10, 0, 0, 0, null, cArray, n3, null);
                OS.BitBlt(this.handle, n, n2, n7, n8, n10, 0, 0, 0x660046);
                OS.SelectObject(n10, n11);
                OS.DeleteDC(n10);
                OS.DeleteObject(n9);
            } else {
                int n12 = OS.GetBkColor(this.handle);
                OS.SetTextColor(this.handle, n6 ^ n12);
                OS.ExtTextOutW(this.handle, n, n2, 0, null, cArray, n3, null);
                OS.SetTextColor(this.handle, n6);
            }
        }
        OS.SetBkMode(this.handle, n5);
    }

    public void drawText(String string, int n, int n2) {
        this.drawText(string, n, n2, 6);
    }

    public void drawText(String string, int n, int n2, boolean bl) {
        int n3 = 6;
        if (bl) {
            n3 |= 1;
        }
        this.drawText(string, n, n2, n3);
    }

    public void drawText(String string, int n, int n2, int n3) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, false);
        int n4 = tCHAR.length();
        if (n4 == 0) {
            return;
        }
        RECT rECT = new RECT();
        int n5 = OS.IsWin95 ? Short.MAX_VALUE : 0x6FFFFFF;
        OS.SetRect(rECT, n, n2, n5, n5);
        int n6 = 0;
        if ((n3 & 2) == 0) {
            n6 |= 0x20;
        }
        if ((n3 & 4) != 0) {
            n6 |= 0x40;
        }
        if ((n3 & 8) == 0) {
            n6 |= 0x800;
        }
        int n7 = 0;
        if (OS.IsWinCE) {
            n7 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, n7);
        } else {
            n7 = OS.GetROP2(this.handle);
        }
        int n8 = OS.SetBkMode(this.handle, (n3 & 1) != 0 ? 1 : 2);
        if (n7 != 7) {
            OS.DrawText(this.handle, tCHAR, n4, rECT, n6);
        } else {
            int n9 = OS.GetTextColor(this.handle);
            if ((n3 & 1) != 0) {
                OS.DrawText(this.handle, tCHAR, tCHAR.length(), rECT, n6 | 0x400);
                int n10 = rECT.right - rECT.left;
                int n11 = rECT.bottom - rECT.top;
                int n12 = OS.CreateCompatibleBitmap(this.handle, n10, n11);
                if (n12 == 0) {
                    SWT.error(2);
                }
                int n13 = OS.CreateCompatibleDC(this.handle);
                int n14 = OS.SelectObject(n13, n12);
                OS.PatBlt(n13, 0, 0, n10, n11, 66);
                OS.SetBkMode(n13, 1);
                OS.SetTextColor(n13, n9);
                OS.SelectObject(n13, OS.GetCurrentObject(this.handle, 6));
                OS.SetRect(rECT, 0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
                OS.DrawText(n13, tCHAR, n4, rECT, n6);
                OS.BitBlt(this.handle, n, n2, n10, n11, n13, 0, 0, 0x660046);
                OS.SelectObject(n13, n14);
                OS.DeleteDC(n13);
                OS.DeleteObject(n12);
            } else {
                int n15 = OS.GetBkColor(this.handle);
                OS.SetTextColor(this.handle, n9 ^ n15);
                OS.DrawText(this.handle, tCHAR, n4, rECT, n6);
                OS.SetTextColor(this.handle, n9);
            }
        }
        OS.SetBkMode(this.handle, n8);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof GC && this.handle == ((GC)object).handle;
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n3 == 0 || n4 == 0 || n6 == 0) {
            return;
        }
        if (OS.IsWinCE) {
            if (n6 < 0) {
                n5 += n6;
                n6 = -n6;
            }
            boolean bl = true;
            if (n6 >= 360) {
                n6 = 360;
                bl = false;
            }
            int[] nArray = new int[(n6 + 1) * 2 + (bl ? 4 : 0)];
            int n7 = 2 * n + n3;
            int n8 = 2 * n2 + n4;
            int n9 = bl ? 2 : 0;
            int n10 = 0;
            while (n10 <= n6) {
                nArray[n9++] = Compatibility.cos(n5 + n10, n3) + n7 >> 1;
                nArray[n9++] = n8 - Compatibility.sin(n5 + n10, n4) >> 1;
                ++n10;
            }
            if (bl) {
                int n11 = n7 >> 1;
                nArray[nArray.length - 2] = n11;
                nArray[0] = n11;
                int n12 = n8 >> 1;
                nArray[nArray.length - 1] = n12;
                nArray[1] = n12;
            }
            n10 = OS.GetStockObject(8);
            int n13 = OS.SelectObject(this.handle, n10);
            OS.Polygon(this.handle, nArray, nArray.length / 2);
            OS.SelectObject(this.handle, n13);
        } else {
            int n14;
            int n15;
            int n16;
            int n17;
            if (n6 >= 360 || n6 <= -360) {
                n16 = n17 = n + n3;
                n14 = n15 = n2 + n4 / 2;
            } else {
                boolean bl = n6 < 0;
                n6 += n5;
                if (bl) {
                    int n18 = n5;
                    n5 = n6;
                    n6 = n18;
                }
                n16 = Compatibility.cos(n5, n3) + n + n3 / 2;
                n14 = -1 * Compatibility.sin(n5, n4) + n2 + n4 / 2;
                n17 = Compatibility.cos(n6, n3) + n + n3 / 2;
                n15 = -1 * Compatibility.sin(n6, n4) + n2 + n4 / 2;
            }
            int n19 = OS.GetStockObject(8);
            int n20 = OS.SelectObject(this.handle, n19);
            OS.Pie(this.handle, n, n2, n + n3 + 1, n2 + n4 + 1, n16, n14, n17, n15);
            OS.SelectObject(this.handle, n20);
        }
    }

    public void fillGradientRectangle(int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 == 0 || n4 == 0) {
            return;
        }
        int n9 = OS.GetTextColor(this.handle);
        if (n9 == -1) {
            n9 = OS.GetSysColor(OS.COLOR_WINDOWTEXT);
        }
        if ((n8 = OS.GetBkColor(this.handle)) == -1) {
            n8 = OS.GetSysColor(OS.COLOR_WINDOW);
        }
        boolean bl2 = false;
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
            if (!bl) {
                bl2 = true;
            }
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
            if (bl) {
                bl2 = true;
            }
        }
        if (bl2) {
            n7 = n9;
            n9 = n8;
            n8 = n7;
        }
        n7 = 0;
        if (OS.IsWinCE) {
            n7 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, n7);
        } else {
            n7 = OS.GetROP2(this.handle);
        }
        RGB rGB = new RGB(n9 & 0xFF, n9 >>> 8 & 0xFF, n9 >>> 16 & 0xFF);
        RGB rGB2 = new RGB(n8 & 0xFF, n8 >>> 8 & 0xFF, n8 >>> 16 & 0xFF);
        if (rGB.red == rGB2.red && rGB.green == rGB2.green && rGB.blue == rGB2.blue) {
            int n10 = n7 == 7 ? 5898313 : 15728673;
            OS.PatBlt(this.handle, n, n2, n3, n4, n10);
            return;
        }
        if (!OS.IsWinCE && n7 != 7 && OS.GetDeviceCaps(this.handle, 2) != 2) {
            n6 = OS.GetProcessHeap();
            n5 = OS.HeapAlloc(n6, 8, 40);
            int n11 = n5 + 8;
            GRADIENT_RECT gRADIENT_RECT = new GRADIENT_RECT();
            gRADIENT_RECT.UpperLeft = 0;
            gRADIENT_RECT.LowerRight = 1;
            OS.MoveMemory(n5, gRADIENT_RECT, 8);
            TRIVERTEX tRIVERTEX = new TRIVERTEX();
            tRIVERTEX.x = n;
            tRIVERTEX.y = n2;
            tRIVERTEX.Red = (short)(rGB.red << 8 | rGB.red);
            tRIVERTEX.Green = (short)(rGB.green << 8 | rGB.green);
            tRIVERTEX.Blue = (short)(rGB.blue << 8 | rGB.blue);
            tRIVERTEX.Alpha = (short)-1;
            OS.MoveMemory(n11, tRIVERTEX, 16);
            tRIVERTEX.x = n + n3;
            tRIVERTEX.y = n2 + n4;
            tRIVERTEX.Red = (short)(rGB2.red << 8 | rGB2.red);
            tRIVERTEX.Green = (short)(rGB2.green << 8 | rGB2.green);
            tRIVERTEX.Blue = (short)(rGB2.blue << 8 | rGB2.blue);
            tRIVERTEX.Alpha = (short)-1;
            OS.MoveMemory(n11 + 16, tRIVERTEX, 16);
            boolean bl3 = OS.GradientFill(this.handle, n11, 2, n5, 1, bl ? 1 : 0);
            OS.HeapFree(n6, 0, n5);
            if (bl3) {
                return;
            }
        }
        n5 = (n6 = OS.GetDeviceCaps(this.handle, 12)) >= 24 ? 8 : (n6 >= 15 ? 5 : 0);
        ImageData.fillGradientRectangle(this, this.data.device, n, n2, n3, n4, bl, rGB, rGB2, n5, n5, n5);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n5 = OS.GetStockObject(8);
        int n6 = OS.SelectObject(this.handle, n5);
        OS.Ellipse(this.handle, n, n2, n + n3 + 1, n2 + n4 + 1);
        OS.SelectObject(this.handle, n6);
    }

    public void fillPolygon(int[] nArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        int n = OS.GetStockObject(8);
        int n2 = OS.SelectObject(this.handle, n);
        OS.Polygon(this.handle, nArray, nArray.length / 2);
        OS.SelectObject(this.handle, n2);
    }

    public void fillRectangle(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n5 = 0;
        if (OS.IsWinCE) {
            n5 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, n5);
        } else {
            n5 = OS.GetROP2(this.handle);
        }
        int n6 = n5 == 7 ? 5898313 : 15728673;
        OS.PatBlt(this.handle, n, n2, n3, n4, n6);
    }

    public void fillRectangle(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        this.fillRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void fillRoundRectangle(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n7 = OS.GetStockObject(8);
        int n8 = OS.SelectObject(this.handle, n7);
        OS.RoundRect(this.handle, n, n2, n + n3 + 1, n2 + n4 + 1, n5, n6);
        OS.SelectObject(this.handle, n8);
    }

    public int getAdvanceWidth(char n) {
        Object object;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (OS.IsWinCE) {
            SIZE sIZE = new SIZE();
            OS.GetTextExtentPoint32W(this.handle, new char[]{n}, 1, sIZE);
            return sIZE.cx;
        }
        int n2 = n;
        if (n > 127) {
            object = new TCHAR(this.getCodePage(), (char)n, false);
            n2 = ((TCHAR)object).tcharAt(0);
        }
        object = new int[1];
        OS.GetCharWidth(this.handle, n2, n2, (int[])object);
        return (int)object[0];
    }

    public Color getBackground() {
        int n;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((n = OS.GetBkColor(this.handle)) == -1) {
            n = OS.GetSysColor(OS.COLOR_WINDOW);
        }
        return Color.win32_new(this.data.device, n);
    }

    public int getCharWidth(char n) {
        Object object;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (!OS.IsWinCE) {
            int n2 = n;
            if (n > 127) {
                object = new TCHAR(this.getCodePage(), (char)n, false);
                n2 = object.tcharAt(0);
            }
            if (OS.GetCharABCWidths(this.handle, n2, n2, object = new int[3])) {
                return object[1];
            }
        }
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(this.handle, tEXTMETRIC);
        object = new SIZE();
        OS.GetTextExtentPoint32W(this.handle, new char[]{n}, 1, (SIZE)object);
        return object.cx - tEXTMETRIC.tmOverhang;
    }

    public Rectangle getClipping() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        RECT rECT = new RECT();
        OS.GetClipBox(this.handle, rECT);
        return new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
    }

    public void getClipping(Region region) {
        int n;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if ((n = OS.GetClipRgn(this.handle, region.handle)) != 1) {
            RECT rECT = new RECT();
            OS.GetClipBox(this.handle, rECT);
            OS.SetRectRgn(region.handle, rECT.left, rECT.top, rECT.right, rECT.bottom);
        }
        if (!OS.IsWinCE) {
            int n2;
            int n3 = 0;
            if ((OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) >= 262154) {
                n3 = OS.GetLayout(this.handle);
            }
            if ((n2 = this.data.hwnd) != 0 && this.data.ps != null && (n3 & 1) == 0) {
                int n4 = OS.CreateRectRgn(0, 0, 0, 0);
                if (OS.GetRandomRgn(this.handle, n4, 4) == 1) {
                    if (OS.IsWinNT) {
                        POINT pOINT = new POINT();
                        OS.MapWindowPoints(0, n2, pOINT, 1);
                        OS.OffsetRgn(n4, pOINT.x, pOINT.y);
                    }
                    OS.CombineRgn(region.handle, n4, region.handle, 1);
                }
                OS.DeleteObject(n4);
            }
        }
    }

    int getCodePage() {
        if (OS.IsUnicode) {
            return 0;
        }
        int[] nArray = new int[8];
        int n = OS.GetTextCharset(this.handle);
        OS.TranslateCharsetInfo(n, nArray, 1);
        return nArray[1];
    }

    public Font getFont() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n = OS.GetCurrentObject(this.handle, 6);
        return Font.win32_new(this.data.device, n);
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(this.handle, tEXTMETRIC);
        return FontMetrics.win32_new(tEXTMETRIC);
    }

    public Color getForeground() {
        int n;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((n = OS.GetTextColor(this.handle)) == -1) {
            n = OS.GetSysColor(OS.COLOR_WINDOWTEXT);
        }
        return Color.win32_new(this.data.device, n);
    }

    public int getLineStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n = OS.GetCurrentObject(this.handle, 1);
        LOGPEN lOGPEN = new LOGPEN();
        OS.GetObject(n, 16, lOGPEN);
        switch (lOGPEN.lopnStyle) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
        }
        return 1;
    }

    public int getLineWidth() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n = OS.GetCurrentObject(this.handle, 1);
        LOGPEN lOGPEN = new LOGPEN();
        OS.GetObject(n, 16, lOGPEN);
        return lOGPEN.x;
    }

    public int getStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public boolean getXORMode() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n = 0;
        if (OS.IsWinCE) {
            n = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, n);
        } else {
            n = OS.GetROP2(this.handle);
        }
        return n == 7;
    }

    void init(Drawable drawable, GCData gCData, int n) {
        int n2;
        Image image;
        int n3;
        int n4;
        int n5;
        int n6 = gCData.foreground;
        if (n6 != -1 && OS.GetTextColor(n) != n6) {
            OS.SetTextColor(n, n6);
            n5 = OS.CreatePen(0, 0, n6);
            OS.SelectObject(n, n5);
            if (gCData.hPen != 0) {
                OS.DeleteObject(gCData.hPen);
            }
            gCData.hPen = n5;
        }
        if ((n5 = gCData.background) != -1 && OS.GetBkColor(n) != n5) {
            OS.SetBkColor(n, n5);
            n4 = OS.CreateSolidBrush(n5);
            OS.SelectObject(n, n4);
            if (gCData.hBrush != 0) {
                OS.DeleteObject(gCData.hBrush);
            }
            gCData.hBrush = n4;
        }
        if ((n4 = gCData.hFont) != 0) {
            OS.SelectObject(n, n4);
        }
        if ((n3 = gCData.device.hPalette) != 0) {
            OS.SelectPalette(n, n3, true);
            OS.RealizePalette(n);
        }
        if ((image = gCData.image) != null) {
            gCData.hNullBitmap = OS.SelectObject(n, image.handle);
            image.memGC = this;
        }
        if ((n2 = gCData.layout) != -1 && !OS.IsWinCE && (OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) >= 262154) {
            int n7 = OS.GetLayout(n);
            if ((n7 & 1) != (n2 & 1)) {
                OS.SetLayout(n, (n7 &= 0xFFFFFFFE) | n2);
            }
            if ((gCData.style & 0x4000000) != 0) {
                gCData.style |= 0x8000000;
            }
        }
        this.drawable = drawable;
        this.data = gCData;
        this.handle = n;
    }

    public int hashCode() {
        return this.handle;
    }

    public boolean isClipped() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.hwnd != 0 && this.data.ps != null) {
            return true;
        }
        int n = OS.CreateRectRgn(0, 0, 0, 0);
        int n2 = OS.GetClipRgn(this.handle, n);
        OS.DeleteObject(n);
        return n2 > 0;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void setBackground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (OS.GetBkColor(this.handle) == color.handle) {
            return;
        }
        this.data.background = color.handle;
        OS.SetBkColor(this.handle, color.handle);
        int n = OS.CreateSolidBrush(color.handle);
        OS.SelectObject(this.handle, n);
        if (this.data.hBrush != 0) {
            OS.DeleteObject(this.data.hBrush);
        }
        this.data.hBrush = n;
    }

    public void setClipping(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n5 = OS.CreateRectRgn(n, n2, n + n3, n2 + n4);
        OS.SelectClipRgn(this.handle, n5);
        OS.DeleteObject(n5);
    }

    public void setClipping(Rectangle rectangle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rectangle == null) {
            OS.SelectClipRgn(this.handle, 0);
        } else {
            this.setClipping(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n = 0;
        if (region != null) {
            n = region.handle;
        }
        OS.SelectClipRgn(this.handle, n);
    }

    public void setFont(Font font) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (font == null) {
            OS.SelectObject(this.handle, this.data.device.systemFont);
        } else {
            if (font.isDisposed()) {
                SWT.error(5);
            }
            OS.SelectObject(this.handle, font.handle);
        }
    }

    public void setForeground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (OS.GetTextColor(this.handle) == color.handle) {
            return;
        }
        this.data.foreground = color.handle;
        int n = OS.GetCurrentObject(this.handle, 1);
        LOGPEN lOGPEN = new LOGPEN();
        OS.GetObject(n, 16, lOGPEN);
        OS.SetTextColor(this.handle, color.handle);
        int n2 = OS.CreatePen(lOGPEN.lopnStyle, lOGPEN.x, color.handle);
        OS.SelectObject(this.handle, n2);
        if (this.data.hPen != 0) {
            OS.DeleteObject(this.data.hPen);
        }
        this.data.hPen = n2;
    }

    public void setLineStyle(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n2 = -1;
        switch (n) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 4;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        int n3 = OS.GetCurrentObject(this.handle, 1);
        LOGPEN lOGPEN = new LOGPEN();
        OS.GetObject(n3, 16, lOGPEN);
        if (lOGPEN.lopnStyle == n2) {
            return;
        }
        OS.SetBkMode(this.handle, n2 == 0 ? 2 : 1);
        int n4 = OS.CreatePen(n2, lOGPEN.x, lOGPEN.lopnColor);
        OS.SelectObject(this.handle, n4);
        if (this.data.hPen != 0) {
            OS.DeleteObject(this.data.hPen);
        }
        this.data.hPen = n4;
    }

    public void setLineWidth(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n2 = OS.GetCurrentObject(this.handle, 1);
        LOGPEN lOGPEN = new LOGPEN();
        OS.GetObject(n2, 16, lOGPEN);
        if (lOGPEN.x == n) {
            return;
        }
        int n3 = OS.CreatePen(lOGPEN.lopnStyle, n, lOGPEN.lopnColor);
        OS.SelectObject(this.handle, n3);
        if (this.data.hPen != 0) {
            OS.DeleteObject(this.data.hPen);
        }
        this.data.hPen = n3;
    }

    public void setXORMode(boolean bl) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        OS.SetROP2(this.handle, bl ? 7 : 13);
    }

    public Point stringExtent(String string) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        SIZE sIZE = new SIZE();
        int n = string.length();
        if (n == 0) {
            OS.GetTextExtentPoint32W(this.handle, new char[]{' '}, 1, sIZE);
            return new Point(0, sIZE.cy);
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        OS.GetTextExtentPoint32W(this.handle, cArray, n, sIZE);
        return new Point(sIZE.cx, sIZE.cy);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            SIZE sIZE = new SIZE();
            OS.GetTextExtentPoint32W(this.handle, new char[]{' '}, 1, sIZE);
            return new Point(0, sIZE.cy);
        }
        RECT rECT = new RECT();
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, false);
        int n2 = 1024;
        if ((n & 2) == 0) {
            n2 |= 0x20;
        }
        if ((n & 4) != 0) {
            n2 |= 0x40;
        }
        if ((n & 8) == 0) {
            n2 |= 0x800;
        }
        OS.DrawText(this.handle, tCHAR, tCHAR.length(), rECT, n2);
        return new Point(rECT.right, rECT.bottom);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }

    public static GC win32_new(Drawable drawable, GCData gCData) {
        GC gC = new GC();
        int n = drawable.internal_new_GC(gCData);
        gC.init(drawable, gCData, n);
        return gC;
    }

    public static GC win32_new(int n, GCData gCData) {
        GC gC = new GC();
        gC.init(null, gCData, n);
        return gC;
    }
}

