/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.btree.BTreeRowPosition;
import org.apache.derby.impl.store.access.btree.BTreeScan;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.LeafControlRow;

public class BTreeMaxScan
extends BTreeScan {
    private boolean fetchMaxRowFromBeginning(BTreeRowPosition bTreeRowPosition, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        boolean bl = false;
        RecordHandle recordHandle = null;
        Object[] objectArray = new DataValueDescriptor[]{dataValueDescriptorArray[0].getClone()};
        FetchDescriptor fetchDescriptor = RowUtil.getFetchDescriptorConstant(1);
        this.reopenScan(null, 0, null, null, 0);
        this.positionAtStartForForwardScan(bTreeRowPosition);
        boolean bl2 = true;
        while (bTreeRowPosition.current_leaf != null && bl2) {
            while (bTreeRowPosition.current_slot + 1 < bTreeRowPosition.current_leaf.page.recordCount()) {
                if (bTreeRowPosition.current_rh != null) {
                    this.getLockingPolicy().unlockScanRecordAfterRead(bTreeRowPosition, this.init_forUpdate);
                    bTreeRowPosition.current_rh = null;
                }
                ++bTreeRowPosition.current_slot;
                ++this.stat_numrows_visited;
                RecordHandle recordHandle2 = bTreeRowPosition.current_leaf.page.fetchFromSlot(null, bTreeRowPosition.current_slot, objectArray, null, true);
                boolean bl3 = !this.getLockingPolicy().lockScanRow(this, this.getConglomerate(), bTreeRowPosition, false, this.init_lock_fetch_desc, bTreeRowPosition.current_lock_template, bTreeRowPosition.current_lock_row_loc, false, this.init_forUpdate, this.lock_operation);
                bTreeRowPosition.current_rh = recordHandle2;
                if (!bl3 || !this.reposition(bTreeRowPosition, false)) {
                    // empty if block
                }
                if (bTreeRowPosition.current_leaf.page.isDeletedAtSlot(bTreeRowPosition.current_slot)) {
                    ++this.stat_numdeleted_rows_visited;
                    if (!objectArray[0].isNull()) continue;
                    bl2 = false;
                    break;
                }
                if (objectArray[0].isNull()) {
                    bl2 = false;
                    break;
                }
                bTreeRowPosition.current_leaf.page.fetchFromSlot(bTreeRowPosition.current_rh, bTreeRowPosition.current_slot, dataValueDescriptorArray, this.init_fetchDesc, true);
                ++this.stat_numrows_qualified;
                recordHandle = bTreeRowPosition.current_rh;
            }
            this.positionAtNextPage(bTreeRowPosition);
            ++this.stat_numpages_visited;
        }
        this.positionAtDoneScan(bTreeRowPosition);
        --this.stat_numpages_visited;
        return recordHandle != null;
    }

    protected int fetchRows(BTreeRowPosition bTreeRowPosition, DataValueDescriptor[][] dataValueDescriptorArray, RowLocation[] rowLocationArray, BackingStoreHashtable backingStoreHashtable, long l, int[] nArray) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    protected void positionAtStartPosition(BTreeRowPosition bTreeRowPosition) throws StandardException {
        while (true) {
            ControlRow controlRow = ControlRow.Get(this, 1L);
            this.stat_numpages_visited += controlRow.getLevel() + 1;
            if (this.init_startKeyValue != null) {
                throw StandardException.newException("XSCB3.S");
            }
            bTreeRowPosition.current_leaf = (LeafControlRow)controlRow.searchRight(this);
            bTreeRowPosition.current_slot = bTreeRowPosition.current_leaf.page.recordCount();
            boolean bl = false;
            --bTreeRowPosition.current_slot;
            boolean bl2 = !this.getLockingPolicy().lockScanRow(this, this.getConglomerate(), bTreeRowPosition, true, this.init_lock_fetch_desc, bTreeRowPosition.current_lock_template, bTreeRowPosition.current_lock_row_loc, false, this.init_forUpdate, this.lock_operation);
            ++bTreeRowPosition.current_slot;
            if (!bl2) break;
            bTreeRowPosition.current_leaf = null;
        }
        this.scan_state = 2;
        bTreeRowPosition.current_scan_pageno = bTreeRowPosition.current_leaf.page.getPageNumber();
    }

    public boolean fetchMax(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        BTreeRowPosition bTreeRowPosition = this.scan_position;
        int n = 0;
        if (this.scan_state == 2) {
            if (!this.reposition(this.scan_position, true)) {
                // empty if block
            }
        } else if (this.scan_state == 1) {
            this.positionAtStartPosition(this.scan_position);
        } else {
            return false;
        }
        boolean bl = false;
        if (bTreeRowPosition.current_slot - 1 > 0) {
            --bTreeRowPosition.current_slot;
            while (bTreeRowPosition.current_slot > 0) {
                ++this.stat_numrows_visited;
                RecordHandle recordHandle = bTreeRowPosition.current_leaf.page.fetchFromSlot(null, bTreeRowPosition.current_slot, dataValueDescriptorArray, this.init_fetchDesc, true);
                boolean bl2 = !this.getLockingPolicy().lockScanRow(this, this.getConglomerate(), bTreeRowPosition, false, this.init_lock_fetch_desc, bTreeRowPosition.current_lock_template, bTreeRowPosition.current_lock_row_loc, false, this.init_forUpdate, this.lock_operation);
                bTreeRowPosition.current_rh = recordHandle;
                if (bl2) {
                    bTreeRowPosition.current_leaf = null;
                    break;
                }
                if (bTreeRowPosition.current_leaf.page.isDeletedAtSlot(bTreeRowPosition.current_slot)) {
                    ++this.stat_numdeleted_rows_visited;
                    bTreeRowPosition.current_rh_qualified = false;
                } else {
                    bTreeRowPosition.current_rh_qualified = !dataValueDescriptorArray[0].isNull();
                }
                if (bTreeRowPosition.current_rh_qualified) {
                    ++n;
                    ++this.stat_numrows_qualified;
                    bTreeRowPosition.current_slot = -1;
                    bl = true;
                    break;
                }
                --bTreeRowPosition.current_slot;
            }
        }
        if (bTreeRowPosition.current_leaf != null) {
            bTreeRowPosition.current_leaf.release();
            bTreeRowPosition.current_leaf = null;
        }
        this.positionAtDoneScan(this.scan_position);
        if (!bl) {
            bl = this.fetchMaxRowFromBeginning(this.scan_position, dataValueDescriptorArray);
        }
        return bl;
    }
}

