/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.skin;

import java.awt.Color;

import org.jvnet.substance.api.*;
import org.jvnet.substance.colorscheme.*;
import org.jvnet.substance.painter.border.ClassicBorderPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.MatteDecorationPainter;
import org.jvnet.substance.painter.gradient.MatteGradientPainter;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.shaper.StandardButtonShaper;

/**
 * <code>Mist Aqua</code> skin. This class is experimental.
 * 
 * @author Kirill Grouchnikov
 * @since version 4.0
 */
public class MistAquaSkin extends SubstanceSkin {
	/**
	 * Display name for <code>this</code> skin.
	 */
	public static String NAME = "Mist Aqua";

	/**
	 * Color scheme for active visual state.
	 * 
	 * @author Kirill Grouchnikov
	 */
	protected static class ActiveTitleScheme extends BaseLightColorScheme {
		/**
		 * The main ultra-light color.
		 */
		private static final Color mainUltraLightColor = new Color(197, 197,
				197);

		/**
		 * The main extra-light color.
		 */
		private static final Color mainExtraLightColor = new Color(185, 185,
				185);

		/**
		 * The main light color.
		 */
		private static final Color mainLightColor = new Color(170, 170, 170);

		/**
		 * The main medium color.
		 */
		private static final Color mainMidColor = new Color(152, 152, 152);

		/**
		 * The main dark color.
		 */
		private static final Color mainDarkColor = new Color(152, 152, 152);

		/**
		 * The main ultra-dark color.
		 */
		private static final Color mainUltraDarkColor = new Color(152, 152, 152);

		/**
		 * The foreground color.
		 */
		private static final Color foregroundColor = Color.decode("#000000");

		/**
		 * Creates an active title scheme for this skin.
		 */
		public ActiveTitleScheme() {
			super("Mist Aqua Active Title");
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getForegroundColor()
		 */
		public Color getForegroundColor() {
			return ActiveTitleScheme.foregroundColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getUltraLightColor()
		 */
		public Color getUltraLightColor() {
			return ActiveTitleScheme.mainUltraLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getExtraLightColor()
		 */
		public Color getExtraLightColor() {
			return ActiveTitleScheme.mainExtraLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getLightColor()
		 */
		public Color getLightColor() {
			return ActiveTitleScheme.mainLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getMidColor()
		 */
		public Color getMidColor() {
			return ActiveTitleScheme.mainMidColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getDarkColor()
		 */
		public Color getDarkColor() {
			return ActiveTitleScheme.mainDarkColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getUltraDarkColor()
		 */
		public Color getUltraDarkColor() {
			return ActiveTitleScheme.mainUltraDarkColor;
		}
	}

	/**
	 * Creates a new <code>Silver Aqua</code> skin.
	 */
	public MistAquaSkin() {
		SubstanceColorScheme activeScheme = new AquaColorScheme();
		SubstanceColorScheme defaultScheme = new MetallicColorScheme().shade(
				0.05).named("Mist Aqua Default");
		SubstanceColorScheme disabledScheme = new LightGrayColorScheme().tone(
				0.2).named("Mist Aqua Disabled");

		SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(
				activeScheme, defaultScheme, disabledScheme);
		this.registerDecorationAreaSchemeBundle(defaultSchemeBundle,
				DecorationAreaType.NONE);

		this.registerDecorationAreaSchemeBundle(new SubstanceColorSchemeBundle(
				activeScheme, defaultScheme, disabledScheme),
				new SteelBlueColorScheme().saturate(-0.3).tint(0.5).named(
						"Mist Aqua Background"), DecorationAreaType.GENERAL);

		this.registerAsDecorationArea(defaultScheme,
				DecorationAreaType.PRIMARY_TITLE_PANE,
				DecorationAreaType.SECONDARY_TITLE_PANE,
				DecorationAreaType.HEADER, DecorationAreaType.FOOTER,
				DecorationAreaType.TOOLBAR);

		this.buttonShaper = new StandardButtonShaper();
		this.gradientPainter = new MatteGradientPainter();
		this.borderPainter = new ClassicBorderPainter();

		this.decorationPainter = new MatteDecorationPainter();
		this.highlightPainter = new ClassicHighlightPainter();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.skin.SubstanceSkin#getDisplayName()
	 */
	public String getDisplayName() {
		return NAME;
	}
}
