/*
 * Copyright (C) 2002, 2003 Jan Panteltje <panteltje@yahoo.com>,
 *
 * Modified and copy right Jan Panteltje 2002
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

// prog for extracting and decoding (to bmp's) the subtitles in a vob
// avalible under GPL v2

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#define cbufs 4096
#define psbufs 10    

#ifndef O_BINARY
#define O_BINARY 0
#endif

unsigned char *img;
unsigned int x0,y0,xd,yd,st,sd,ofs,ofs1,pts,spts,maxpal,subi,subs,debug,type;
unsigned char sub[65536],bb,bc;

typedef struct {
 unsigned char r,g,b,t;
} palt;
palt pal[8];
palt bpal[16];

typedef struct {
 unsigned short int BM;
 unsigned int size;
 unsigned int r0;
 unsigned int ofs;
 
 unsigned int hsize;
 unsigned int x;
 unsigned int y;
 unsigned short int bplanes;
 unsigned short int bpp;
 unsigned int comp;
 unsigned int imgsize;
 unsigned int xpm,ypm;
 unsigned int cused;
 unsigned int cimp; 
} __attribute__ ((packed)) bmpt;


unsigned char gn () {
 if(!bc) {
  bb=sub[ofs++];
  bc=1;
  return bb>>4; 
 }
 bc=0;
 return bb&15;
}

unsigned int getpts(unsigned char *buf) {
 if(!(buf[1]&0xc0) || (buf[2]<4) | ((buf[3]&0xe1)!=0x21) || ((buf[5]&1)!=1) || ((buf[7]&1)!=1)) return -1;
 return (buf[7]>>1)+((unsigned int)buf[6]<<7)+(((unsigned int)buf[5]&254)<<14)+((unsigned int)buf[4]<<22)+(((unsigned int)buf[3]&14)<<29);
}


int dvddecode()
{
unsigned int io;
unsigned short int size, dsize, i, x, y, t; 
unsigned char c;

size = (((unsigned int)sub[0]) << 8) + sub[1];
dsize = (((unsigned int)sub[2]) << 8) + sub[3];

if(debug>1)
	fprintf(stderr,"packet: 0x%x bytes, 0x%x bytes data\n", size, dsize);
    
st = sd = -1;
i = dsize + 4;

t = sub[dsize] * 256 + sub[dsize + 1];   

if(debug > 2)
	fprintf(stderr,"time offset: %d sub[%d]=0x%02x sub[%d]=0x%02x\n",\
	t, dsize, sub[dsize], dsize + 1, sub[dsize + 1]);
 
while(i < size)
	{
 	c = sub[i];
	if(debug > 4)
		fprintf(stderr, "i: %d cmd: 0x%x\n", i, c);
	
	switch(c)
		{
		case 0x0:	//force start display
			i++;
			if(debug > 4)
				fprintf(stderr,"cmd: force start display\n");
			break;
	    
		case 0x01: 
			i++;
			st = t * 1000 + spts;
			if(debug > 4)
				fprintf(stderr,"cmd: start display\n");
			break;
   
		case 0x02: 
			if(debug > 4)
				fprintf(stderr,"cmd: end display\n");
			sd = t * 1000 - (st - spts);		//assuming start at 0... 
			i++;
			break;

		case 0x03: 
			if(debug > 4)
				fprintf(stderr,"cmd: palette %.2x%.2x\n", sub[i + 1], sub[i + 2]);

			c = sub[i + 1] >> 4; 
			pal[3].r = bpal[c].r; pal[3].g = bpal[c].g; pal[3].b = bpal[c].b;   
			c= sub[i + 1] & 15; 
			pal[2]. r= bpal[c].r; pal[2].g = bpal[c].g; pal[2].b = bpal[c].b;   
			c= sub[i + 2] >> 4; 
			pal[1].r=bpal[c].r; pal[1].g=bpal[c].g; pal[1].b=bpal[c].b;   
			c= sub[i + 2] & 15; 
			pal[0].r = bpal[c].r; pal[0].g = bpal[c].g; pal[0].b = bpal[c].b;   
    
			i += 3;
			break;

		case 0x04: 
			if(debug > 4)
				fprintf(stderr,"cmd: t-palette %.2x%.2x\n", sub[i + 1], sub[i + 2]);

			pal[3].t = (sub [i + 1] >> 4) * 17;
			pal[2].t = (sub [i + 1] & 0xf )* 17;
			pal[1].t = (sub [i + 2] >> 4) * 17;
			pal[0].t = (sub [i + 2] & 0xf) * 17;
			i += 3;
			break;

		case 0x05: 
			x0 = ((((unsigned int)sub[i + 1]) << 4) + (sub[i + 2] >> 4) );
			xd = ( ((sub[i+2] & 0x0f) << 8) + sub[i + 3] ) - x0 + 1;

			y0 = ( (((unsigned int)sub[i + 4]) << 4) + (sub[i + 5] >> 4) );
			yd = ( ((sub[i + 5] & 0x0f) << 8) + sub[i + 6] ) - y0 + 1;

			if(debug>4)
				fprintf(stderr,"cmd: img ofs %d,%d  size: %d,%d\n",x0,y0,xd,yd);
			i += 7;
			break;

		case 0x06: 
			ofs = (((unsigned int)sub[i + 1]) << 8) + sub[i + 2];
			ofs1 = (((unsigned int)sub[i + 3]) << 8) + sub[i + 4];
			if(debug > 4)
				fprintf(stderr, "cmd: image offsets 0x%x 0x%x\n", ofs, ofs1);
			i += 5;
			break;

		case 0xff: 
			if(debug > 4)
				fprintf(stderr, "cmd: end cmd\n");
 	       
			if(i + 5 > size)
				{
				if(debug > 4)
					fprintf(stderr,"short end command i=%d size=%d (%d bytes)\n", i, size, size - i);        

				i = size;
				break;
				}

			t = sub[i + 1] * 256 + sub[i + 2];    
			if(debug > 4)
				{
				fprintf(stderr,"next packet time: %d  end: 0x%.2x%.2x\n",\
				t, sub[i + 3], sub[i + 4]);
	    		}

			if( (sub[i + 3] != sub[dsize + 2]) || (sub[i + 4] != sub[dsize + 3]) )
				{
				if(debug > 0)
					{
					fprintf(stderr, "invalid control header (%.2x%.2x != %.2x%.2x) dsize=%d!\n",
					sub[i + 3], sub[i + 4], sub[dsize + 2], sub[dsize + 3], dsize );
					}

				if(debug > 3)
					fprintf(stderr,"i: %d\n", i);				

				i = size;
				break;
				}

			i += 5;
			break;
		    
		default:
			if(debug > 0)
				fprintf(stderr, "invalid sequence in control header (%.2x)!\n", c);
			return -1;
		} /* end switch command */
	} /* end while i < size */
	
bc = 0;
x = y = 0;
io = 0;

while ((ofs < dsize) && (y < yd))
	{
	i = gn();

	if(i < 4)
		{
		i = (i << 4) + gn();
		if(i<16)
			{
			i = (i << 4) + gn(); 
			if(i < 0x40)
				{
				i = (i << 4) + gn();
				if(i < 256)
					{
					bc = 0; 

					y += 2;
					while(x++ != xd) img[io++] = i;
					x = 0;
					if((y >= yd) && !(y & 1))
						{
						y = 1;
						io = xd;
						ofs = ofs1;
						}
					else io += xd;
					continue;
					}
				}
			}
		}

	c = i & 3;
	i = i >> 2;
	while(i--)
		{ 
		img[io++] = c; 
		if(++x == xd)
			{
			y += 2;
			x = 0;
			io += xd;
			bc = 0;
			}	
		}
	}

if(debug>2) fprintf(stderr, "ofs: 0x%x y: %d\n", ofs, y);

return 0;
} /* end fuction dvd_decode */



int g2b()
{
if(!bc)
	{
	bb = sub[ofs++];
	bc = 3;
	return bb >> 6;
	}

bb = bb << 2;
bc--;

return bb >> 6;
} /* end function g2b */    

    
void palette(int p,int i) {
 double Y,Cr,Cb,R,G,B;
 Y=sub[i+0];
 Cr=sub[i+1];
 Cb=sub[i+2];
 B = 1.164*(Y - 16)                   + 2.018*(Cb - 128);
 G = 1.164*(Y - 16) - 0.813*(Cr - 128) - 0.391*(Cb - 128);
 R = 1.164*(Y - 16) + 1.596*(Cr - 128);
 if(B<0) B=0; if(B>255) B=255;
 if(G<0) G=0; if(G>255) G=255;
 if(R<0) R=0; if(R>255) R=255;
 pal[p].r=R;
 pal[p].g=G;
 pal[p].b=B; 
 pal[p].t=sub[i+3];
}    


int svcddecode() {
 int a,hinfo,i,x,y,pz;
 unsigned char c;
 


 pz = ((unsigned int)sub[0]<<8)+sub[1];
    
 if(debug>1) fprintf(stderr,"packetsize: 0x%x  hinfo: 0x%x\n",pz,sub[2]);
 
 
 st=spts;

 hinfo=sub[2];
    
 i=4;
    
    

    
 if(hinfo&8) {
  sd=((int)sub[i]<<24)+((int)sub[i+1]<<16)+((int)sub[i+2]<<8)+((int)sub[i+3]);
  if(debug>1) fprintf(stderr,"tlen: %d\n",sd);
  i+=4;
 } else sd=-1;
    
    
 x0=((unsigned int)sub[i]<<8)+sub[i+1];
 y0=((unsigned int)sub[i+2]<<8)+sub[i+3];    
    
 i+=4;
    
 xd=sub[i]*256+sub[i+1];
 yd=sub[i+2]*256+sub[i+3];
 i+=4;
   
 palette(0,i);  i+=4;
 palette(1,i);  i+=4;
 palette(2,i);  i+=4;
 palette(3,i);  i+=4;    
    
    
 c=sub[i++]; 	//command
 if(c) {
  if(debug>0) fprintf(stderr,"command 0x%x found\n",c);
  if(c&0x40) {   //shift
   if(debug>1) fprintf(stderr,"shift direction: %d time: %.2fs\n",(c>>4)&3,(double)(((unsigned int)sub[i]<<24)+((unsigned int)sub[i+1]<<16)+((unsigned int)sub[i+2]<<8)+sub[i+3])/90000);
   i+=4;
  } else { fprintf(stderr,"unknown command, skipping this sub\n"); return -1; }
 } else if(debug>1) fprintf(stderr,"no additional commands for this sub\n");
    

 x=y=0;

 bc=0;
   
 ofs=i+2;
 ofs1=((int)sub[i]<<8)+((int)sub[i+1])+ofs;
    
 if(debug>1) fprintf(stderr,"w: %d  h: %d xpos: %d ypos: %d offset: 0x%x ofs1: 0x%x \n",xd,yd,x0,y0,ofs+16,ofs1+16); 
 
 a=0;

 while ((ofs < pz) && (y < yd)) {

  c=g2b();
	

  if(!c) {
   c=g2b()+1;
   while(c--) { img[a++]=0; x++;}
  } else { img[a++]=c; x++; } 
  
  if(x==xd) {
   x=0; 
   y+=2; 
   bc=0; 
   a+=xd;
  }

  if((y>=yd) && !(y&1)) { if(debug>2) fprintf(stderr,"scan 2: %d %d %d\n",ofs-ofs1,bc,y); a=xd; bc=0; ofs=ofs1; y=1; x=0;  }

 }
       
 if(debug>2) fprintf(stderr,"padding: %d\n",pz-ofs);   
 return 0;
}


int cvddecode() {
 int x,y,a,size,dsize,i;
 unsigned char c;

 size = ((unsigned int)sub[0]<<8)+sub[1];
 st=spts;

 dsize = (((unsigned int)sub[2])<<8)+sub[3];
 
 if(debug>1) fprintf(stderr,"packetsize: %d  datasize: %d\n",size,dsize);

 i = dsize;	//+4 p dvd

 while (i<size)	{
	
  switch (sub[i]) {

   case 0x17:
   x0=((unsigned int)(sub[i+1]&15)<<6)+(sub[i+2]>>2);
   y0=((unsigned int)(sub[i+2]&3)<<8)+sub[i+3];
   if(debug>4) fprintf(stderr,"x0y0: %.2x %.2x %.2x %d %d\n",sub[i+1],sub[i+2],sub[i+3],x0,y0);        
   i+=4;
  break;
            
  case 0x1f:
   xd=((unsigned int)(sub[i+1]&15)<<6)+(sub[i+2]>>2);
   yd=((unsigned int)(sub[i+2]&3)<<8)+sub[i+3];
   if(debug>4) fprintf(stderr,"x1y1: %.2x %.2x %.2x %d %d\n",sub[i+1],sub[i+2],sub[i+3],xd,yd);        
   i+=4;
  break;

  case 0x47:
   if(debug>4) fprintf(stderr,"ofs %.2x %.2x %.2x %d %d\n",sub[i+1],sub[i+2],sub[i+3],(sub[i+1])*16+(sub[i+2]>>4),(sub[i+2]&15)*256+sub[i+3]);
   ofs=((unsigned int)sub[i+2]<<8)+sub[i+3];
   i+=4;
  break;
            	    
  case 0x4f:
   if(debug>4) fprintf(stderr,"ofs1 %.2x %.2x %.2x %d %d\n",sub[i+1],sub[i+2],sub[i+3],(sub[i+1])*16+(sub[i+2]>>4),(sub[i+2]&15)*256+sub[i+3]);
   ofs1=((unsigned int)sub[i+2]<<8)+sub[i+3];
   i+=4;
  break;
            
  case 0x04:
   sd=((unsigned int)sub[i+1]<<16)+((unsigned int)sub[i+2]<<8)+sub[i+3];
   if(debug>4) fprintf(stderr,"tid:  %.2x %.2x %.2x %d %f\n",sub[i+1],sub[i+2],sub[i+3],sd,(double)sd/90000);
   i+=4;
  break;
            	    
  case 0x24:
  case 0x25: 
  case 0x26:
  case 0x27:
   palette(sub[i]-0x24,i+1);
            	
   if(debug>4) fprintf(stderr,"palette0, color %d: #%.2x%.2x%.2x\n",sub[i]-0x24,pal[sub[i]-0x24].r,pal[sub[i]-0x24].g,pal[sub[i]-0x24].b);
   i+=4;
  break;
            	
     
  case 0x2c: 
  case 0x2d:
  case 0x2e:
  case 0x2f:
   palette(sub[i]-0x28,i+1);
   if(debug>4) fprintf(stderr,"palette1, color %d: #%.2x%.2x%.2x\n",sub[i]-0x24,pal[sub[i]-0x28].r,pal[sub[i]-0x28].g,pal[sub[i]-0x28].b);
   i+=4;
  break;
           	
  case 0x37:
   pal[0].t=(sub[i+3]&15)*17;
   pal[1].t=(sub[i+3]>>4)*17;
   pal[2].t=(sub[i+2]&15)*17;
   pal[3].t=(sub[i+2]>>4)*17;
             
   if(debug>4) fprintf(stderr,"t-palette0, %d%% %d%% %d%% %d%%\n",(15-pal[0].t)*100/15,(15-pal[1].t)*100/15,(15-pal[2].t)*100/15,(15-pal[3].t)*100/15);
   i+=4;
  break;                
            
  case 0x3f:
   pal[4].t=(sub[i+3]&15)*17;
   pal[5].t=(sub[i+3]>>4)*17;
   pal[6].t=(sub[i+2]&15)*17;
   pal[7].t=(sub[i+2]>>4)*17;
   if(debug>4) fprintf(stderr,"t-palette1, %d%% %d%% %d%% %d%%\n",(15-pal[4].t)*100/15,(15-pal[5].t)*100/15,(15-pal[6].t)*100/15,(15-pal[7].t)*100/15);
   i+=4;
  break;

  case 0x0c:
   if(debug>4) fprintf(stderr,"unknown 3 byte command 0x%x, %.2x %.2x %.2x %d %d\n",sub[i],sub[i+1],sub[i+2],sub[i+3],(sub[i+1])*16+(sub[i+2]>>4),(sub[i+2]&15)*256+sub[i+3]);
   i+=4;
  break;

  default:
   if(debug>1) fprintf(stderr, "invalid sequence in control header (%.2x)!\n", sub[i]);
//   return -1;
i +=4; // added
  }
 }

 if(debug>2) fprintf(stderr,"size: %d %d\n",sub[dsize-2]+((unsigned int)sub[dsize-1]<<8),sub[dsize+0]+((unsigned int)sub[dsize+1]<<8));
    	
        
 bc = 0;

 x=y=0;
 xd+=-x0+1;
 yd+=-y0+1;
   
 a=0;
 
 
 while ((ofs < dsize+2) && (y < yd)) {
  i=gn();

  if(!(i&12) && (i)) fprintf(stderr,"det hnde %d %d\n",x,y);
/*
  if(i<4) {
   i=(i<<4)+gn();
   if(i<4) {
    
    bc=0; 

    y+=2;
    while(x++!=xd) img[a++]=i;
    x=0;
    if((y>=yd) && !(y&1)) {
     y=1;
     a=xd;
     if(debug>4) fprintf(stderr,"ofs1-ofs: %d\n",ofs1-ofs);
     ofs=ofs1;
    } else a+=xd;
    continue;
   }

   if(i<16) i=(i<<4)+gn(); 
 
  }
  
*/ 

  
  
  
  if(!i) {
   i=gn();
   bc=0; 
   y+=2;
   while(x++!=xd) img[a++]=i;
   x=0;
   if((y>=yd) && !(y&1)) {
    y=1;
    a=xd;
    if(debug>4) fprintf(stderr,"ofs1-ofs: %d\n",ofs1-ofs);
    ofs=ofs1;
   } else a+=xd;
   continue;
  }
  
  

  c=i&3;
  i=i>>2;
  while (i--) { 
   img[a++]=c; 
   if(++x==xd) {
    y+=2;
    x=0;
    a+=xd;
    bc=0;
   }	
  }
 }
 if(debug>2) fprintf(stderr,"dsize-ofs: %d\n",dsize-ofs);
 return 0;
}


int write_bmp(char *name) {
 bmpt bmp;
 int fdw;
 unsigned int a,d,lxd,x,y;
 unsigned char c,*limg;
 fdw=open(name,O_WRONLY|O_CREAT|O_TRUNC|O_BINARY,0666);
 if(fdw<0) { fprintf(stderr,"error, unable to open/creat file: %s\n",name); return -1; }	
 
 if(xd&7) lxd=xd+8-(xd%8); else lxd=xd;

 bmp.BM=19778;
 bmp.size=yd*lxd/2+14+40+64; 
 bmp.r0=0;
 bmp.ofs=54+64;
 
 bmp.hsize=40;
 bmp.x=xd;
 bmp.y=yd;
 bmp.bplanes=1;
 bmp.bpp=4;
 bmp.comp=0;
 bmp.imgsize=yd*lxd/2;
 bmp.xpm=bmp.ypm=0;
 bmp.cused=4;
 bmp.cimp=4;
 
 
 if(write(fdw,&bmp,54)<54) { fprintf(stderr,"error, unable to write header to file: %s\n",name); return -1; }	
 
 d=0;
 c=0;
 for(a=0;a<4;a++) {
  d+=write(fdw,&pal[a].b,1);
  d+=write(fdw,&pal[a].g,1);
  d+=write(fdw,&pal[a].r,1);
  d+=write(fdw,&c,1);
 } 
 
 
 for(a=0;a<48;a++) d+=write(fdw,&c,1); 
 
 
 if(d!=64) { fprintf(stderr,"error, unable to write palette to file: %s\n",name); return -1; }	
 
 limg=malloc(yd*lxd/2);
 memset(limg,0,yd*lxd/2);
 
 a=0;
 for(y=yd-1; y!=-1;y--) {
  for(x=0;x<xd;x+=2) 
   if(x+1==xd) limg[a++]=img[y*xd+x]<<4; else limg[a++]=(img[y*xd+x]<<4)+img[y*xd+x+1];
  
  a+=(lxd-x)/2;
 }
 write(fdw,limg,a);
 free(limg);
 close(fdw);
 return 0;
}

int h2d(unsigned char *ch) {
 int a;
 if((ch[0]<48) || ((ch[0]>57) && (ch[0]<97)) || (ch[0]>102)) return 0;
 if((ch[1]<48) || ((ch[1]>57) && (ch[1]<97)) || (ch[1]>102)) return 0;
 if(ch[0]>57) a=ch[0]-87; else a=ch[0]-48;
 a=a<<4;
 if(ch[1]>57) a+=ch[1]-87; else a+=ch[1]-48;
 return a;
}

#define bps(n,R,G,B) do { bpal[n].r=R; bpal[n].g=G; bpal[n].b=B; } while (0) 
                     

int main(int argc,char **argv)
{
int fd;
unsigned int c,a,dump,subno,i,inc,Inc;
unsigned short int b;
unsigned char cbuf[cbufs];
unsigned char psbuf[psbufs];
unsigned char nbuf[256],*pname,*nptr,ot0,ot1,ot2,ot3,*iname[256];
FILE *fdo;

if(argc < 2)
	{
parse_err: 
	fprintf(stderr,"%s [options] [file(s) to extract from (default: input.mpg)]\n",argv[0]);
	fprintf(stderr,"options:\n");  
	fprintf(stderr,"-o <name>	base name for script and images (default sub)\n");  
	fprintf(stderr,"-v <level>	verbosity level (default 0) \n");  
	fprintf(stderr,"-C	 	extract CVD subtitles (default DVD)\n"); 
	fprintf(stderr,"-S	 	extract SVCD subtitles (default DVD)\n"); 
	fprintf(stderr,"-s <stream>	number of the substream to insert (default 0)\n");   
	fprintf(stderr,"-p <file>	name of file with dvd palette (default palette.txt)\n");     
	fprintf(stderr,"\n");
	exit(-1);
	} /* end if argc */
 
nptr = "sub";
debug = 0;
type = 0;
dump = 0;
pname = "palette.txt";
Inc = inc = 0;

i = 1;
 
while(i < argc)
	{
	if(argv[i][0]!='-')
		{
   		iname[Inc++] = argv[i++];
		continue;
		} 
   
	switch(argv[i][1])
		{
		case '-':
			i++;
			while(i < argc) iname[Inc++] = argv[i++];
			continue;
  		case 'o':
			i++; if(i == argc) goto parse_err;
			nptr = argv[i];
			i++;
			break;
		case 'p':
			i++; if(i == argc) goto parse_err;
			pname = argv[i];
			i++;
			break;    
		case 'v':
			if(strlen(argv[i]) > 2) debug = atoi(argv[i] + 2);
			else
				{
				i++; if(i == argc) goto parse_err;
				debug = atoi(argv[i]);
				} 
			i++;
			break;
		case 's':
			if(strlen(argv[i])>2) dump = atoi(argv[i] + 2);
			else
				{
				i++; if(i == argc) goto parse_err;
				dump = atoi(argv[i]);
				}     
			i++;
			break;
		case 'C':
			type = 1;
			i++;
			break;
		case 'S':
			type = 2;
			i++;
			break;
		default:
			fprintf(stderr,"unknown option %s\n\n", argv[i]);
			goto parse_err;
		}  /* end switch */
	} /* end while */

if(!Inc)
	{
	iname[0] = "input.mpg";
	Inc = 1;
	}
 
img = malloc(720 * 576);

ot0 = 0; ot1 = 255; ot2 = 255; ot3 = 255;

if(!type)
	{
	bps( 0,  0,  0,  0);
	bps( 1,127,  0,  0);
	bps( 2,  0,127,  0);
	bps( 3,127,127,  0);
	bps( 4,  0,  0,127);
	bps( 5,127,  0,127);
	bps( 6,  0,127,127);
	bps( 7,127,127,127);
	bps( 8,192,192,192);
	bps( 9,128,  0,  0);
	bps(10,  0,128,  0);
	bps(11,128,128,  0);
	bps(12,  0,  0,128);
	bps(13,128,  0,128);
	bps(14,  0,128,128);
	bps(15,128,128,128);

	fdo = fopen(pname, "r");
 
	if(fdo != NULL)
		{
		for(b = 0; b < 16; b++)
			{
			if(feof(fdo)) break;
			fgets(cbuf, cbufs, fdo);

			if(strlen(cbuf) >= 6)
				{ 
				a = 0;
				bpal[b].r = h2d(cbuf + a); a += 2;
				bpal[b].g = h2d(cbuf + a); a += 2;
				bpal[b].b = h2d(cbuf + a); a += 2; 
				if(debug > 3) fprintf(stderr, "pal: %d #%.2x%.2x%.2x\n", b, bpal[b].r, bpal[b].g, bpal[b].b);
				} 
			}
		fclose(fdo);
		}
	else fprintf(stderr,"unable to open %s, using defaults\n",pname);
	} /* end if! type (! dvd) */
 
if(strlen(nptr) > 246)
	{
	fprintf(stderr, "error: max length of base for filename creation is 246 characters\n");
	return -1;
	}
  
sprintf(nbuf, "%s.sub", nptr);
fdo = fopen(nbuf, "w+"); 

pts = 0;
subno = 0;
subi = 0;
 
while(inc < Inc)
	{
	fd = open(iname[inc], O_RDONLY | O_BINARY);
	if(fd < 0)
		{
		fprintf(stderr,"error opening file %s\n", iname[inc]);

		exit(-1);
		}
 
	if(debug > 0) fprintf(stderr, "file: %s\n", iname[inc]);
  
	inc++;
 
	while(read(fd, &c, 4))
		{
		if(c == 0xba010000)
			{ 
l_01ba:  
			if(debug > 5) fprintf(stderr,"pack_start_code\n");

			if(read(fd ,psbuf, psbufs) < 1) break;

			if(debug > 5)
				{
				fprintf(stderr,\
				"system time: %d\n",\
				(psbuf[4]>>3)+(psbuf[3]*32)+((psbuf[2]&3)*32*256)+\
				((psbuf[2]&0xf8)*32*128)+(psbuf[1]*1024*1024)+((psbuf[0]&3)*1024*1024*256)+\
				((psbuf[0]&0x38)*1024*1024*256*2));
				}
			}
		else
			{
			read(fd, &b, 2);
			b = (b >> 8) | (b << 8);
    
			switch(c)
				{
				case 0xb9010000: if(debug>5) fprintf(stderr,"end packet\n"); break; 
				case 0xbb010000: if(debug>5) fprintf(stderr,"system header\n"); break;
				case 0xbf010000: if(debug>5) fprintf(stderr,"private stream 2\n"); break;
				case 0xbd010000: if(debug>5) fprintf(stderr,"private stream\n");  break;   
				case 0xe0010000: if(debug>5) fprintf(stderr,"video stream\n"); break;   
				case 0xe2010000: if(debug>5) fprintf(stderr,"video stream 3??\n"); break;   
				case 0xbe010000: if(debug>5) fprintf(stderr,"padding stream %d bytes\n",b); break;   
				case 0xc0010000: if(debug>5) fprintf(stderr,"audio stream\n");  break; 
				case 0xc1010000: if(debug>5) fprintf(stderr,"audio stream 2\n"); break; 
				default:
					if(debug>0) fprintf(stderr,"unknown header %x\n",c);   
					a = b = 0;
					while(a != 0x1ba)
						{
						a = a << 8;
						if(read(fd, &a, 1) < 1) break;
							b++;
						}

					if(debug>0) fprintf(stderr,"skipped %d bytes of garbage\n", b);
					goto l_01ba;
				} /* end switch */
    
			if((c != 0xbd010000) || (!b)) lseek(fd,b,SEEK_CUR);
			else
				{
				read(fd, cbuf, b); 
     
				a = getpts(cbuf);
				if(a != -1) pts = a;
     
				a = cbuf[2] + 3;
   
				if(debug>5)
					for (c = 0; c < a; c++) fprintf(stderr,"0x%02x ", cbuf[c]); 

				if(debug>5)
					fprintf(stderr,"tid: %d\n",pts);

				if( /*(debug > 1) && */ (cbuf[a] == 0x70)) fprintf(stderr,"substr: %d\n", cbuf[a + 1]);

				if((!type && (cbuf[a] == dump + 32)) ||\
				((type == 1) && (cbuf[a] == dump)) ||\
				((type == 2) && (cbuf[a] == 0x70) && (cbuf[a + 1] == dump)))
					{
					if((debug < 6) && (debug > 1))
						{
						fprintf(stderr, "id: 0x%x 0x%x %d  tid: %d\n", cbuf[a], b, a, pts); 
		 				}

					if(!subi)
						{
						if(type == 2) subs = ((unsigned int)cbuf[a + 5] << 8) + cbuf[a + 6];
						else subs = ((unsigned int)cbuf[a + 1] << 8) + cbuf[a + 2];


						if(type == 1) subs += 4;

						spts = pts;
						} 
      
					if(type == 2) // svcd
						{
						memcpy(sub + subi, cbuf + a + 1 + 4, b - a - 1 - 4);
						if(debug > 1)
							{
							fprintf(stderr,\
							"found %d bytes of data for substream %d, subtitle %d, sequence number %d\n",\
							b - a - 1 - 4, cbuf[a + 1], cbuf[a + 4] + ((unsigned int)cbuf[a + 3] << 8),\
							cbuf[a + 2]);

							subi += b - a - 1 - 4;     
							}
						}
					else // dvd or cvd
						{
						memcpy(sub + subi, cbuf + a + 1, b - a - 1);

						if(debug > 1) 
							{
							fprintf(stderr, "found %d bytes of data\n", b - a - 1);
							}	

						subi += b - a - 1;
						}
     
					if(debug > 2)
						{
						fprintf(stderr, "subi: %d (0x%x)  subs: %d (0x%x) b-a-1: %d (0x%x)\n",\
						subi, subi, subs, subs, b - a - 1, b - a - 1);
						}
		    
					if(subs == subi)
						{	
						subi = 0;

						switch(type)
							{
							case 0:
								a = dvddecode();
								break;
							case 1:
								a = cvddecode();
								break;
							case 2:
								a = svcddecode();
								break;
							} 
      
						if(a)
							{ 
							fprintf(stderr,"found unreadable subtitle at %.2fs, skipping\n", (double)spts / 90000);
							continue;
							}
      
//						if(debug > 0)
							{					
							fprintf(stderr,\
							"found sub at: %.2f  x0: %d y0: %d  xd: %d yd:%d  sd: %.2f\n",\
							(double)st / 90000, x0, y0, xd, yd, (double)sd / 90000);
       						}

						sprintf(nbuf, "%s%.4x.bmp", nptr, subno++);

						write_bmp(nbuf);
       
						if(sd != -1) sd += st; else sd = 0;
       
						if((ot0 == pal[0].t) && (ot1 == pal[1].t) && (ot2 == pal[2].t) && (ot3 == pal[3].t)) 
							{
							fprintf(fdo,"%s\t%.2d:%.2d:%.2d,%.2d\t%.2d:%.2d:%.2d,%.2d\t%d\t%d\t%d\t%d\n",
							nbuf,(st/(60*60*90000))%24,(st/(60*90000))%60,(st/90000)%60,(st/900)%100,
							(sd/(60*60*90000))%24,(sd/(60*90000))%60,(sd/90000)%60,(sd/900)%100,      		    	
							xd,yd,x0,y0);   
							}
						else
							{ 
							fprintf(fdo,"%s\t%.2d:%.2d:%.2d,%.2d\t%.2d:%.2d:%.2d,%.2d\t%d\t%d\t%d\t%d\t%d %d %d %d\n",
							nbuf,(st/(60*60*90000))%24,(st/(60*90000))%60,(st/90000)%60,(st/900)%100,
							(sd/(60*60*90000))%24,(sd/(60*90000))%60,(sd/90000)%60,(sd/(900))%100,      		    	
							xd,yd,x0,y0,pal[0].t,pal[1].t,pal[2].t,pal[3].t);   
       						}

						ot0 = pal[0].t; ot1 = pal[1].t; ot2 = pal[2].t; ot3 = pal[3].t;
						} /* end if subs == subi */
					} /* end if relevant packet / stream */ 
				} /* end if relevant packet / stream */ 

			} /* end if 0xbd010000 */

		} /* end while read 4 */

	close(fd);
	} /* end while inc < Inc */ 

if(fdo) fclose(fdo);

free(img);

return 0;
} /* end function main */

