/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class FileResource
extends AbstractResource {
    private File file;

    public FileResource(IFile file) {
        if (file != null) {
            this.file = file.getLocation().toFile();
        }
    }

    public FileResource(String path) {
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Path '" + path + "' has to " + " be relative to Eclipse workspace");
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource member = root.findMember(path);
        if (member != null) {
            this.file = member.getFullPath().toFile();
        }
    }

    public boolean exists() {
        return this.file != null && this.file.exists();
    }

    public InputStream getInputStream() throws IOException {
        if (this.file == null) {
            throw new FileNotFoundException("File not found");
        }
        return new FileInputStream(this.file);
    }

    public URL getURL() throws IOException {
        if (this.file == null) {
            throw new FileNotFoundException("File not found");
        }
        return new URL("file:" + this.file.getAbsolutePath());
    }

    public File getFile() {
        return this.file;
    }

    public Resource createRelative(String relativePath) {
        File parent;
        if (this.file != null && (parent = this.file.getParentFile()) != null) {
            return new FileSystemResource(new File(parent, relativePath));
        }
        return new FileResource(relativePath);
    }

    public String getFilename() {
        return this.file.getName();
    }

    public String getDescription() {
        return "file [" + (this.file != null ? this.file.getAbsolutePath() : "") + "]";
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof FileResource && ((FileResource)((Object)obj)).file.equals(this.file);
    }

    public int hashCode() {
        return this.file != null ? this.file.hashCode() : 0;
    }
}

