/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.project;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.springframework.ide.eclipse.beans.core.BeanDefinitionException;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfig;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigValidator;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.project.IProjectBuilder;

public class BeansProjectValidator
implements IProjectBuilder {
    public void build(IFile file, IProgressMonitor monitor) {
        if (BeansCoreUtils.isBeansConfig((IResource)file)) {
            monitor.beginTask(BeansCorePlugin.getFormattedMessage("BeansProjectValidator.validateFile", file.getFullPath().toString()), -1);
            BeansCoreUtils.deleteProblemMarkers((IResource)file);
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IBeansProject project = BeansCorePlugin.getModel().getProject(file.getProject());
            BeansConfig config = (BeansConfig)project.getConfig(file);
            config.reset();
            BeanDefinitionException e = config.getException();
            if (e != null) {
                BeansModelUtils.createProblemMarker((IModelElement)config, e.getMessage(), 2, e.getLineNumber(), 1);
            } else {
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                BeansConfigValidator validator = new BeansConfigValidator();
                validator.validate(config, monitor);
            }
            monitor.done();
        }
    }
}

