/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.parser;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.DefaultXmlBeanDefinitionParser;
import org.springframework.core.io.Resource;
import org.springframework.ide.eclipse.beans.core.BeanDefinitionException;
import org.springframework.ide.eclipse.beans.core.internal.parser.ExtendedBeanDefinitionHolder;
import org.springframework.ide.eclipse.beans.core.internal.parser.IBeanDefinitionEvents;
import org.springframework.util.ResourceUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EventBeanDefinitionParser
extends DefaultXmlBeanDefinitionParser {
    private static final String ROOT_ELEMENT = "beans";
    private IBeanDefinitionEvents eventHandler;

    public EventBeanDefinitionParser(IBeanDefinitionEvents eventHandler) {
        this.eventHandler = eventHandler;
    }

    protected void importBeanDefinitionResource(Element ele) {
        String location = ele.getAttribute("resource");
        if (!ResourceUtils.isUrl((String)location)) {
            try {
                Resource relativeResource = this.getResource().createRelative(location);
                if (!relativeResource.exists()) {
                    throw new FileNotFoundException("Invalid relative resource location '" + location + "'");
                }
            }
            catch (IOException e) {
                throw new BeanDefinitionException((Node)ele, (Throwable)e);
            }
        }
    }

    public int registerBeanDefinitions(BeanDefinitionReader reader, Document doc, Resource resource) {
        Element root = doc.getDocumentElement();
        if (!ROOT_ELEMENT.equals(root.getNodeName())) {
            throw new BeanDefinitionException((Node)root, "No Spring bean config found in " + resource.getDescription());
        }
        return super.registerBeanDefinitions(reader, doc, resource);
    }

    /*
     * Unable to fully structure code
     */
    protected int parseBeanDefinitions(Element root) throws BeanDefinitionStoreException {
        block5: {
            try {
                return super.parseBeanDefinitions(root);
            }
            catch (BeanDefinitionStoreException e) {
                elementName = e.getResourceDescription();
                if (elementName == null) break block5;
                nl = root.getChildNodes();
                i = 0;
                ** while (i < nl.getLength())
            }
lbl-1000:
            // 1 sources

            {
                node = nl.item(i);
                if (node instanceof Element) {
                    ele = (Element)node;
                    if (elementName.equals(node.getNodeName())) {
                        throw new BeanDefinitionException((Node)ele, (Throwable)e);
                    }
                }
                ++i;
                continue;
            }
        }
        throw new BeanDefinitionException((Node)root, (Throwable)e);
    }

    protected BeanDefinitionHolder parseBeanDefinitionElement(Element ele, boolean isInnerBean) {
        try {
            if (isInnerBean) {
                this.eventHandler.startBean(ele, true);
            } else {
                this.eventHandler.startBean(ele, false);
            }
            BeanDefinitionHolder bdHolder = super.parseBeanDefinitionElement(ele, isInnerBean);
            if (bdHolder != null) {
                bdHolder = new ExtendedBeanDefinitionHolder(bdHolder);
            }
            if (this.eventHandler != null) {
                if (isInnerBean) {
                    this.eventHandler.registerBean(bdHolder, true);
                    BeanDefinitionRegistry registry = this.getBeanDefinitionReader().getBeanFactory();
                    registry.registerBeanDefinition(bdHolder.getBeanName(), bdHolder.getBeanDefinition());
                } else {
                    this.eventHandler.registerBean(bdHolder, false);
                }
            }
            return bdHolder;
        }
        catch (DOMException e) {
            throw new BeanDefinitionException((Node)ele, (Throwable)e);
        }
        catch (BeansException e) {
            throw new BeanDefinitionException((Node)ele, (Throwable)e);
        }
    }

    protected void parseConstructorArgElement(Element ele, String beanName, ConstructorArgumentValues cargs) throws BeanDefinitionStoreException {
        try {
            if (this.eventHandler != null) {
                ConstructorArgumentValuesFilter filter = new ConstructorArgumentValuesFilter(cargs, ele);
                this.eventHandler.startConstructorArgument(ele);
                super.parseConstructorArgElement(ele, beanName, (ConstructorArgumentValues)filter);
            } else {
                super.parseConstructorArgElement(ele, beanName, cargs);
            }
        }
        catch (DOMException e) {
            throw new BeanDefinitionException((Node)ele, (Throwable)e);
        }
        catch (BeansException e) {
            throw new BeanDefinitionException((Node)ele, (Throwable)e);
        }
    }

    protected void parsePropertyElement(Element ele, String beanName, MutablePropertyValues pvs) throws DOMException {
        try {
            if (this.eventHandler != null) {
                this.eventHandler.startProperty(ele);
            }
            super.parsePropertyElement(ele, beanName, pvs);
            if (this.eventHandler != null) {
                String name = ele.getAttribute("name");
                this.eventHandler.registerProperty(name, (PropertyValues)pvs);
            }
        }
        catch (DOMException e) {
            throw new BeanDefinitionException((Node)ele, (Throwable)e);
        }
        catch (BeansException e) {
            throw new BeanDefinitionException((Node)ele, (Throwable)e);
        }
    }

    protected Object parsePropertySubElement(Element ele, String beanName) {
        Object value = super.parsePropertySubElement(ele, beanName);
        if (ele.getTagName().equals("idref")) {
            value = new RuntimeBeanReference((String)value);
        }
        return value;
    }

    private class ConstructorArgumentValuesFilter
    extends ConstructorArgumentValues {
        private ConstructorArgumentValues cargs;

        public ConstructorArgumentValuesFilter(ConstructorArgumentValues cargs, Element element) {
            this.cargs = cargs;
        }

        public void addIndexedArgumentValue(int index, Object value) {
            this.cargs.addIndexedArgumentValue(index, value);
            EventBeanDefinitionParser.this.eventHandler.registerConstructorArgument(index, value, null);
        }

        public void addIndexedArgumentValue(int index, Object value, String type) {
            this.cargs.addIndexedArgumentValue(index, value, type);
            EventBeanDefinitionParser.this.eventHandler.registerConstructorArgument(index, value, type);
        }

        public void addGenericArgumentValue(Object value) {
            this.cargs.addGenericArgumentValue(value);
            EventBeanDefinitionParser.this.eventHandler.registerConstructorArgument(-1, value, null);
        }

        public void addGenericArgumentValue(Object value, String type) {
            this.cargs.addGenericArgumentValue(value, type);
            EventBeanDefinitionParser.this.eventHandler.registerConstructorArgument(-1, value, type);
        }
    }
}

