/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.core.model.AbstractSourceModelElement;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;

public class BeansConfigSet
extends AbstractSourceModelElement
implements IBeansConfigSet {
    private List configNames;
    private boolean allowBeanDefinitionOverriding = true;
    private boolean isIncomplete;
    private Map beansMap;
    private Map beanClassesMap;

    public BeansConfigSet(IBeansProject project, String name) {
        this(project, name, new ArrayList());
    }

    public BeansConfigSet(IBeansProject project, String name, List configNames) {
        super((IModelElement)project, name);
        this.configNames = new ArrayList(configNames);
    }

    public void reset() {
        this.beansMap = null;
        this.beanClassesMap = null;
    }

    public int getElementType() {
        return 4;
    }

    public IResource getElementResource() {
        return this.getElementParent() instanceof IResourceModelElement ? ((IResourceModelElement)this.getElementParent()).getElementResource() : null;
    }

    public IModelElement[] getElementChildren() {
        return this.getConfigs().toArray(new IModelElement[this.getConfigs().size()]);
    }

    public void setAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        this.allowBeanDefinitionOverriding = allowBeanDefinitionOverriding;
        this.reset();
    }

    public boolean isAllowBeanDefinitionOverriding() {
        return this.allowBeanDefinitionOverriding;
    }

    public void setIncomplete(boolean isIncomplete) {
        this.isIncomplete = isIncomplete;
    }

    public boolean isIncomplete() {
        return this.isIncomplete;
    }

    public void addConfig(String configName) {
        if (configName.length() > 0 && !this.configNames.contains(configName)) {
            this.configNames.add(configName);
            this.reset();
        }
    }

    public boolean hasConfig(String configName) {
        return this.configNames.contains(configName);
    }

    public boolean hasConfig(IFile file) {
        return this.configNames.contains(file.getProjectRelativePath().toString());
    }

    public void removeConfig(String configName) {
        this.configNames.remove(configName);
        this.reset();
    }

    public Collection getConfigs() {
        return this.configNames;
    }

    public boolean hasBean(String name) {
        return this.getBeansMap().containsKey(name);
    }

    public IBean getBean(String name) {
        return (IBean)this.getBeansMap().get(name);
    }

    public Collection getBeans() {
        return this.getBeansMap().values();
    }

    public void replaceConfig(String origFileName, String newFileName) {
        this.removeConfig(origFileName);
        this.addConfig(newFileName);
        this.reset();
    }

    public boolean isBeanClass(String className) {
        return this.getBeanClassesMap().containsKey(className);
    }

    public Collection getBeanClasses() {
        return this.getBeanClassesMap().keySet();
    }

    public Collection getBeans(String className) {
        if (this.isBeanClass(className)) {
            return (Collection)this.getBeanClassesMap().get(className);
        }
        return Collections.EMPTY_LIST;
    }

    public String toString() {
        return String.valueOf(this.getElementName()) + ": " + this.configNames.toString();
    }

    private Map getBeansMap() {
        if (this.beansMap == null) {
            this.beansMap = new HashMap();
            Iterator iter = this.configNames.iterator();
            while (iter.hasNext()) {
                String configName = (String)iter.next();
                IBeansConfig config = BeansModelUtils.getConfig(configName, this);
                if (config == null) continue;
                Iterator beans = config.getBeans().iterator();
                while (beans.hasNext()) {
                    IBean bean = (IBean)beans.next();
                    if (!this.allowBeanDefinitionOverriding && this.beansMap.containsKey(bean.getElementName())) continue;
                    this.beansMap.put(bean.getElementName(), bean);
                }
            }
        }
        return this.beansMap;
    }

    private Map getBeanClassesMap() {
        if (this.beanClassesMap == null) {
            this.beanClassesMap = new HashMap();
            Iterator beans = this.getBeansMap().values().iterator();
            while (beans.hasNext()) {
                IBean bean = (IBean)beans.next();
                this.addBeanClassToMap(bean);
                Iterator innerBeans = bean.getInnerBeans().iterator();
                while (innerBeans.hasNext()) {
                    IBean innerBean = (IBean)innerBeans.next();
                    this.addBeanClassToMap(innerBean);
                }
            }
        }
        return this.beanClassesMap;
    }

    private void addBeanClassToMap(IBean bean) {
        String className = bean.getClassName();
        if (className != null) {
            ArrayList<IBean> beanClassBeans;
            int pos = className.indexOf(36);
            if (pos > 0) {
                className = className.substring(0, pos);
            }
            if ((beanClassBeans = (ArrayList<IBean>)this.beanClassesMap.get(className)) == null) {
                beanClassBeans = new ArrayList<IBean>();
                this.beanClassesMap.put(className, beanClassBeans);
            }
            beanClassBeans.add(bean);
        }
    }
}

