/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.swt.graphics.Color;

public class ShadowedLineBorder
extends LineBorder {
    private int shadowWidth;

    public ShadowedLineBorder() {
        this(ColorConstants.black, 1, 4);
    }

    public ShadowedLineBorder(Color color, int lineWidth, int shadowWidth) {
        super(color, lineWidth);
        this.shadowWidth = shadowWidth;
    }

    public void setShadowWidth(int shadowWidth) {
        this.shadowWidth = shadowWidth;
    }

    public int getShadowWidth() {
        return this.shadowWidth;
    }

    public Insets getInsets(IFigure figure) {
        return new Insets(this.getWidth(), this.getWidth(), this.getWidth() + this.getShadowWidth(), this.getWidth() + this.getShadowWidth());
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        tempRect.setBounds(ShadowedLineBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        ShadowedLineBorder.tempRect.width -= this.getShadowWidth();
        ShadowedLineBorder.tempRect.height -= this.getShadowWidth();
        if (this.getWidth() % 2 == 1) {
            --ShadowedLineBorder.tempRect.width;
            --ShadowedLineBorder.tempRect.height;
        }
        tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
        graphics.setLineWidth(this.getWidth());
        if (this.getColor() != null) {
            graphics.setForegroundColor(this.getColor());
        }
        graphics.drawRectangle(tempRect);
        PointList plt = new PointList();
        plt.addPoint(ShadowedLineBorder.tempRect.x + 1 + ShadowedLineBorder.tempRect.width, ShadowedLineBorder.tempRect.y + this.getShadowWidth());
        plt.addPoint(ShadowedLineBorder.tempRect.x + ShadowedLineBorder.tempRect.width + 1, ShadowedLineBorder.tempRect.y + ShadowedLineBorder.tempRect.height + 1);
        plt.addPoint(ShadowedLineBorder.tempRect.x + this.getShadowWidth(), ShadowedLineBorder.tempRect.y + ShadowedLineBorder.tempRect.height + 1);
        plt.addPoint(ShadowedLineBorder.tempRect.x + this.getShadowWidth(), ShadowedLineBorder.tempRect.y + ShadowedLineBorder.tempRect.height + this.getShadowWidth());
        plt.addPoint(ShadowedLineBorder.tempRect.x + ShadowedLineBorder.tempRect.width + this.getShadowWidth(), ShadowedLineBorder.tempRect.y + ShadowedLineBorder.tempRect.height + this.getShadowWidth());
        plt.addPoint(ShadowedLineBorder.tempRect.x + ShadowedLineBorder.tempRect.width + this.getShadowWidth(), ShadowedLineBorder.tempRect.y + this.getShadowWidth());
        graphics.setBackgroundColor(ColorConstants.lightGray);
        graphics.fillPolygon(plt);
    }
}

