/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph.editor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GEFPlugin;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.EditorPartAction;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.springframework.ide.eclipse.beans.ui.graph.BeansGraphPlugin;
import org.springframework.ide.eclipse.beans.ui.graph.actions.GraphContextMenuProvider;
import org.springframework.ide.eclipse.beans.ui.graph.actions.OpenConfigFile;
import org.springframework.ide.eclipse.beans.ui.graph.actions.OpenJavaType;
import org.springframework.ide.eclipse.beans.ui.graph.actions.ShowInView;
import org.springframework.ide.eclipse.beans.ui.graph.editor.GraphEditorInput;
import org.springframework.ide.eclipse.beans.ui.graph.editor.GraphOutlinePage;
import org.springframework.ide.eclipse.beans.ui.graph.model.Graph;
import org.springframework.ide.eclipse.beans.ui.graph.parts.GraphicalPartFactory;

public class GraphEditor
extends EditorPart
implements ISelectionListener {
    public static final String EDITOR_ID = "org.springframework.ide.eclipse.beans.ui.graph.editor";
    public static final String CONTEXT_MENU_ID = "org.springframework.ide.eclipse.beans.ui.graph.editor.contextmenu";
    private GraphOutlinePage outlinePage;
    private DefaultEditDomain editDomain;
    private GraphicalViewer graphicalViewer;
    private ActionRegistry actionRegistry;
    private SelectionSynchronizer synchronizer;
    private List selectionActions = new ArrayList();
    private List propertyActions = new ArrayList();
    private Graph graph;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public GraphEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        if (input instanceof GraphEditorInput) {
            GraphEditorInput beansInput = (GraphEditorInput)input;
            this.graph = new Graph(beansInput);
            this.setPartName(beansInput.getName());
            this.setContentDescription(beansInput.getToolTipText());
        } else {
            this.graph = null;
        }
    }

    protected void initializeGraphicalViewer() {
        if (this.graph != null) {
            this.graph.layout(this.getGraphicalViewer().getControl().getFont());
            this.getGraphicalViewer().setContents((Object)this.graph);
        }
    }

    protected void configureGraphicalViewer() {
        ScalableFreeformRootEditPart root = new ScalableFreeformRootEditPart();
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        root.getZoomManager().setZoomLevelContributions(zoomLevels);
        ZoomInAction zoomIn = new ZoomInAction(root.getZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction(root.getZoomManager());
        this.getActionRegistry().registerAction((IAction)zoomIn);
        this.getActionRegistry().registerAction((IAction)zoomOut);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomIn);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomOut);
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setRootEditPart((RootEditPart)root);
        viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(viewer));
        viewer.setEditPartFactory((EditPartFactory)new GraphicalPartFactory());
        viewer.getControl().setBackground(ColorConstants.listBackground);
        GraphContextMenuProvider provider = new GraphContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu(CONTEXT_MENU_ID, (MenuManager)provider, (ISelectionProvider)viewer);
    }

    public Object getAdapter(Class type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            return this.getPropertySheetPage();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.gef.GraphicalViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz2) {
            return this.getGraphicalViewer();
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.gef.ui.actions.ActionRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz3) {
            return this.getActionRegistry();
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.gef.commands.CommandStack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz4) {
            return this.getCommandStack();
        }
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.gef.EditPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz5 && this.getGraphicalViewer() != null) {
            return this.getGraphicalViewer().getRootEditPart();
        }
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.eclipse.draw2d.IFigure");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz6 && this.getGraphicalViewer() != null) {
            return ((GraphicalEditPart)this.getGraphicalViewer().getRootEditPart()).getFigure();
        }
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz7) {
            return this.getOutlinePage();
        }
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("org.eclipse.gef.editparts.ZoomManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz8) {
            return this.getZoomManager();
        }
        return super.getAdapter(type);
    }

    protected IPropertySheetPage getPropertySheetPage() {
        PropertySheetPage page = new PropertySheetPage();
        page.setRootEntry(GEFPlugin.createUndoablePropertySheetEntry((CommandStack)this.getCommandStack()));
        return page;
    }

    protected ZoomManager getZoomManager() {
        return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
    }

    protected GraphOutlinePage getOutlinePage() {
        RootEditPart rootEditPart;
        if (this.outlinePage == null && this.getGraphicalViewer() != null && (rootEditPart = this.getGraphicalViewer().getRootEditPart()) instanceof ScalableFreeformRootEditPart) {
            this.outlinePage = new GraphOutlinePage((ScalableFreeformRootEditPart)rootEditPart);
        }
        return this.outlinePage;
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        EditorPartAction action = new OpenJavaType((IEditorPart)this);
        registry.registerAction((IAction)action);
        action = new OpenConfigFile((IEditorPart)this);
        registry.registerAction((IAction)action);
        action = new ShowInView((IEditorPart)this);
        registry.registerAction((IAction)action);
        action = new PrintAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
    }

    protected void createGraphicalViewer(Composite parent) {
        ScrollingGraphicalViewer viewer = new ScrollingGraphicalViewer();
        viewer.createControl(parent);
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.initializeGraphicalViewer();
    }

    public void createPartControl(Composite parent) {
        this.createGraphicalViewer(parent);
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.getEditDomain().setActiveTool(null);
        this.getActionRegistry().dispose();
        super.dispose();
    }

    protected void firePropertyChange(int property) {
        super.firePropertyChange(property);
        this.updateActions(this.propertyActions);
    }

    protected ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    protected CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    protected DefaultEditDomain getEditDomain() {
        return this.editDomain;
    }

    public GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected List getPropertyActions() {
        return this.propertyActions;
    }

    protected List getSelectionActions() {
        return this.selectionActions;
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new SelectionSynchronizer();
        }
        return this.synchronizer;
    }

    protected void hookGraphicalViewer() {
        this.getSelectionSynchronizer().addViewer((EditPartViewer)this.getGraphicalViewer());
        this.getSite().setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.initializeActionRegistry();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (((Object)((Object)this)).equals(this.getSite().getPage().getActiveEditor())) {
            this.updateActions(this.selectionActions);
        }
    }

    protected void initializeActionRegistry() {
        this.createActions();
        this.updateActions(this.propertyActions);
    }

    protected void setActionRegistry(ActionRegistry registry) {
        this.actionRegistry = registry;
    }

    protected void setEditDomain(DefaultEditDomain editDomain) {
        this.editDomain = editDomain;
    }

    public void setFocus() {
        this.getGraphicalViewer().getControl().setFocus();
    }

    protected void setGraphicalViewer(GraphicalViewer viewer) {
        this.graphicalViewer = viewer;
        this.getEditDomain().addViewer((EditPartViewer)viewer);
    }

    protected void updateActions(List actionIds) {
        ActionRegistry registry = this.getActionRegistry();
        Iterator iter = actionIds.iterator();
        while (iter.hasNext()) {
            IAction action = registry.getAction((Object)((String)iter.next()));
            if (!(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
        SaveAsDialog dialog = new SaveAsDialog(this.getSite().getShell());
        dialog.setOriginalName("graph.jpg");
        dialog.create();
        dialog.setMessage(BeansGraphPlugin.getResourceString("Editor.SaveAsDialog.message"));
        dialog.setOriginalName("graph.jpg");
        dialog.open();
        IPath path = dialog.getResult();
        if (path != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IFile file = workspace.getRoot().getFile(path);
            String ext = file.getFileExtension();
            if (ext == null || ext.length() == 0 || !ext.equalsIgnoreCase("jpg") && !ext.equalsIgnoreCase("bmp")) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)BeansGraphPlugin.getResourceString("Editor.SaveError.title"), null, (IStatus)BeansGraphPlugin.createErrorStatus(BeansGraphPlugin.getResourceString("Editor.SaveAsDialog.error")));
            } else {
                this.saveImage(file, ext.equalsIgnoreCase("jpg") ? 4 : 0);
            }
        }
    }

    public void saveImage(final IFile file, final int format) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    if (file.exists()) {
                        file.setContents((InputStream)new ByteArrayInputStream(GraphEditor.this.createImage(format)), true, false, monitor);
                    } else {
                        file.create((InputStream)new ByteArrayInputStream(GraphEditor.this.createImage(format)), true, monitor);
                    }
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)GraphEditor.this.getSite().getShell(), (String)BeansGraphPlugin.getResourceString("Editor.SaveError.title"), (String)BeansGraphPlugin.getResourceString("Editor.SaveError.text"), (IStatus)e.getStatus());
                }
            }
        };
        try {
            Shell shell = this.getSite().getWorkbenchWindow().getShell();
            new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            BeansGraphPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] createImage(int format) {
        GC gc;
        Image image;
        ByteArrayOutputStream result;
        block6: {
            result = new ByteArrayOutputStream();
            Display device = this.getGraphicalViewer().getControl().getDisplay();
            LayerManager lm = (LayerManager)this.getGraphicalViewer().getEditPartRegistry().get(LayerManager.ID);
            IFigure figure = lm.getLayer((Object)"Printable Layers");
            Rectangle r = figure.getClientArea();
            image = null;
            gc = null;
            SWTGraphics g = null;
            try {
                image = new Image((Device)device, r.width, r.height);
                gc = new GC((Drawable)image);
                g = new SWTGraphics(gc);
                g.translate(r.x * -1, r.y * -1);
                figure.paint((Graphics)g);
                ImageLoader imageLoader = new ImageLoader();
                imageLoader.data = new ImageData[]{image.getImageData()};
                imageLoader.save((OutputStream)result, format);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (g != null) {
                    g.dispose();
                }
                if (gc != null) {
                    gc.dispose();
                }
                if (image == null) throw throwable;
                image.dispose();
                throw throwable;
            }
            {
                Object var11_13 = null;
                if (g == null) break block6;
            }
            g.dispose();
        }
        if (gc != null) {
            gc.dispose();
        }
        if (image == null) return result.toByteArray();
        image.dispose();
        return result.toByteArray();
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }
}

