/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.views;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.springframework.ide.eclipse.beans.ui.model.BeanNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigSetNode;
import org.springframework.ide.eclipse.beans.ui.model.ConstructorArgumentNode;
import org.springframework.ide.eclipse.beans.ui.model.INode;
import org.springframework.ide.eclipse.beans.ui.model.ProjectNode;
import org.springframework.ide.eclipse.beans.ui.model.PropertyNode;
import org.springframework.ide.eclipse.beans.ui.model.RootNode;
import org.springframework.ide.eclipse.beans.ui.views.BeansViewUtils;
import org.springframework.ide.eclipse.core.SpringCoreUtils;

public class BeansViewDropAdapter
extends ViewerDropAdapter {
    public static final int UNKNOWN_SOURCE = 1;
    public static final int XML_FILE_SOURCE = 2;
    public static final int JAVA_FILE_SOURCE = 4;
    public static final int JAVA_PROJECT_SOURCE = 8;
    public static final int ALL_RESOURCES_SOURCES = 15;
    public static final int PROJECT_NODE_SOURCE = 16;
    public static final int CONFIG_NODE_SOURCE = 32;
    public static final int CONFIGSET_NODE_SOURCE = 64;
    public static final int BEAN_NODE_SOURCE = 128;
    public static final int PROPERTY_NODE_SOURCE = 256;
    public static final int CONSTRUCTORARGUMENT_NODE_SOURCE = 512;
    public static final int ALL_NODES_SOURCES = 1008;
    public static final int ALL_SOURCES = 1023;
    public static final int CONFIG_NODE_TARGET = 1024;
    public static final int CONFIGSET_NODE_TARGET = 2048;
    public static final int PROJECT_NODE_TARGET = 4096;
    public static final int ROOT_NODE_TARGET = 8192;
    public static final int BEAN_NODE_TARGET = 16384;
    public static final int PROPERTY_NODE_TARGET = 32768;
    public static final int CONSTRUCTORARGUMENT_NODE_TARGET = 65536;
    public static final int ALL_TARGETS = 130048;
    public static final int LOCATION_AROUND = 131072;
    public static final int LOCATION_ON = 262144;
    public static final int ALL_LOCATIONS = 393216;

    public BeansViewDropAdapter(Viewer viewer) {
        super(viewer);
        this.setScrollExpandEnabled(true);
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return LocalSelectionTransfer.getInstance().isSupportedType(transferType);
    }

    public boolean performDrop(Object data) {
        Object selectedObjects;
        INode dropTarget = (INode)this.getCurrentTarget();
        if (dropTarget == null) {
            dropTarget = (INode)this.getViewer().getInput();
        }
        if ((selectedObjects = BeansViewUtils.getSelectedObjects()) != null) {
            DropStatus dropStatus = new DropStatus();
            dropStatus.flagSourceType(selectedObjects);
            dropStatus.flagTargetType(dropTarget);
            dropStatus.flagDropLocation(this.getCurrentLocation());
            if (dropStatus.hasOnlyOneFlag(1023) && dropStatus.hasOnlyOneFlag(393216) && dropStatus.hasOnlyOneFlag(130048)) {
                if (dropStatus.hasAnyFlag(15)) {
                    IResource[] resources = (IResource[])selectedObjects;
                    if (dropStatus.hasFlag(263172)) {
                        BeanNode[] beanNodes = BeansViewUtils.createBeanNodes(resources, (ConfigNode)dropTarget);
                        BeansViewUtils.addBeanNodes((TreeViewer)this.getViewer(), beanNodes, (ConfigNode)dropTarget);
                    } else if (dropStatus.hasFlag(2)) {
                        if (dropStatus.hasFlag(132096)) {
                            ConfigNode[] configNodes = BeansViewUtils.createConfigNodes(resources, (ProjectNode)dropTarget.getParent());
                            BeansViewUtils.addConfigNodes((TreeViewer)this.getViewer(), configNodes, (ProjectNode)dropTarget.getParent());
                        } else if (dropStatus.hasFlag(266240)) {
                            ConfigNode[] configNodes = BeansViewUtils.createConfigNodes(resources, (ProjectNode)dropTarget);
                            BeansViewUtils.addConfigNodes((TreeViewer)this.getViewer(), configNodes, (ProjectNode)dropTarget);
                        }
                    } else if (dropStatus.hasFlag(8)) {
                        if (dropStatus.hasFlag(270336)) {
                            ProjectNode[] projectNodes = BeansViewUtils.createProjectNodes(resources, (RootNode)dropTarget);
                            BeansViewUtils.addProjectNodes((TreeViewer)this.getViewer(), projectNodes, (RootNode)dropTarget);
                        } else if (dropStatus.hasFlag(135168)) {
                            ProjectNode[] projectNodes = BeansViewUtils.createProjectNodes(resources, (RootNode)dropTarget.getParent());
                            BeansViewUtils.addProjectNodes((TreeViewer)this.getViewer(), projectNodes, (RootNode)dropTarget.getParent());
                        }
                    }
                } else if (dropStatus.hasAnyFlag(1008)) {
                    INode[] nodes = (INode[])selectedObjects;
                    if (dropStatus.hasFlag(264224)) {
                        ConfigNode[] configNodes = BeansViewUtils.castToConfigNodes(nodes);
                        BeansViewUtils.addConfigNodes((TreeViewer)this.getViewer(), configNodes, (ConfigSetNode)dropTarget);
                    }
                }
            }
        }
        return false;
    }

    public class DropStatus {
        public static final int BIT_NUMBERS = 32;
        int flagTable;

        public DropStatus(int initValue) {
            this.flagTable = initValue;
        }

        public DropStatus() {
            this.flagTable = 0;
        }

        public void addFlag(int mask) {
            this.flagTable |= mask;
        }

        public boolean hasFlag(int mask) {
            return (this.flagTable & mask) == mask;
        }

        public boolean hasOnlyOneFlag(int mask) {
            boolean result = false;
            int testValue = this.flagTable & mask;
            int n = testValue = testValue < 0 ? -testValue : testValue;
            if (testValue != 0) {
                int in = 0;
                while (in < 32) {
                    if ((double)testValue == Math.pow(2.0, in)) {
                        result = true;
                        break;
                    }
                    ++in;
                }
            }
            return result;
        }

        public boolean hasAnyFlag(int mask) {
            return (this.flagTable & mask) > 0;
        }

        public int getFlagTable() {
            return this.flagTable;
        }

        public void setFlagTable(int flagTable) {
            this.flagTable = flagTable;
        }

        public void removeFlags(int mask) {
            this.flagTable &= ~mask;
        }

        /*
         * Unable to fully structure code
         */
        public void flagSourceType(Object datas) {
            block22: {
                block23: {
                    result = 0;
                    if (!(datas instanceof IResource[])) break block22;
                    resources = (IResource[])datas;
                    if (resources.length <= 0) break block23;
                    allResourcesfromSameProject = BeansViewUtils.areResourcesFromTheSameProject(resources);
                    switch (BeansViewUtils.getResourcesCommonType(resources)) {
                        case 0: {
                            System.out.println();
                            result |= 1;
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 4: {
                            if (BeansViewUtils.areAllResourcesJavaProjects(resources)) {
                                result |= 8;
                                break;
                            }
                            break block22;
                        }
                        case 1: {
                            if (!allResourcesfromSameProject || !SpringCoreUtils.isJavaProject((IResource)resources[0].getProject())) ** GOTO lbl25
                            if (!BeansViewUtils.areAllResourcesCompilationUnits(resources)) ** GOTO lbl23
                            result |= 4;
                            ** GOTO lbl25
lbl23:
                            // 1 sources

                            if (BeansViewUtils.areAllResourcesXmlFiles(resources)) {
                                result |= 2;
                            }
                        }
lbl25:
                        // 6 sources

                        default: {
                            result |= 1;
                            break;
                        }
                    }
                    break block22;
                }
                result |= 1;
            }
            if (datas instanceof INode[]) {
                nodes = (INode[])datas;
                lastNode = null;
                i = 0;
                while (i < nodes.length) {
                    if (lastNode != null && !lastNode.getClass().equals(nodes[i].getClass())) {
                        result &= -1024;
                        result |= 1;
                        break;
                    }
                    if (nodes[i] instanceof ProjectNode) {
                        result |= 16;
                    } else if (nodes[i] instanceof ConfigSetNode) {
                        result |= 64;
                    } else if (nodes[i] instanceof ConfigNode) {
                        result |= 32;
                    } else if (nodes[i] instanceof BeanNode) {
                        result |= 128;
                    } else if (nodes[i] instanceof PropertyNode) {
                        result |= 256;
                    } else if (nodes[i] instanceof ConstructorArgumentNode) {
                        result |= 512;
                    }
                    ++i;
                }
            }
            this.removeFlags(1023);
            this.addFlag(result);
        }

        public void flagTargetType(INode dropTarget) {
            this.removeFlags(130048);
            if (dropTarget instanceof RootNode) {
                this.addFlag(8192);
            } else if (dropTarget instanceof ProjectNode) {
                this.addFlag(4096);
            } else if (dropTarget instanceof ConfigSetNode) {
                this.addFlag(2048);
            } else if (dropTarget instanceof ConfigNode) {
                this.addFlag(1024);
            } else if (dropTarget instanceof BeanNode) {
                this.addFlag(16384);
            } else if (dropTarget instanceof PropertyNode) {
                this.addFlag(32768);
            } else if (dropTarget instanceof ConstructorArgumentNode) {
                this.addFlag(65536);
            }
        }

        public void flagDropLocation(int treeViewerCurrentLocation) {
            if (treeViewerCurrentLocation == 4) {
                this.addFlag(262144);
            } else if (treeViewerCurrentLocation == 3) {
                this.addFlag(262144);
            } else if (treeViewerCurrentLocation == 2 || treeViewerCurrentLocation == 1) {
                this.addFlag(131072);
            }
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            int i = 31;
            while (i >= 0) {
                result.append(Integer.toString(this.flagTable >> i & 1));
                --i;
            }
            return result.toString();
        }
    }
}

