/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.ui.model.BeanNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigSetNode;
import org.springframework.ide.eclipse.beans.ui.model.ConstructorArgumentNode;
import org.springframework.ide.eclipse.beans.ui.model.INode;
import org.springframework.ide.eclipse.beans.ui.model.ProjectNode;
import org.springframework.ide.eclipse.beans.ui.model.PropertyNode;
import org.springframework.ide.eclipse.beans.ui.model.RootNode;
import org.springframework.ide.eclipse.beans.ui.views.IBeansView;
import org.springframework.ide.eclipse.core.model.IModelChangeListener;
import org.springframework.ide.eclipse.core.model.ModelChangeEvent;

class BeansViewContentProvider
implements ITreeContentProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    private IModelChangeListener listener;
    private RootNode rootNode;

    public BeansViewContentProvider(final IBeansView view) {
        this.listener = new IModelChangeListener(){

            public void elementChanged(ModelChangeEvent event) {
                if (BeansViewContentProvider.this.rootNode != null) {
                    BeansViewContentProvider.this.rootNode.reloadConfigs();
                    view.refresh();
                }
            }
        };
        this.rootNode = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput == null) {
            this.dispose();
        } else if (newInput instanceof RootNode) {
            this.rootNode = (RootNode)newInput;
            BeansCorePlugin.getModel().addChangeListener(this.listener);
        }
    }

    public void dispose() {
        this.rootNode = null;
        BeansCorePlugin.getModel().removeChangeListener(this.listener);
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        return child instanceof INode ? ((INode)child).getParent() : null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof RootNode) {
            return ((RootNode)parent).getProjects();
        }
        if (parent instanceof ProjectNode) {
            ProjectNode project = (ProjectNode)parent;
            List nodes = project.getConfigs();
            nodes.addAll(project.getConfigSets());
            return nodes.toArray(new INode[nodes.size()]);
        }
        if (parent instanceof ConfigSetNode) {
            return ((ConfigSetNode)parent).getBeans(true);
        }
        if (parent instanceof ConfigNode) {
            return ((ConfigNode)parent).getBeans(true);
        }
        if (parent instanceof BeanNode) {
            BeanNode bean = (BeanNode)parent;
            ArrayList<ConstructorArgumentNode> nodes = new ArrayList<ConstructorArgumentNode>(Arrays.asList(bean.getConstructorArguments()));
            nodes.addAll(Arrays.asList(bean.getProperties()));
            return nodes.toArray(new INode[nodes.size()]);
        }
        return null;
    }

    public boolean hasChildren(Object parent) {
        return !(parent instanceof PropertyNode) && !(parent instanceof ConstructorArgumentNode);
    }
}

