/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.properties;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IPropertyListener;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.model.ConfigNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigSetNode;
import org.springframework.ide.eclipse.beans.ui.model.INode;
import org.springframework.ide.eclipse.beans.ui.model.ModelLabelDecorator;
import org.springframework.ide.eclipse.beans.ui.model.ModelLabelProvider;
import org.springframework.ide.eclipse.beans.ui.model.ProjectNode;
import org.springframework.ide.eclipse.beans.ui.properties.ConfigSetDialog;
import org.springframework.ide.eclipse.beans.ui.properties.ProjectContentProvider;
import org.springframework.ide.eclipse.ui.SpringUIUtils;

public class ConfigSetsBlock {
    private static final int TABLE_WIDTH = 250;
    private static final String DESCRIPTION = "ConfigurationPropertyPage.tabConfigSets.description";
    private static final String NEW_BUTTON = "ConfigurationPropertyPage.tabConfigSets.newButton";
    private static final String EDIT_BUTTON = "ConfigurationPropertyPage.tabConfigSets.editButton";
    private static final String REMOVE_BUTTON = "ConfigurationPropertyPage.tabConfigSets.removeButton";
    private static final String UP_BUTTON = "ConfigurationPropertyPage.tabConfigSets.upButton";
    private static final String DOWN_BUTTON = "ConfigurationPropertyPage.tabConfigSets.downButton";
    private ProjectNode project;
    private List configSets;
    private Tree configSetsTree;
    private TreeViewer configSetsViewer;
    private INode selectedNode;
    private Button newButton;
    private Button editButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ConfigSetsBlock.this.handleButtonPressed((Button)e.widget);
        }
    };
    private IPropertyListener propertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            ConfigSetsBlock.this.handlePropertyChanged(source, propId);
        }
    };
    private boolean hasUserMadeChanges;

    public ConfigSetsBlock(ProjectNode project, IAdaptable element) {
        this.project = project;
        this.project.addPropertyListener(this.propertyListener);
    }

    public List getConfigSets() {
        return this.configSets;
    }

    public boolean hasUserMadeChanges() {
        return this.hasUserMadeChanges;
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label description = new Label(composite, 64);
        description.setText(BeansUIPlugin.getResourceString(DESCRIPTION));
        description.setLayoutData((Object)new GridData(768));
        Composite tableAndButtons = new Composite(composite, 0);
        tableAndButtons.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        tableAndButtons.setLayout((Layout)layout);
        this.configSetsTree = new Tree(tableAndButtons, 2816);
        GridData data = new GridData(1808);
        data.widthHint = 250;
        this.configSetsTree.setLayoutData((Object)data);
        this.configSetsTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigSetsBlock.this.handleTreeSelectionChanged();
            }
        });
        this.configSetsViewer = new TreeViewer(this.configSetsTree);
        this.configSetsViewer.setContentProvider((IContentProvider)new ProjectContentProvider(this.project));
        this.configSetsViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new ModelLabelProvider(), (ILabelDecorator)new ModelLabelDecorator()));
        this.configSetsViewer.setSorter((ViewerSorter)new ConfigSetsSorter());
        this.configSetsViewer.setInput((Object)this);
        this.configSetsViewer.expandToLevel((Object)this.project, 1);
        this.configSetsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ConfigSetsBlock.this.handleDoubleClick(event);
            }
        });
        Composite buttonArea = new Composite(tableAndButtons, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonArea.setLayout((Layout)layout);
        buttonArea.setLayoutData((Object)new GridData(1040));
        this.newButton = SpringUIUtils.createButton((Composite)buttonArea, (String)BeansUIPlugin.getResourceString(NEW_BUTTON), (boolean)true, (SelectionListener)this.buttonListener);
        this.editButton = SpringUIUtils.createButton((Composite)buttonArea, (String)BeansUIPlugin.getResourceString(EDIT_BUTTON), (boolean)false, (SelectionListener)this.buttonListener);
        this.removeButton = SpringUIUtils.createButton((Composite)buttonArea, (String)BeansUIPlugin.getResourceString(REMOVE_BUTTON), (boolean)false, (SelectionListener)this.buttonListener);
        this.upButton = SpringUIUtils.createButton((Composite)buttonArea, (String)BeansUIPlugin.getResourceString(UP_BUTTON), (boolean)false, (SelectionListener)this.buttonListener);
        this.downButton = SpringUIUtils.createButton((Composite)buttonArea, (String)BeansUIPlugin.getResourceString(DOWN_BUTTON), (boolean)false, (SelectionListener)this.buttonListener);
        return composite;
    }

    private void handleTreeSelectionChanged() {
        boolean configSetButtonsEnabled = false;
        boolean moveButtonsEnabled = false;
        IStructuredSelection selection = (IStructuredSelection)this.configSetsViewer.getSelection();
        Object selected = selection.getFirstElement();
        if (selected != null) {
            if (selected instanceof ConfigSetNode) {
                this.selectedNode = (ConfigSetNode)selected;
                configSetButtonsEnabled = true;
            } else if (selected instanceof ConfigNode) {
                ConfigNode config = (ConfigNode)selected;
                ConfigSetNode configSet = (ConfigSetNode)config.getParent();
                if (configSet != null && configSet.getConfigCount() > 1) {
                    this.selectedNode = (ConfigNode)selected;
                    moveButtonsEnabled = true;
                }
            } else {
                this.selectedNode = null;
            }
        } else {
            this.selectedNode = null;
        }
        this.editButton.setEnabled(configSetButtonsEnabled);
        this.removeButton.setEnabled(configSetButtonsEnabled);
        this.upButton.setEnabled(moveButtonsEnabled);
        this.downButton.setEnabled(moveButtonsEnabled);
    }

    private void handleButtonPressed(Button button) {
        if (button == this.newButton) {
            this.handleNewButtonPressed();
        } else if (button == this.editButton) {
            this.handleEditButtonPressed();
        } else if (button == this.removeButton) {
            this.handleRemoveButtonPressed();
        } else if (button == this.upButton) {
            this.handleUpButtonPressed();
        } else if (button == this.downButton) {
            this.handleDownButtonPressed();
        }
        this.handleTreeSelectionChanged();
        this.configSetsTree.setFocus();
    }

    private void handleNewButtonPressed() {
        ConfigSetDialog dialog = new ConfigSetDialog(SpringUIUtils.getStandardDisplay().getActiveShell(), this.project, null);
        if (dialog.open() == 0) {
            this.hasUserMadeChanges = true;
        }
    }

    private void handleDoubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object elem = ((IStructuredSelection)selection).getFirstElement();
            if (elem instanceof ProjectNode) {
                if (this.configSetsViewer.getExpandedState(elem)) {
                    this.configSetsViewer.collapseToLevel(elem, -1);
                } else {
                    this.configSetsViewer.expandToLevel(elem, 1);
                }
            } else if (elem instanceof ConfigSetNode) {
                this.handleEditButtonPressed();
            }
        }
    }

    private void handleEditButtonPressed() {
        ConfigSetDialog dialog;
        if (this.selectedNode != null && this.selectedNode instanceof ConfigSetNode && (dialog = new ConfigSetDialog(SpringUIUtils.getStandardDisplay().getActiveShell(), this.project, this.selectedNode.getName())).open() == 0) {
            this.hasUserMadeChanges = true;
        }
    }

    private void handleRemoveButtonPressed() {
        if (this.selectedNode != null && this.selectedNode instanceof ConfigSetNode) {
            this.project.removeConfigSet(this.selectedNode.getName());
            this.hasUserMadeChanges = true;
        }
    }

    private void handleUpButtonPressed() {
        if (this.selectedNode != null && this.selectedNode instanceof ConfigNode) {
            ConfigNode config = (ConfigNode)this.selectedNode;
            ConfigSetNode configSet = (ConfigSetNode)config.getParent();
            configSet.moveConfigUp(config);
            this.hasUserMadeChanges = true;
        }
    }

    private void handleDownButtonPressed() {
        if (this.selectedNode != null && this.selectedNode instanceof ConfigNode) {
            ConfigNode config = (ConfigNode)this.selectedNode;
            ConfigSetNode configSet = (ConfigSetNode)config.getParent();
            configSet.moveConfigDown(config);
            this.hasUserMadeChanges = true;
        }
    }

    private void handlePropertyChanged(Object source, int propId) {
        if (this.configSetsViewer != null && !this.configSetsViewer.getControl().isDisposed()) {
            this.configSetsViewer.refresh();
        }
    }

    public void dispose() {
        this.project.removePropertyListener(this.propertyListener);
    }

    private class ConfigSetsSorter
    extends ViewerSorter {
        ConfigSetsSorter() {
        }

        public void sort(Viewer viewer, Object[] elements) {
            if (elements.length > 0 && !(elements[0] instanceof ConfigNode)) {
                super.sort(viewer, elements);
            }
        }
    }
}

