/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.ui.IPropertyListener;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.beans.ui.model.AbstractNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigSetNode;
import org.springframework.ide.eclipse.beans.ui.model.INode;
import org.springframework.ide.eclipse.core.model.IModelElement;

public class ProjectNode
extends AbstractNode {
    public static final int CONFIGS = 1;
    public static final int CONFIG_SETS = 2;
    private Map configs;
    private Map configSets;
    private ListenerList listeners;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ProjectNode(INode parent, String name) {
        super(parent, name);
        this.setElement((IModelElement)BeansCorePlugin.getModel().getProject(name));
        this.configs = new HashMap();
        this.configSets = new HashMap();
        this.listeners = new ListenerList();
    }

    public IBeansProject getProject() {
        return (IBeansProject)this.getElement();
    }

    public void addPropertyListener(IPropertyListener listener) {
        this.listeners.add((Object)listener);
    }

    public void propertyChanged(INode node, int propertyId) {
        AbstractNode parent = (AbstractNode)this.getParent();
        if (parent == null) {
            Object[] array = this.listeners.getListeners();
            int i = 0;
            while (i < array.length) {
                IPropertyListener listener = (IPropertyListener)array[i];
                listener.propertyChanged((Object)node, propertyId);
                ++i;
            }
        } else {
            parent.propertyChanged(node, propertyId);
        }
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void setConfigs(Collection configs) {
        this.configs.clear();
        Iterator iter = configs.iterator();
        while (iter.hasNext()) {
            this.addConfig((String)iter.next());
        }
        this.propertyChanged(this, 1);
    }

    public void addConfig(String name) {
        ConfigNode node = this.getConfig(name);
        if (node == null) {
            node = new ConfigNode(this, name);
            this.configs.put(name, node);
            this.propertyChanged(this, 1);
        }
    }

    public boolean hasConfig(String name) {
        return this.configs.containsKey(name);
    }

    public ConfigNode getConfig(IFile file) {
        return this.getConfig(file.getProjectRelativePath().toString());
    }

    public ConfigNode getConfig(String name) {
        return this.configs.containsKey(name) ? (ConfigNode)this.configs.get(name) : null;
    }

    public List getConfigs() {
        return new ArrayList(this.configs.values());
    }

    public List getConfigNames() {
        return new ArrayList(this.configs.keySet());
    }

    public boolean hasConfigs() {
        return !this.configs.isEmpty();
    }

    public void removeConfig(String name) {
        ConfigNode config = (ConfigNode)this.configs.remove(name);
        if (config != null) {
            Iterator iter = this.configSets.values().iterator();
            while (iter.hasNext()) {
                ConfigSetNode configSet = (ConfigSetNode)iter.next();
                configSet.removeConfig(name);
            }
            this.propertyChanged(this, 1);
        }
    }

    public void setConfigSets(Collection configSets) {
        this.configSets.clear();
        Iterator iter = configSets.iterator();
        while (iter.hasNext()) {
            this.addConfigSet((IBeansConfigSet)iter.next());
        }
        this.propertyChanged(this, 2);
    }

    public void addConfigSet(IBeansConfigSet configSet) {
        String name = configSet.getElementName();
        ConfigSetNode node = this.getConfigSet(name);
        if (node == null) {
            node = new ConfigSetNode(this, configSet);
            this.addConfigSet(node);
            this.propertyChanged(this, 2);
        }
    }

    public void addConfigSet(ConfigSetNode configSet) {
        this.configSets.put(configSet.getName(), configSet);
        this.propertyChanged(this, 2);
    }

    public boolean hasConfigSet(String name) {
        return this.configSets.containsKey(name);
    }

    public ConfigSetNode getConfigSet(String name) {
        return this.configSets.containsKey(name) ? (ConfigSetNode)this.configSets.get(name) : null;
    }

    public List getConfigSets() {
        return new ArrayList(this.configSets.values());
    }

    public void removeConfigSet(String name) {
        ConfigSetNode configSet = (ConfigSetNode)this.configSets.remove(name);
        if (configSet != null) {
            this.propertyChanged(this, 2);
        }
    }

    public void remove(INode node) {
        if (node instanceof ConfigNode) {
            this.configs.remove(node.getName());
            Iterator iter = this.configSets.values().iterator();
            while (iter.hasNext()) {
                ConfigSetNode configSet = (ConfigSetNode)iter.next();
                configSet.remove(node);
            }
        } else {
            this.configSets.remove(node.getName());
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return BeansUIUtils.getPropertySource((IModelElement)this.getProject());
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.springframework.ide.eclipse.core.model.IModelElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            return this.getProject();
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(this.getName());
        text.append(": configs=");
        text.append(this.configs);
        text.append(": configSets=");
        text.append(this.configSets);
        return text.toString();
    }
}

